/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.heat.circulationpump;

import com.denfop.container.ContainerHeatCirculationPump;
import com.denfop.gui.GuiHeatCirculationPump;
import com.denfop.invslot.InvSlot;
import com.denfop.items.reactors.ItemsPumps;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.heat.ICirculationPump;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseCirculationPump
extends TileEntityMultiBlockElement
implements ICirculationPump {
    private final int level;
    private final InvSlot slot;
    private int power;
    private int energy;

    public TileEntityBaseCirculationPump(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ItemsPumps && ((ItemsPumps)stack.func_77973_b()).getLevel() <= ((TileEntityBaseCirculationPump)this.base).getBlockLevel();
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    ((TileEntityBaseCirculationPump)this.base).setEnergy(0);
                    ((TileEntityBaseCirculationPump)this.base).setPower(0);
                } else {
                    ((TileEntityBaseCirculationPump)this.base).setEnergy(((ItemsPumps)content.func_77973_b()).getEnergy());
                    ((TileEntityBaseCirculationPump)this.base).setPower(((ItemsPumps)content.func_77973_b()).getPower());
                }
            }
        };
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && !this.getSlot().get().func_190926_b() && ((ItemsPumps)this.getSlot().get().func_77973_b()).getDurabilityForDisplay(this.getSlot().get()) == 1.0) {
            this.getSlot().put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            if (this.getSlot().get().func_190926_b()) {
                this.setEnergy(0);
                this.setPower(0);
            } else {
                this.setEnergy(((ItemsPumps)this.getSlot().get().func_77973_b()).getEnergy());
                this.setPower(((ItemsPumps)this.getSlot().get().func_77973_b()).getPower());
            }
        }
    }

    public ContainerHeatCirculationPump getGuiContainer(EntityPlayer var1) {
        return new ContainerHeatCirculationPump(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiHeatCirculationPump(this.getGuiContainer(var1));
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }
}

