/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.heat.controller;

import com.denfop.Config;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.multiblock.IMultiElement;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.EnumTypeWork;
import com.denfop.api.reactors.IHeatReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.InvSlotReactorModules;
import com.denfop.api.reactors.LogicHeatReactor;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerHeatReactor;
import com.denfop.gui.GuiHeatController;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotScheduleReactor;
import com.denfop.items.reactors.ItemsPumps;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.heat.ICirculationPump;
import com.denfop.tiles.reactors.heat.ICoolant;
import com.denfop.tiles.reactors.heat.IGraphiteController;
import com.denfop.tiles.reactors.heat.IPump;
import com.denfop.tiles.reactors.heat.ISocket;
import com.denfop.tiles.reactors.heat.ITank;
import com.denfop.tiles.reactors.heat.controller.EnumHeatReactors;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMainController
extends TileMultiBlockBase
implements IHeatReactor,
IUpdatableTileEvent {
    public final EnumHeatReactors enumFluidReactors;
    public final InvSlot reactorsElements;
    public final InvSlotReactorModules<TileEntityMainController> reactorsModules;
    public final InvSlotScheduleReactor scheduleReactor;
    private final ComponentBaseEnergy rad;
    public Timer timer = new Timer(9999, 0, 0);
    public Timer red_timer = new Timer(0, 2, 30);
    public Timer yellow_timer = new Timer(0, 15, 0);
    public Energy energy;
    public EnumTypeWork typeWork = EnumTypeWork.WORK;
    public int pressure = 1;
    public boolean work = false;
    public double heat;
    public double output = 0.0;
    public LogicHeatReactor reactor;
    public EnumTypeSecurity security = EnumTypeSecurity.NONE;
    public int level = 0;
    public boolean heat_sensor;
    public boolean stable_sensor;
    public List<Fluids.InternalFluidTank> cells = new ArrayList<Fluids.InternalFluidTank>();
    private List<IGraphiteController> listGraphiteController = new ArrayList<IGraphiteController>();
    private Map<Integer, int[]> integerMap = new HashMap<Integer, int[]>();
    private List<ICoolant> listCoolant = new ArrayList<ICoolant>();
    private List<ICirculationPump> listCirculationPump = new ArrayList<ICirculationPump>();
    private List<IPump> listPump = new ArrayList<IPump>();

    public TileEntityMainController(MultiBlockStructure multiBlockStructure, EnumHeatReactors enumFluidReactors) {
        super(multiBlockStructure);
        this.enumFluidReactors = enumFluidReactors;
        this.reactorsElements = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, enumFluidReactors.getHeight() * enumFluidReactors.getWidth()){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (TileEntityMainController.this.scheduleReactor.getAccepts().isEmpty()) {
                    if (stack.func_77973_b() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.func_77973_b();
                        return ((TileEntityMainController)this.base).getLevelReactor() >= iReactorItem.getLevel();
                    }
                    return false;
                }
                ItemStack stack1 = TileEntityMainController.this.scheduleReactor.getAccepts().get(index);
                if (stack1.func_190926_b()) {
                    return false;
                }
                return stack1.func_77969_a(stack);
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityMainController.this.reactor = null;
            }
        };
        this.reactorsModules = new InvSlotReactorModules<TileEntityMainController>(this);
        this.reactorsElements.setStackSizeLimit(1);
        this.scheduleReactor = new InvSlotScheduleReactor(this, 4, enumFluidReactors.ordinal() + 1, enumFluidReactors.getWidth(), enumFluidReactors.getHeight());
        this.rad = this.addComponent(new ComponentBaseEnergy(EnergyType.RADIATION, this, enumFluidReactors.getRadiation() * 100.0));
    }

    @Override
    public double getModuleExchanger() {
        return this.reactorsModules.getExchanger();
    }

    public LogicReactor getReactor() {
        if (this.reactor == null) {
            this.reactor = new LogicHeatReactor(this);
        }
        return this.reactor;
    }

    @Override
    public double getModuleStableHeat() {
        return this.reactorsModules.getStableHeat();
    }

    @Override
    public double getModuleRadiation() {
        return this.reactorsModules.getRadiation();
    }

    @Override
    public double getModuleGeneration() {
        return this.reactorsModules.getGeneration();
    }

    @Override
    public double getModuleVent() {
        return this.reactorsModules.getVent();
    }

    @Override
    public double getModuleComponentVent() {
        return this.reactorsModules.getComponentVent();
    }

    @Override
    public double getModuleCapacitor() {
        return this.reactorsModules.getCapacitor();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("pressure")) {
            try {
                this.pressure = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("reactor")) {
            if (this.reactor == null) {
                this.reactor = new LogicHeatReactor(this);
            }
            try {
                this.reactor.setGeneration((Integer)DecoderHandler.decode(is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.energy = null;
            this.cells.clear();
            this.listPump.clear();
            this.listCirculationPump.clear();
            this.listGraphiteController.clear();
            this.listCoolant.clear();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0) {
            if (this.level > 0) {
                this.setWork(!this.work);
            }
        } else if (var2 == 1.0) {
            ++this.pressure;
            this.pressure = Math.min(5, this.pressure);
        } else if (var2 == 2.0) {
            --this.pressure;
            this.pressure = Math.max(1, this.pressure);
        } else if (var2 == -1.0) {
            if (!this.stable_sensor) {
                this.heat_sensor = !this.heat_sensor;
            }
        } else if (var2 == -2.0) {
            if (!this.heat_sensor) {
                this.stable_sensor = !this.stable_sensor;
            }
        } else if (this.typeWork == EnumTypeWork.WORK && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.LEVEL_INCREASE;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.level) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        } else if (this.typeWork == EnumTypeWork.LEVEL_INCREASE && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.WORK;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            this.energy.setCapacity(this.energy.defaultCapacity);
            this.energy.storage = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.scheduleReactor.update();
            this.reactorsModules.load();
            try {
                if (this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
                    this.energy.onUnloaded();
                    this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
                    this.energy.delegate = null;
                    this.energy.createDelegate();
                    this.energy.onLoaded();
                    switch (this.level) {
                        case 0: {
                            this.energy.setCapacity(4000000.0);
                            break;
                        }
                        case 1: {
                            this.energy.setCapacity(5.0E7);
                            break;
                        }
                        case 2: {
                            this.energy.setCapacity(2.0E8);
                            break;
                        }
                        case 3: {
                            this.energy.setCapacity(5.0E8);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ChunkPos chunkPos = this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.add(this);
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.func_145831_w().field_72995_K) {
            ChunkPos chunkPos = this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.remove(this);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.reactor == null) {
            this.reactor = new LogicHeatReactor(this);
            this.reactor.temp_heat = this.heat;
            new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        } else if (this.full) {
            if (this.typeWork == EnumTypeWork.WORK) {
                this.energy.capacity = Math.max(this.output, this.energy.getDefaultCapacity());
                if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && this.work) {
                    this.reactor.onTick();
                    if (this.rad.getEnergy() >= this.rad.getCapacity() * 0.5 && this.rad.getEnergy() < this.rad.getCapacity() * 0.75) {
                        this.setSecurity(EnumTypeSecurity.UNSTABLE);
                    }
                    this.workTimer();
                    if (!this.timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (!this.yellow_timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (!this.red_timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (this.reactor != null && this.getHeat() >= (double)this.getMaxHeat() && this.reactor.getMaxHeat() >= (double)this.getMaxHeat() * 1.5) {
                        this.explode();
                        this.reactor = null;
                    }
                }
                if (this.work && this.reactor != null) {
                    this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.output));
                    this.energy.addEnergy(this.output);
                }
            } else if (this.energy.getEnergy() >= this.energy.getCapacity()) {
                ++this.level;
                this.typeWork = EnumTypeWork.WORK;
                this.energy.onUnloaded();
                this.energy.setCapacity(this.energy.defaultCapacity);
                this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
                this.energy.delegate = null;
                this.energy.createDelegate();
                this.energy.onLoaded();
                this.energy.storage = 0.0;
            }
        }
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.pressure = customPacketBuffer.readInt();
        this.work = customPacketBuffer.readBoolean();
        boolean socket = customPacketBuffer.readBoolean();
        if (socket) {
            try {
                this.energy.onNetworkUpdate(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.heat = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        try {
            this.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.level = customPacketBuffer.readInt();
        this.typeWork = EnumTypeWork.values()[customPacketBuffer.readInt()];
        try {
            this.red_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.yellow_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.pressure);
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.energy != null);
        if (this.energy != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.energy, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeDouble(this.output);
        this.timer.writeBuffer(customPacketBuffer);
        customPacketBuffer.writeInt(this.level);
        customPacketBuffer.writeInt(this.typeWork.ordinal());
        this.red_timer.writeBuffer(customPacketBuffer);
        this.yellow_timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
        this.pressure = nbttagcompound.func_74762_e("pressure");
        this.level = nbttagcompound.func_74762_e("level");
        this.timer.readNBT(nbttagcompound);
        this.red_timer.readNBT(nbttagcompound.func_74775_l("red"));
        this.yellow_timer.readNBT(nbttagcompound.func_74775_l("yellow"));
        this.heat = nbttagcompound.func_74769_h("heat");
        this.typeWork = EnumTypeWork.values()[nbttagcompound.func_74762_e("typeWork")];
    }

    public Timer getYellow_timer() {
        return this.yellow_timer;
    }

    public Timer getRed_timer() {
        return this.red_timer;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbt = super.func_189515_b(nbttagcompound);
        nbt.func_74757_a("work", this.work);
        nbt.func_74768_a("pressure", this.pressure);
        nbt.func_74768_a("level", this.level);
        this.timer.writeNBT(nbt);
        NBTTagCompound nbt1 = new NBTTagCompound();
        this.red_timer.writeNBT(nbt1);
        nbt.func_74782_a("red", (NBTBase)nbt1);
        NBTTagCompound nbt2 = new NBTTagCompound();
        this.yellow_timer.writeNBT(nbt2);
        nbt.func_74782_a("yellow", (NBTBase)nbt2);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74768_a("typeWork", this.typeWork.ordinal());
        return nbt;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        return super.writePacket();
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        return super.writeUpdatePacket();
    }

    @Override
    public void updateAfterAssembly() {
        IMultiElement compressor;
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        for (int i = 0; i < pos1.size(); ++i) {
            int k = i % 4;
            ITank tank = (ITank)this.func_145831_w().func_175625_s(pos1.get(i));
            if (tank == null) continue;
            switch (k) {
                case 0: {
                    tank.setFluid(FluidRegistry.WATER);
                    if (tank.getTank().getFluid() == null || tank.getTank().getFluid().getFluid().equals(FluidRegistry.WATER)) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), true);
                    break;
                }
                case 1: {
                    tank.setFluid(FluidName.fluidoxy.getInstance());
                    if (tank.getTank().getFluid() == null || tank.getTank().getFluid().getFluid().equals(FluidName.fluidoxy.getInstance())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), true);
                    break;
                }
                case 2: {
                    tank.setFluid(FluidName.fluidhyd.getInstance());
                    if (tank.getTank().getFluid() == null || tank.getTank().getFluid().getFluid().equals(FluidName.fluidhyd.getInstance())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), true);
                    break;
                }
                case 3: {
                    tank.setFluid(FluidName.fluidHelium.getInstance());
                    if (tank.getTank().getFluid() == null || tank.getTank().getFluid().getFluid().equals(FluidName.fluidHelium.getInstance())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), true);
                }
            }
            this.cells.add(tank.getTank());
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IGraphiteController.class);
        for (BlockPos pos2 : pos1) {
            IGraphiteController recirculationPump = (IGraphiteController)this.func_145831_w().func_175625_s(pos2);
            this.listGraphiteController.add(recirculationPump);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IPump.class);
        for (BlockPos pos2 : pos1) {
            IPump iInterCooler = (IPump)this.func_145831_w().func_175625_s(pos2);
            this.listPump.add(iInterCooler);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICirculationPump.class);
        for (BlockPos pos2 : pos1) {
            compressor = (ICirculationPump)this.func_145831_w().func_175625_s(pos2);
            this.listCirculationPump.add((ICirculationPump)compressor);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICoolant.class);
        for (BlockPos pos2 : pos1) {
            compressor = (ICoolant)this.func_145831_w().func_175625_s(pos2);
            this.listCoolant.add((ICoolant)compressor);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        for (BlockPos pos2 : pos1) {
            ISocket socket = (ISocket)this.func_145831_w().func_175625_s(pos2);
            this.energy = socket.getEnergy();
        }
        this.reactor = new LogicHeatReactor(this);
        this.integerMap.clear();
        for (int i = 0; i < this.getWidth(); ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < this.listGraphiteController.size(); ++j) {
                if (this.listGraphiteController.get(j).getIndex() != i) continue;
                list.add(j);
            }
            this.integerMap.put(i, list.stream().mapToInt(jj -> jj).toArray());
        }
        this.reactor.temp_heat = this.heat;
        new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        this.reactorsModules.load();
        if (this.isFull() && this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.level) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public boolean isWork() {
        return this.work;
    }

    @Override
    public void setWork(boolean work) {
        this.work = work;
        if (this.work) {
            this.setSecurity(EnumTypeSecurity.STABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.NONE);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiHeatController(this.getGuiContainer(var1));
    }

    public ContainerHeatReactor getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerHeatReactor(this, entityPlayer);
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(double var1) {
        this.heat = var1;
        if (this.heat > (double)this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
        if (this.getStableMaxHeat() == 0) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat < (double)this.getStableMaxHeat()) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat >= (double)this.getStableMaxHeat() && this.heat <= (double)this.getStableMaxHeat() + (double)(this.getMaxHeat() - this.getStableMaxHeat()) * 0.75) {
            this.setSecurity(EnumTypeSecurity.UNSTABLE);
            this.setTime(EnumTypeSecurity.UNSTABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.ERROR);
            this.setTime(EnumTypeSecurity.ERROR);
        }
    }

    @Override
    public void setUpdate() {
        this.reactor = null;
    }

    @Override
    public int getBlockLevel() {
        return this.enumFluidReactors.ordinal();
    }

    @Override
    public int getMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxHeat() * this.reactorsModules.getStableHeat());
    }

    @Override
    public int getStableMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxStable() * this.reactorsModules.getStableHeat());
    }

    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public double getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(double output) {
        this.output = output * this.reactorsModules.getGeneration();
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.reactorsElements.get(y * this.getWidth() + x);
    }

    @Override
    public void setItemAt(int x, int y) {
        this.reactorsElements.set(y * this.getWidth() + x, ItemStack.field_190927_a);
    }

    @Override
    public void explode() {
        BlockPos pos1;
        int weight = this.getMultiBlockStucture().maxWeight + this.getMultiBlockStucture().minWeight;
        int height = this.getMultiBlockStucture().maxHeight + this.getMultiBlockStucture().minHeight;
        int length = this.getMultiBlockStucture().maxLength + this.getMultiBlockStucture().maxLength;
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        ChunkPos chunkPos = this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                chunkPosList.add(new ChunkPos(chunkPos.field_77276_a + x, chunkPos.field_77275_b + z));
            }
        }
        double rad = this.rad.getEnergy() / 9.0;
        this.setFull(false);
        this.activate = false;
        Explosion explosion = new Explosion(this.field_145850_b, null, (double)(this.func_174877_v().func_177958_n() + weight), (double)(this.func_174877_v().func_177956_o() + height), (double)(this.func_174877_v().func_177952_p() + length), 25.0f, false, true);
        if (Config.explodeReactor) {
            if (ForgeEventFactory.onExplosionStart((World)this.func_145831_w(), (Explosion)explosion)) {
                return;
            }
            this.field_145850_b.func_175698_g(this.field_174879_c);
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.getMultiBlockStucture().blockPosMap.entrySet()) {
                if (this.field_145850_b.field_73012_v.nextInt(2) == 0) continue;
                switch (EnumFacing.values()[this.facing]) {
                    case NORTH: {
                        pos1 = this.field_174879_c.func_177971_a((Vec3i)entry.getKey());
                        break;
                    }
                    case EAST: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                        break;
                    }
                    case WEST: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                        break;
                    }
                    case SOUTH: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + this.facing);
                    }
                }
                this.field_145850_b.func_175698_g(pos1);
            }
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.getMultiBlockStucture().blockPosMap.entrySet()) {
                if (this.field_145850_b.field_73012_v.nextInt(2) == 0) continue;
                switch (EnumFacing.values()[this.facing]) {
                    case NORTH: {
                        pos1 = this.field_174879_c.func_177971_a((Vec3i)entry.getKey());
                        break;
                    }
                    case EAST: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                        break;
                    }
                    case WEST: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                        break;
                    }
                    case SOUTH: {
                        pos1 = this.field_174879_c.func_177982_a(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + this.facing);
                    }
                }
                this.field_145850_b.func_175698_g(pos1);
            }
        }
        if (this.field_145850_b.field_73011_w.getDimension() == 0) {
            for (ChunkPos pos12 : chunkPosList) {
                if (!pos12.equals((Object)chunkPos)) {
                    new PacketUpdateRadiationValue(pos12, (int)(rad * 10.0));
                    continue;
                }
                new PacketUpdateRadiationValue(pos12, (int)(rad * 50.0));
            }
        }
        if (Config.explodeReactor) {
            new PacketExplosion(explosion, 25, false, true);
        }
    }

    public EnumTypeWork getTypeWork() {
        return this.typeWork;
    }

    public ComponentBaseEnergy getRad() {
        return this.rad;
    }

    @Override
    public void setRad(double rad) {
        this.rad.addEnergy(rad * this.reactorsModules.getRadiation());
        if (this.rad.getEnergy() >= this.rad.getCapacity()) {
            this.explode();
        }
    }

    @Override
    public ITypeRector getTypeRector() {
        return ITypeRector.FLUID;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTime(EnumTypeSecurity enumTypeSecurity) {
        if (this.security == enumTypeSecurity) {
            switch (enumTypeSecurity) {
                case STABLE: {
                    this.timer = new Timer(9999, 0, 0);
                    break;
                }
                case ERROR: {
                    this.timer = new Timer(0, 2, 30);
                    break;
                }
                case UNSTABLE: {
                    this.timer = new Timer(0, 15, 0);
                }
            }
        }
    }

    @Override
    public void workTimer() {
        switch (this.security) {
            case UNSTABLE: {
                this.yellow_timer.work();
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case STABLE: {
                this.timer.work();
                if (!this.yellow_timer.getMinute(15)) {
                    this.yellow_timer.rework();
                }
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case ERROR: {
                this.red_timer.work();
            }
        }
    }

    @Override
    public EnumTypeSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void setSecurity(EnumTypeSecurity enumTypeSecurity) {
        if (this.security != enumTypeSecurity) {
            this.security = enumTypeSecurity;
            new PacketUpdateFieldTile(this, "security", (Object)this.security);
        }
    }

    @Override
    public int getWidth() {
        return this.enumFluidReactors.getWidth();
    }

    @Override
    public int getHeight() {
        return this.enumFluidReactors.getHeight();
    }

    @Override
    public int getLevelReactor() {
        return this.level;
    }

    @Override
    public int getMaxLevelReactor() {
        return this.enumFluidReactors.ordinal() + 1;
    }

    @Override
    public void increaseLevelReactor() {
        ++this.level;
    }

    @Override
    public ComponentBaseEnergy getRadiation() {
        return this.rad;
    }

    @Override
    public FluidTank getWaterTank() {
        return this.cells.get(0);
    }

    @Override
    public FluidTank getOxygenTank() {
        return this.cells.get(1);
    }

    @Override
    public FluidTank getHydrogenTank() {
        return this.cells.get(2);
    }

    @Override
    public FluidTank getHeliumTank() {
        return this.cells.get(3);
    }

    @Override
    public int[] getLengthGraphiteIndex(int index) {
        return this.integerMap.get(index);
    }

    @Override
    public ItemStack getGraphite(int index) {
        return this.listGraphiteController.get(index).getGraphite();
    }

    @Override
    public int getLevelGraphite(int index) {
        return this.listGraphiteController.get(index).getLevelGraphite();
    }

    @Override
    public double getFuelGraphite(int index) {
        return this.listGraphiteController.get(index).getFuelGraphite();
    }

    @Override
    public void consumeFuelGraphite(int index, double fuel) {
        this.listGraphiteController.get(index).consumeFuelGraphite(fuel);
    }

    @Override
    public void consumeGraphite(int index) {
        this.listGraphiteController.get(index).consumeGraphite();
    }

    @Override
    public int getLengthPump() {
        return this.listCirculationPump.size();
    }

    @Override
    public int getPowerPump(int i) {
        return this.listCirculationPump.get(i).getPower();
    }

    @Override
    public int getEnergyPump(int i) {
        return this.listCirculationPump.get(i).getEnergy();
    }

    @Override
    public void damagePump(int i) {
        ((ItemsPumps)this.listCirculationPump.get(i).getSlot().get().func_77973_b()).applyCustomDamage(this.listCirculationPump.get(i).getSlot().get(), -1, null);
    }

    @Override
    public int getLengthSimplePump() {
        return this.listPump.size();
    }

    @Override
    public int getPowerSimplePump(int i) {
        return this.listPump.get(i).getPower();
    }

    @Override
    public int getEnergySimplePump(int i) {
        return this.listPump.get(i).getEnergy();
    }

    @Override
    public void addHeliumToRegenerate(double col) {
        for (ICoolant coolant : this.listCoolant) {
            if (!(coolant.getMaxRegenerate() - coolant.getHeliumToRegenerate() > 0.0)) continue;
            int col1 = (int)Math.min(col, coolant.getMaxRegenerate() - coolant.getHeliumToRegenerate());
            coolant.addHeliumToRegenerate(col1);
            col -= (double)col1;
        }
    }

    @Override
    public double getHeliumToRegenerate() {
        int helium = 0;
        for (ICoolant coolant : this.listCoolant) {
            helium += (int)coolant.getHeliumToRegenerate();
        }
        return helium;
    }

    @Override
    public double getMulOutput(int x, int y, ItemStack stack) {
        int[] ints = this.integerMap.get(x);
        if (ints != null) {
            double level1 = 1.0;
            for (int i : ints) {
                if (i >= this.listGraphiteController.size()) {
                    return 0.0;
                }
                double level = 1.0 + ((double)this.listGraphiteController.get(i).getLevelGraphite() - 0.25) * 0.05;
                level1 *= level;
            }
            return level1;
        }
        return 1.0;
    }

    @Override
    public void updateDataReactor() {
        this.reactor = null;
        this.integerMap.clear();
        for (int i = 0; i < this.getWidth(); ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < this.listGraphiteController.size(); ++j) {
                if (this.listGraphiteController.get(j).getIndex() != i) continue;
                list.add(j);
            }
            this.integerMap.put(i, list.stream().mapToInt(jj -> jj).toArray());
        }
    }
}

