/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.heat.graphite_controller;

import com.denfop.api.reactors.IHeatReactor;
import com.denfop.container.ContainerHeatGraphiteController;
import com.denfop.gui.GuiHeatGraphiteGraphiteController;
import com.denfop.invslot.InvSlot;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.heat.IGraphiteController;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGraphiteController
extends TileEntityMultiBlockElement
implements IGraphiteController,
IUpdatableTileEvent {
    public final InvSlot slot;
    private final int level;
    public double fuel;
    public int levelGraphite = 1;
    private int index;

    public TileEntityGraphiteController(int level) {
        this.level = level;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemCraftingElements)) {
                    return false;
                }
                int itemDamage = stack.func_77952_i();
                switch (itemDamage) {
                    case 357: {
                        return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 0;
                    }
                    case 410: {
                        return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 1;
                    }
                    case 310: {
                        return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 2;
                    }
                    case 368: {
                        return ((TileEntityGraphiteController)this.base).getBlockLevel() >= 3;
                    }
                }
                return false;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    ((TileEntityGraphiteController)this.base).fuel = 0.0;
                }
            }
        };
    }

    public double getFuel() {
        return this.fuel;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    public ContainerHeatGraphiteController getGuiContainer(EntityPlayer var1) {
        return new ContainerHeatGraphiteController(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiHeatGraphiteGraphiteController(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.index);
        customPacketBuffer.writeDouble(this.fuel);
        customPacketBuffer.writeInt(this.levelGraphite);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.index = customPacketBuffer.readInt();
        this.fuel = customPacketBuffer.readDouble();
        this.levelGraphite = customPacketBuffer.readInt();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.fuel = nbtTagCompound.func_74769_h("fuel");
        this.levelGraphite = nbtTagCompound.func_74762_e("levelGraphite");
        this.index = nbtTagCompound.func_74762_e("index");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74780_a("fuel", this.fuel);
        nbtTagCompound.func_74768_a("index", this.index);
        nbtTagCompound.func_74768_a("levelGraphite", this.levelGraphite);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    @Override
    public ItemStack getGraphite() {
        return this.slot.get();
    }

    @Override
    public int getLevelGraphite() {
        return this.levelGraphite;
    }

    @Override
    public double getFuelGraphite() {
        return this.fuel;
    }

    @Override
    public void consumeFuelGraphite(double col) {
        this.fuel -= col;
    }

    @Override
    public void consumeGraphite() {
        if (!this.slot.get().func_190926_b()) {
            int itemDamage = this.slot.get().func_77952_i();
            this.slot.get().func_190918_g(1);
            switch (itemDamage) {
                case 357: {
                    this.fuel = 100.0;
                    break;
                }
                case 410: {
                    this.fuel = 500.0;
                    break;
                }
                case 310: {
                    this.fuel = 2500.0;
                    break;
                }
                case 368: {
                    this.fuel = 5000.0;
                }
            }
        } else {
            this.fuel = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.levelGraphite = Math.max(1, this.levelGraphite);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (this.getMain() != null) {
            IHeatReactor heatReactor = (IHeatReactor)this.getMain();
            if (var2 == 0.0) {
                this.levelGraphite = Math.min(this.levelGraphite + 1, 5);
            } else if (var2 == 1.0) {
                this.levelGraphite = Math.max(1, this.levelGraphite - 1);
            } else if (var2 == 2.0) {
                this.index = Math.min(this.index + 1, heatReactor.getWidth() - 1);
            } else if (var2 == 3.0) {
                this.index = Math.max(this.index - 1, 0);
            }
            heatReactor.updateDataReactor();
        }
    }
}

