/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.water.inputfluid;

import com.denfop.componets.Fluids;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class FluidHandlerReactor
implements IFluidHandler {
    private final List<Fluids> list;
    private final IFluidTankProperties[] fluidTankProperties;

    public FluidHandlerReactor(List<Fluids> list) {
        this.list = list;
        this.fluidTankProperties = new IFluidTankProperties[this.list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.fluidTankProperties[i] = this.list.get(i).getAllTanks().iterator().next().getTankProperties()[0];
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.fluidTankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            int f = fluids.getAllTanks().iterator().next().fill(resource, doFill);
            if (f == 0) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().fill(resource, doFill) : 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            FluidStack f = fluids.getAllTanks().iterator().next().drain(resource, doDrain);
            if (f == null) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().drain(resource, doDrain) : null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            FluidStack f = fluids.getAllTanks().iterator().next().drain(maxDrain, doDrain);
            if (f == null) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().drain(maxDrain, doDrain) : null;
    }
}

