/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.smeltery;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSmeltery;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerSmelteryController;
import com.denfop.gui.GuiSmelteryController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.smeltery.ICasting;
import com.denfop.tiles.smeltery.IController;
import com.denfop.tiles.smeltery.IFuelTank;
import com.denfop.tiles.smeltery.IFurnace;
import com.denfop.tiles.smeltery.ITank;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySmelteryController
extends TileMultiBlockBase
implements IController,
IHasRecipe,
IUpdatableTileEvent {
    public static Map<List<FluidStack>, FluidStack> mapRecipes = new HashMap<List<FluidStack>, FluidStack>();
    public static Map<FluidStack, List<FluidStack>> mapRecipes1 = new HashMap<FluidStack, List<FluidStack>>();
    private final FluidHandlerRecipe[] fluidManager;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public boolean work = false;
    public int progress;
    public List<Integer> list = new ArrayList<Integer>();
    public List<ITank> listTank = new ArrayList<ITank>();
    public FluidTank firstTank = null;
    public List<IFuelTank> listFuelTank = new ArrayList<IFuelTank>();
    public ICasting casting;
    public List<IFurnace> furnaces = new ArrayList<IFurnace>();
    private Integer prevIndex;

    public TileEntitySmelteryController() {
        super(InitMultiBlockSystem.SmelterMultiBlock);
        this.fluidManager = new FluidHandlerRecipe[3];
        for (int i = 0; i < 3; ++i) {
            this.fluidManager[i] = new FluidHandlerRecipe("smeltery");
        }
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.4));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
    }

    @Override
    public FluidTank getFirstTank() {
        return this.firstTank;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        block25: {
            List fluidTanks1;
            block27: {
                block26: {
                    if (var2 >= 0.0 && var2 <= 18.0) {
                        if (this.list.contains((int)var2)) {
                            this.list.removeIf(i -> i == (int)var2);
                        } else {
                            this.list.add((int)var2);
                        }
                        if (!this.casting.getInputSlotB().isEmpty()) {
                            Object controller;
                            this.casting.getFluid_handler().setOutput(null);
                            this.casting.getFluid_handler().setName("empty");
                            int damage = this.casting.getInputSlotB().get().func_77952_i();
                            if (damage == 496) {
                                this.casting.getFluid_handler().setName("ingot_casting");
                                if (this.getMain() != null) {
                                    controller = (TileEntitySmelteryController)this.getMain();
                                    this.casting.getFluid_handler().load();
                                    this.casting.getFluid_handler().getOutput(((TileEntitySmelteryController)controller).getFirstTank());
                                }
                            } else if (damage == 497) {
                                this.casting.getFluid_handler().setName("gear_casting");
                                if (this.getMain() != null) {
                                    controller = (TileEntitySmelteryController)this.getMain();
                                    this.casting.getFluid_handler().load();
                                    this.casting.getFluid_handler().getOutput(((TileEntitySmelteryController)controller).getFirstTank());
                                }
                            } else {
                                this.casting.getFluid_handler().load();
                            }
                        }
                        this.casting.getFluid_handler().setOutput(null);
                        if (this.list.isEmpty()) {
                            this.firstTank = null;
                        }
                    }
                    if (var2 != -1.0) break block26;
                    ArrayList<FluidTank> fluidTanks = new ArrayList<FluidTank>();
                    for (ITank iTank : this.listTank) {
                        fluidTanks.add(iTank.getTank());
                    }
                    fluidTanks1 = fluidTanks.stream().sorted((tank1, tank2) -> {
                        boolean hasFluid2;
                        FluidStack fluid1 = tank1.getFluid();
                        FluidStack fluid2 = tank2.getFluid();
                        boolean hasFluid1 = fluid1 != null && fluid1.amount > 0;
                        boolean bl = hasFluid2 = fluid2 != null && fluid2.amount > 0;
                        if (hasFluid1 && !hasFluid2) {
                            return -1;
                        }
                        if (!hasFluid1 && hasFluid2) {
                            return 1;
                        }
                        return 0;
                    }).collect(Collectors.toList());
                    block1: for (Map.Entry<List<FluidStack>, FluidStack> entry : mapRecipes.entrySet()) {
                        if (entry.getKey().size() != this.list.size() || !this.fluidManager[0].canFillFluid(entry.getValue())) continue;
                        HashMap<Integer, FluidStack> fluidStackMap = new HashMap<Integer, FluidStack>();
                        for (FluidStack fluidStack2 : entry.getKey()) {
                            boolean canDrain = false;
                            for (Integer integer2 : this.list) {
                                FluidTank tank = (FluidTank)fluidTanks1.get(integer2);
                                canDrain = this.fluidManager[0].hasFluid(fluidStack2, tank);
                                if (!canDrain) continue;
                                fluidStackMap.put(integer2, fluidStack2);
                                break;
                            }
                            if (canDrain) continue;
                            continue block1;
                        }
                        if (fluidStackMap.isEmpty()) continue;
                        fluidStackMap.forEach((integer, fluidStack) -> this.fluidManager[0].drainFluid((FluidStack)fluidStack, (FluidTank)fluidTanks1.get((int)integer)));
                        this.fluidManager[0].fillFluid(entry.getValue());
                    }
                    break block25;
                }
                if (var2 != -3.0) break block27;
                ArrayList<FluidTank> fluidTanks = new ArrayList<FluidTank>();
                for (ITank iTank : this.listTank) {
                    fluidTanks.add(iTank.getTank());
                }
                fluidTanks1 = fluidTanks.stream().sorted((tank1, tank2) -> {
                    boolean hasFluid2;
                    FluidStack fluid1 = tank1.getFluid();
                    FluidStack fluid2 = tank2.getFluid();
                    boolean hasFluid1 = fluid1 != null && fluid1.amount > 0;
                    boolean bl = hasFluid2 = fluid2 != null && fluid2.amount > 0;
                    if (hasFluid1 && !hasFluid2) {
                        return -1;
                    }
                    if (!hasFluid1 && hasFluid2) {
                        return 1;
                    }
                    return 0;
                }).collect(Collectors.toList());
                block5: for (Map.Entry<FluidStack, List<FluidStack>> entry : mapRecipes1.entrySet()) {
                    if (((FluidTank)fluidTanks1.get(this.list.get(0))).getFluid() == null || entry.getKey().getFluid() != ((FluidTank)fluidTanks1.get(this.list.get(0))).getFluid().getFluid()) continue;
                    for (FluidStack fluidStack3 : entry.getValue()) {
                        if (this.fluidManager[0].canFillFluid(fluidStack3)) continue;
                        continue block5;
                    }
                    if (((FluidTank)fluidTanks1.get(this.list.get(0))).getFluidAmount() < entry.getKey().amount) continue;
                    for (FluidStack fluidStack3 : entry.getValue()) {
                        this.fluidManager[0].fillFluid(fluidStack3);
                    }
                    this.fluidManager[0].drainFluid(entry.getKey(), (FluidTank)fluidTanks1.get(this.list.get(0)));
                    break block25;
                }
                break block25;
            }
            if (var2 != -2.0) break block25;
            ArrayList<FluidTank> fluidTanks = new ArrayList<FluidTank>();
            for (ITank iTank : this.listTank) {
                fluidTanks.add(iTank.getTank());
            }
            fluidTanks1 = fluidTanks.stream().sorted((tank1, tank2) -> {
                boolean hasFluid2;
                FluidStack fluid1 = tank1.getFluid();
                FluidStack fluid2 = tank2.getFluid();
                boolean hasFluid1 = fluid1 != null && fluid1.amount > 0;
                boolean bl = hasFluid2 = fluid2 != null && fluid2.amount > 0;
                if (hasFluid1 && !hasFluid2) {
                    return -1;
                }
                if (!hasFluid1 && hasFluid2) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            block9: for (Map.Entry<List<FluidStack>, FluidStack> entry : mapRecipes.entrySet()) {
                if (entry.getKey().size() != this.list.size() || !this.fluidManager[0].canFillFluid(entry.getValue())) continue;
                HashMap<Integer, FluidStack> fluidStackMap = new HashMap<Integer, FluidStack>();
                for (FluidStack fluidStack4 : entry.getKey()) {
                    boolean canDrain = false;
                    for (Integer integer3 : this.list) {
                        FluidTank tank = (FluidTank)fluidTanks1.get(integer3);
                        canDrain = this.fluidManager[0].hasFluid(fluidStack4, tank);
                        if (!canDrain) continue;
                        fluidStackMap.put(integer3, fluidStack4);
                        break;
                    }
                    if (canDrain) continue;
                    continue block9;
                }
                while (!fluidStackMap.isEmpty()) {
                    fluidStackMap.forEach((integer, fluidStack) -> this.fluidManager[0].drainFluid((FluidStack)fluidStack, (FluidTank)fluidTanks1.get((int)integer)));
                    this.fluidManager[0].fillFluid(entry.getValue());
                    for (Map.Entry entry2 : fluidStackMap.entrySet()) {
                        if (((FluidTank)fluidTanks1.get((Integer)entry2.getKey())).getFluidAmount() >= ((FluidStack)entry2.getValue()).amount) continue;
                        continue block9;
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.progress);
        customPacketBuffer.writeInt(this.list.size());
        customPacketBuffer.writeBoolean(this.firstTank != null);
        for (Integer integer : this.list) {
            customPacketBuffer.writeInt(integer);
        }
        for (ITank tank : this.listTank) {
            try {
                EncoderHandler.encode(customPacketBuffer, tank.getTank());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.firstTank != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.firstTank);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.full && this.listTank.isEmpty()) {
            this.updateAfterAssembly();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.progress = customPacketBuffer.readInt();
        int size = customPacketBuffer.readInt();
        boolean hasTank = customPacketBuffer.readBoolean();
        this.list.clear();
        for (int i = 0; i < size; ++i) {
            this.list.add(customPacketBuffer.readInt());
        }
        for (ITank tank : this.listTank) {
            FluidTank fluidTank2;
            try {
                fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (fluidTank2 == null) continue;
            tank.getTank().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
        }
        if (hasTank) {
            FluidTank fluidTank2;
            try {
                fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.firstTank = fluidTank2;
        }
    }

    public ContainerSmelteryController getGuiContainer(EntityPlayer var1) {
        return new ContainerSmelteryController(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSmelteryController(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.isFull()) {
            int i;
            boolean work = false;
            if (this.func_145831_w().func_72820_D() % 20L == 0L) {
                for (i = 0; i < this.listTank.size(); ++i) {
                    FluidTank tank12 = this.listTank.get(i).getTank();
                    FluidStack fluid1 = tank12.getFluid();
                    if (fluid1 == null) continue;
                    for (int j = 0; j < this.listTank.size(); ++j) {
                        int amountNeeded;
                        FluidTank tank22;
                        FluidStack fluid2;
                        if (i == j || (fluid2 = (tank22 = this.listTank.get(j).getTank()).getFluid()) == null || !fluid1.isFluidEqual(fluid2) || (amountNeeded = tank12.getCapacity() - fluid1.amount) <= 0) continue;
                        int transferAmount = Math.min(amountNeeded, fluid2.amount);
                        fluid1.amount += transferAmount;
                        fluid2.amount -= transferAmount;
                        tank12.setFluid(fluid1);
                        tank22.setFluid(fluid2);
                        if (fluid2.amount != 0) continue;
                        tank22.setFluid(null);
                    }
                }
            }
            i = 0;
            if (this.casting != null && !this.casting.getInputSlotB().isEmpty()) {
                if (this.func_145831_w().func_72820_D() % 20L == 0L) {
                    if (this.list.isEmpty()) {
                        this.firstTank = null;
                        this.prevIndex = -1;
                    } else {
                        this.firstTank = (FluidTank)this.fluidManager[0].getOutputTank().stream().sorted((tank1, tank2) -> {
                            boolean hasFluid2;
                            FluidStack fluid1 = tank1.getFluid();
                            FluidStack fluid2 = tank2.getFluid();
                            boolean hasFluid1 = fluid1 != null && fluid1.amount > 0;
                            boolean bl = hasFluid2 = fluid2 != null && fluid2.amount > 0;
                            if (hasFluid1 && !hasFluid2) {
                                return -1;
                            }
                            if (!hasFluid1 && hasFluid2) {
                                return 1;
                            }
                            return 0;
                        }).collect(Collectors.toList()).get(this.list.get(0));
                        this.prevIndex = this.list.get(0);
                    }
                }
                if (this.casting.getFluid_handler().output() == null && this.getFirstTank() != null && this.getFirstTank().getFluidAmount() >= 1 && this.prevIndex == this.list.get(0)) {
                    this.casting.getFluid_handler().getOutput(this.getFirstTank());
                } else if (this.casting.getFluid_handler().output() != null && !this.casting.getFluid_handler().checkFluids()) {
                    this.casting.getFluid_handler().setOutput(null);
                }
                int fuel = 0;
                for (IFuelTank fuelTank : this.listFuelTank) {
                    fuel += fuelTank.getFuelTank().getFluidAmount();
                }
                if (this.casting.getFluid_handler().output() != null && this.casting.getOutputSlot().canAdd(this.casting.getFluid_handler().output().getOutput().items) && this.casting.getFluid_handler().canOperate1(this.getFirstTank()) && fuel >= 1) {
                    work = true;
                    this.casting.getProgress().addProgress();
                    fuel = 1;
                    for (IFuelTank fuelTank : this.listFuelTank) {
                        int fuel1 = Math.min(fuelTank.getFuelTank().getFluidAmount(), fuel);
                        fuelTank.getFuelTank().drain(fuel1, true);
                        if ((fuel -= fuel1) != 0) continue;
                        break;
                    }
                    if (this.casting.getProgress().getBar() >= 1.0) {
                        this.casting.getProgress().setProgress((short)0);
                        this.casting.getFluid_handler().consume(this.firstTank);
                        this.casting.getOutputSlot().add(this.casting.getFluid_handler().output().getOutput().items);
                        this.casting.getFluid_handler().checkOutput(this.getFirstTank());
                        work = false;
                    }
                } else if (this.casting.getFluid_handler().output() == null) {
                    this.casting.getProgress().setProgress((short)0);
                }
            }
            for (IFurnace furnace : this.furnaces) {
                if (furnace != null && !this.listFuelTank.isEmpty()) {
                    if (this.fluidManager[i].output() == null && furnace.getRecipeOutput() != null) {
                        this.fluidManager[i].getOutput(furnace.getInvSlot().get());
                    } else if (this.fluidManager[i].output() != null && furnace.getRecipeOutput() == null) {
                        this.fluidManager[i].setOutput(null);
                    }
                    if (furnace.isChangeRecipe() && furnace.getRecipeOutput() != null) {
                        this.fluidManager[i].setOutput(null);
                        furnace.setChangeRecipe(false);
                    }
                    int fuel = 0;
                    int fuel1 = 0;
                    for (IFuelTank fuelTank : this.listFuelTank) {
                        if (fuelTank.getSpeed() == 1.0) {
                            fuel += fuelTank.getFuelTank().getFluidAmount();
                            continue;
                        }
                        fuel1 += fuelTank.getFuelTank().getFluidAmount();
                    }
                    if (furnace.getRecipeOutput() != null && !furnace.getInvSlot().isEmpty() && furnace.getInvSlot().continue_process(furnace.getRecipeOutput()) && this.fluidManager[i].output() != null && this.fluidManager[i].canFillFluid1() && (fuel >= 1 || fuel1 >= 1)) {
                        furnace.getComponent().addProgress(0, (short)(fuel1 > 0 ? 2 : 1));
                        if (!furnace.isActive()) {
                            furnace.setActive(true);
                        }
                        work = true;
                        boolean drain = false;
                        if (fuel1 > 0) {
                            for (IFuelTank fuelTank : this.listFuelTank) {
                                if (!(fuelTank.getSpeed() > 1.0)) continue;
                                fuelTank.getFuelTank().drain(1, true);
                                drain = true;
                                break;
                            }
                        }
                        if (!drain) {
                            for (IFuelTank fuelTank : this.listFuelTank) {
                                if (fuelTank.getSpeed() != 1.0 || fuelTank.getFuelTank().getFluidAmount() <= 0) continue;
                                fuelTank.getFuelTank().drain(1, true);
                                break;
                            }
                        }
                        if (furnace.getComponent().getBar() >= 1.0) {
                            furnace.getComponent().setProgress((short)0);
                            furnace.getInvSlot().consume();
                            this.fluidManager[i].fillFluid1();
                            furnace.getOutput();
                            if (furnace.isActive()) {
                                furnace.setActive(false);
                            }
                            work = false;
                        }
                    } else if (furnace.isActive()) {
                        furnace.setActive(false);
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
            this.setActive(work);
        } else if (this.getActive()) {
            this.setActive(false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.furnaces.clear();
            this.listFuelTank.clear();
            this.listTank.clear();
            if (this.casting != null) {
                this.casting.getFluid_handler().setTanks(Collections.EMPTY_LIST);
            }
            this.casting = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        this.listTank.clear();
        this.listFuelTank.clear();
        this.furnaces.clear();
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        for (BlockPos blockPos : pos1) {
            this.listTank.add((ITank)this.func_145831_w().func_175625_s(blockPos));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IFurnace.class);
        for (BlockPos blockPos : pos1) {
            this.furnaces.add((IFurnace)this.func_145831_w().func_175625_s(blockPos));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICasting.class);
        this.casting = (ICasting)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IFuelTank.class);
        for (BlockPos blockPos : pos1) {
            this.listFuelTank.add((IFuelTank)this.func_145831_w().func_175625_s(blockPos));
        }
        ArrayList<Fluids.InternalFluidTank> fluidTanks = new ArrayList<Fluids.InternalFluidTank>();
        for (ITank tank : this.listTank) {
            fluidTanks.add((Fluids.InternalFluidTank)tank.getTank());
        }
        for (FluidHandlerRecipe recipe : this.fluidManager) {
            recipe.setTanks(fluidTanks);
        }
        this.casting.getFluid_handler().setTanks(fluidTanks);
        if (!this.casting.getInputSlotB().isEmpty()) {
            this.casting.getFluid_handler().setName("empty");
            this.casting.getFluid_handler().setOutput(null);
            int n = this.casting.getInputSlotB().get().func_77952_i();
            if (n == 496) {
                this.casting.getFluid_handler().setName("ingot_casting");
                if (this.getMain() != null) {
                    TileEntitySmelteryController controller = (TileEntitySmelteryController)this.getMain();
                    this.casting.getFluid_handler().load();
                    this.casting.getFluid_handler().getOutput(controller.getFirstTank());
                }
            } else if (n == 497) {
                this.casting.getFluid_handler().setName("gear_casting");
                if (this.getMain() != null) {
                    TileEntitySmelteryController controller = (TileEntitySmelteryController)this.getMain();
                    this.casting.getFluid_handler().load();
                    this.casting.getFluid_handler().getOutput(controller.getFirstTank());
                }
            } else {
                this.casting.getFluid_handler().load();
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && this.isFull()) {
            for (int i = 0; i < 3; ++i) {
                this.fluidManager[i].load(this.furnaces.get(i).getInvSlot().get());
            }
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSmeltery.smeltery_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.smeltery;
    }

    @Override
    public void init() {
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidiron.getInstance(), 432), new FluidStack(FluidName.fluidcarbon.getInstance(), 288)), new FluidStack(FluidName.fluidsteel.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidquartz.getInstance(), 288), new FluidStack(FluidName.fluidiron.getInstance(), 144), new FluidStack(FluidName.fluidmagnesium.getInstance(), 144)), new FluidStack(FluidName.fluidobsidian.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidtitanium.getInstance(), 288), new FluidStack(FluidName.fluidsteel.getInstance(), 288)), new FluidStack(FluidName.fluidtitaniumsteel.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidelectrum.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidgold.getInstance(), 72), new FluidStack(FluidName.fluidsilver.getInstance(), 72)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidgold.getInstance(), 144), new FluidStack(FluidName.fluidsilver.getInstance(), 288)), new FluidStack(FluidName.fluidelectrum.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidinvar.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidiron.getInstance(), 48), new FluidStack(FluidName.fluidnickel.getInstance(), 72)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidiron.getInstance(), 144), new FluidStack(FluidName.fluidnickel.getInstance(), 144)), new FluidStack(FluidName.fluidinvar.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidbronze.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidcopper.getInstance(), 108), new FluidStack(FluidName.fluidtin.getInstance(), 36)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidcopper.getInstance(), 576), new FluidStack(FluidName.fluidtin.getInstance(), 144)), new FluidStack(FluidName.fluidbronze.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidwolframite.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidtungsten.getInstance(), 144), new FluidStack(FluidName.fluidnickel.getInstance(), 144)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidtungsten.getInstance(), 144), new FluidStack(FluidName.fluidnickel.getInstance(), 144)), new FluidStack(FluidName.fluidwolframite.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidmagnesium.getInstance(), 288), new FluidStack(FluidName.fluidaluminium.getInstance(), 288)), new FluidStack(FluidName.fluidduralumin.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidnichrome.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidchromium.getInstance(), 144), new FluidStack(FluidName.fluidnickel.getInstance(), 144)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidchromium.getInstance(), 288), new FluidStack(FluidName.fluidnickel.getInstance(), 144)), new FluidStack(FluidName.fluidnichrome.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidwolframite.getInstance(), 144), new FluidStack(FluidName.fluidquartz.getInstance(), 144)), new FluidStack(FluidName.fluidtemperedglass.getInstance(), 144));
        mapRecipes1.put(new FluidStack(FluidName.fluidarsenicum_gallium.getInstance(), 144), Arrays.asList(new FluidStack(FluidName.fluidarsenicum.getInstance(), 288), new FluidStack(FluidName.fluidgallium.getInstance(), 144)));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidarsenicum.getInstance(), 432), new FluidStack(FluidName.fluidgallium.getInstance(), 288)), new FluidStack(FluidName.fluidarsenicum_gallium.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidaluminium.getInstance(), 288), new FluidStack(FluidName.fluidbronze.getInstance(), 144)), new FluidStack(FluidName.fluidaluminiumbronze.getInstance(), 144));
        mapRecipes.put(Arrays.asList(new FluidStack(FluidName.fluidiron.getInstance(), 288), new FluidStack(FluidName.fluidmanganese.getInstance(), 288)), new FluidStack(FluidName.fluidferromanganese.getInstance(), 144));
    }
}

