/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.InfoCable;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockCoolPipes;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.CoolType;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCoolPipes
extends TileEntityMultiCable
implements ICoolConductor {
    public boolean addedToEnergyNet;
    protected CoolType cableType;
    int hashCodeSource;
    Map<EnumFacing, ICoolTile> energyCoolConductorMap = new HashMap<EnumFacing, ICoolTile>();
    List<InfoTile<ICoolTile>> validColdReceivers = new LinkedList<InfoTile<ICoolTile>>();
    boolean updateConnect = false;
    private boolean needUpdate;
    private long id;
    private InfoCable typeColdCable;

    public TileEntityCoolPipes(CoolType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public TileEntityCoolPipes() {
        super(CoolType.cool);
        this.cableType = CoolType.cool;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public static TileEntityCoolPipes delegate(CoolType cableType) {
        return new TileEntityCoolPipes(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCoolPipes.cool_pipes_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.coolpipesblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = CoolType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddCoolTile(ICoolTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyCoolConductorMap.containsKey(dir)) {
                this.energyCoolConductorMap.put(dir, tile);
                this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void RemoveCoolTile(ICoolTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyCoolConductorMap.remove(dir);
            Iterator<InfoTile<ICoolTile>> iter = this.validColdReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ICoolTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<EnumFacing, ICoolTile> getCoolTiles() {
        return this.energyCoolConductorMap;
    }

    @Override
    public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
        return this.validColdReceivers;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && !this.addedToEnergyNet) {
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185854_g;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.coolpipes, 1, this.cableType.ordinal());
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public InfoCable getCoolCable() {
        return this.typeColdCable;
    }

    @Override
    public void setCoolCable(InfoCable cable) {
        this.typeColdCable = cable;
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            ICoolTile tile = this.energyCoolConductorMap.get(dir);
            if (this.getBlackList().contains(dir) || (!(tile instanceof ICoolAcceptor) || !((ICoolAcceptor)tile).acceptsCoolFrom(this, dir.func_176734_d())) && (!(tile instanceof ICoolEmitter) || !((ICoolEmitter)tile).emitsCoolTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownCold() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public void update_render() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = CoolType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

