/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoCable;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockExpCable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ExpType;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityExpPipes
extends TileEntityMultiCable
implements IConductor {
    public boolean addedToEnergyNet;
    protected ExpType cableType;
    Map<EnumFacing, ITile> energyConductorMap = new HashMap<EnumFacing, ITile>();
    List<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
    int hashCodeSource;
    boolean updateConnect = false;
    private boolean needUpdate;
    private long id;
    private InfoCable cable;

    public TileEntityExpPipes(ExpType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public TileEntityExpPipes() {
        super(ExpType.expcable);
        this.cableType = ExpType.expcable;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public static TileEntityExpPipes delegate(ExpType cableType) {
        return new TileEntityExpPipes(cableType);
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public List<InfoTile<ITile>> getValidReceivers(EnergyType type) {
        return this.validReceivers;
    }

    @Override
    public Map<EnumFacing, ITile> getTiles(EnergyType type) {
        return this.energyConductorMap;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockExpCable.expcable;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.expcableblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = ExpType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public InfoCable getCable(EnergyType type) {
        return this.cable;
    }

    @Override
    public void setCable(EnergyType type, InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public void RemoveTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<ITile>(tile, facing1.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.expcable, 1, 0);
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        byte newConnectivity = 0;
        EnumFacing[] var4 = EnumFacing.field_82609_l;
        Map<EnumFacing, ITile> map = this.energyConductorMap;
        for (EnumFacing dir : var4) {
            newConnectivity = (byte)(newConnectivity << 1);
            ITile tile = map.get(dir);
            if (dir == null || this.getBlackList().contains(dir) || (!(tile instanceof IAcceptor) || !((IAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof IEmitter) || !((IEmitter)tile).emitsTo(this, dir.func_176734_d()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsFrom(IEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsTo(IAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType type) {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.EXPERIENCE;
    }

    @Override
    public boolean hasEnergies() {
        return false;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = ExpType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

