/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.InfoCable;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPipes;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.HeatType;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityHeatPipes
extends TileEntityMultiCable
implements IHeatConductor {
    public boolean addedToEnergyNet;
    protected HeatType cableType;
    int hashCodeSource;
    Map<EnumFacing, IHeatTile> energyHeatConductorMap = new HashMap<EnumFacing, IHeatTile>();
    boolean updateConnect = false;
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    private boolean needUpdate;
    private long id;
    private InfoCable typeColdCable;

    public TileEntityHeatPipes(HeatType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.addedToEnergyNet = false;
    }

    public TileEntityHeatPipes() {
        super(HeatType.pipes);
        this.cableType = HeatType.pipes;
        this.addedToEnergyNet = false;
    }

    public static TileEntityHeatPipes delegate(HeatType cableType) {
        return new TileEntityHeatPipes(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPipes.pipes_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.pipesblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddHeatTile(IHeatTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyHeatConductorMap.containsKey(dir)) {
                this.energyHeatConductorMap.put(dir, tile);
                this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public InfoCable getHeatCable() {
        return this.typeColdCable;
    }

    @Override
    public void setHeatCable(InfoCable cable) {
        this.typeColdCable = cable;
    }

    @Override
    public void RemoveHeatTile(IHeatTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyHeatConductorMap.remove(dir);
            Iterator<InfoTile<IHeatTile>> iter = this.validHeatReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IHeatTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<EnumFacing, IHeatTile> getHeatTiles() {
        return this.energyHeatConductorMap;
    }

    @Override
    public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
        return this.validHeatReceivers;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = HeatType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && !this.addedToEnergyNet) {
            this.energyHeatConductorMap.clear();
            this.validHeatReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyHeatConductorMap.clear();
            this.validHeatReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.pipes, 1, this.cableType.ordinal());
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            IHeatTile tile = this.getHeatTiles().get(dir);
            if (this.getBlackList().contains(dir) || (!(tile instanceof IHeatAcceptor) || !((IHeatAcceptor)tile).acceptsHeatFrom(this, dir.func_176734_d())) && (!(tile instanceof IHeatEmitter) || !((IHeatEmitter)tile).emitsHeatTo(this, dir.func_176734_d()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public double getConductorBreakdownHeat() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public void update_render() {
        this.updateConnectivity();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = HeatType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

