/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.transport.FluidHandler;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.InfoCable;
import com.denfop.api.transport.TransportFluidItemSinkSource;
import com.denfop.api.transport.event.TransportTileLoadEvent;
import com.denfop.api.transport.event.TransportTileUnLoadEvent;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockItemPipes;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.container.ContainerCable;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiCable1;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.ItemType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemPipes
extends TileEntityMultiCable
implements ITransportConductor {
    private final Redstone redstone;
    public SlotInfo list;
    public boolean addedToEnergyNet = false;
    public ItemType cableType;
    public boolean redstoneSignal = false;
    Map<EnumFacing, ITransportTile> energyConductorMap = new HashMap<EnumFacing, ITransportTile>();
    boolean hasHashCode = false;
    int hashCodeSource;
    List<InfoTile<ITransportTile>> validReceivers = new LinkedList<InfoTile<ITransportTile>>();
    InfoCable cable;
    List<FluidStack> blackList = new ArrayList<FluidStack>();
    List<FluidStack> whiteList = new ArrayList<FluidStack>();
    private SlotInfo listDown;
    private SlotInfo listUp;
    private SlotInfo listWest;
    private SlotInfo listEast;
    private SlotInfo listNorth;
    private SlotInfo listSouth;
    private boolean needUpdate;
    private long id;
    private boolean update;
    private boolean work = false;
    private EnumFacing facingSide;
    private byte tick;
    private int max;
    private int hashCode;

    public TileEntityItemPipes() {
        super(ItemType.itemcable);
        this.cableType = ItemType.itemcable;
        this.listDown = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listUp = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listWest = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listEast = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listNorth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listSouth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileEntityItemPipes.this.work = input != 0;
            }
        });
    }

    public TileEntityItemPipes(ItemType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.listDown = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listUp = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listWest = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listEast = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listNorth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listSouth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileEntityItemPipes.this.work = input != 0;
            }
        });
    }

    public static TileEntityItemPipes delegate(ItemType cableType) {
        return new TileEntityItemPipes(cableType);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.redstoneSignal = customPacketBuffer.readBoolean();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.redstoneSignal);
        return customPacketBuffer;
    }

    public boolean isWork() {
        return this.work;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockItemPipes.item_pipes;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockItemPipes;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = ItemType.values[nbt.func_74771_c("cableType") & 0xFF];
        this.redstoneSignal = nbt.func_74767_n("redstoneSignal");
        if (!this.cableType.isOutput && !this.cableType.isInput()) {
            this.listDown = null;
            this.listUp = null;
            this.listWest = null;
            this.listEast = null;
            this.listNorth = null;
            this.listSouth = null;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        nbt.func_74757_a("redstoneSignal", this.redstoneSignal);
        return nbt;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(ITransportTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITransportTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITransportTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.update = true;
        }
    }

    @Override
    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public Map<EnumFacing, ITransportTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<ITransportTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void AddTile(ITransportTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K && !this.energyConductorMap.containsKey(facing1) && (this.isOutput() || this.isInput() || !this.isOutput() && !this.isInput() && tile instanceof ITransportConductor)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITransportTile>(tile, facing1.func_176734_d()));
            this.update = true;
        }
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
        if (tile != null && !(tile instanceof ITransportConductor) && !tile.func_145837_r()) {
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                    break;
                }
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing)) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                    break;
                }
                if (!tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) continue;
                TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                break;
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && !this.addedToEnergyNet) {
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            }
            this.addedToEnergyNet = true;
            this.updateConnectivity();
            block0: for (EnumFacing facing1 : EnumFacing.values()) {
                BlockPos neighborPos = this.field_174879_c.func_177972_a(facing1);
                TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
                if (tile == null || tile instanceof ITransportConductor || tile.func_145837_r()) continue;
                for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                    TransportFluidItemSinkSource transport;
                    if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) {
                        transport = new TransportFluidItemSinkSource(tile, neighborPos);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                        continue block0;
                    }
                    if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing)) {
                        transport = new TransportFluidItemSinkSource(tile, neighborPos);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                        continue block0;
                    }
                    if (!tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) continue;
                    transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                    continue block0;
                }
            }
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 < (double)EnumFacing.field_82609_l.length) {
            super.updateTileServer(var1, var2);
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            }
            this.needUpdate = true;
        } else if (var2 == 10.0) {
            this.redstoneSignal = !this.redstoneSignal;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            }
            this.updateConnectivity();
            this.needUpdate = false;
        }
        if (this.update) {
            this.update = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            }
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.item_pipes, 1, this.cableType.ordinal());
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.facingSide = side;
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public SlotInfo getInfoSlotFromFacing(EnumFacing facing) {
        if (facing == null) {
            return this.listUp;
        }
        switch (facing) {
            case UP: {
                return this.listUp;
            }
            case DOWN: {
                return this.listDown;
            }
            case NORTH: {
                return this.listNorth;
            }
            case SOUTH: {
                return this.listSouth;
            }
            case WEST: {
                return this.listWest;
            }
            case EAST: {
                return this.listEast;
            }
        }
        return this.listUp;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        if (var1.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == IUItem.connect_item) {
            return super.getGui(var1, var2);
        }
        return new GuiCable1(this.getGuiContainer(var1));
    }

    @Override
    public ContainerCable getGuiContainer(EntityPlayer var1) {
        return new ContainerCable(var1, this, this.facingSide.func_176734_d());
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            ITransportTile tile = this.getTiles().get(dir);
            if (this.getBlackList().contains(dir) || (!(tile instanceof ITransportAcceptor) || !((ITransportAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof ITransportEmitter) || !((ITransportEmitter)tile).emitsTo(this, dir.func_176734_d()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean isOutput() {
        return this.cableType.isOutput;
    }

    @Override
    public boolean isInput() {
        return this.cableType.isInput();
    }

    @Override
    public InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public boolean isItem() {
        return this.cableType.isItem();
    }

    @Override
    public List<ItemStack> getBlackListItems(EnumFacing facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        return this.list.getListBlack();
    }

    @Override
    public List<ItemStack> getWhiteListItems(EnumFacing facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        return this.list.getListWhite();
    }

    @Override
    public List<FluidStack> getBlackListFluids(EnumFacing facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            this.blackList = this.list.getFluidStackList().subList(0, 9).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.blackList;
    }

    @Override
    public List<FluidStack> getWhiteListFluids(EnumFacing facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            this.whiteList = this.list.getFluidStackList().subList(9, this.list.size()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.whiteList;
    }

    @Override
    public boolean canWork() {
        return !this.redstoneSignal || this.work;
    }

    @Override
    public int getMax() {
        return this.cableType.getMax();
    }

    @Override
    public void setMax(int value) {
        this.max -= value;
    }

    @Override
    public int getMax(byte tick) {
        if (this.tick != tick) {
            this.tick = tick;
            this.max = this.getMax();
            return this.getMax();
        }
        return this.max;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
            if (this.listUp != null) {
                EncoderHandler.encode(packet, this.listUp.isFluid());
                EncoderHandler.encode(packet, this.listDown.isFluid());
                EncoderHandler.encode(packet, this.listWest.isFluid());
                EncoderHandler.encode(packet, this.listEast.isFluid());
                EncoderHandler.encode(packet, this.listNorth.isFluid());
                EncoderHandler.encode(packet, this.listSouth.isFluid());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = ItemType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            if (!this.cableType.isOutput && !this.cableType.isInput()) {
                this.listDown = null;
                this.listUp = null;
                this.listWest = null;
                this.listEast = null;
                this.listNorth = null;
                this.listSouth = null;
            }
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            if (this.listUp != null) {
                this.listUp.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listDown.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listWest.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listEast.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listNorth.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listSouth.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
            }
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onNetworkEvent(int event) {
        World world = this.func_145831_w();
        if (event == 0) {
            world.func_184133_a(null, this.field_174879_c, SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, EnumFacing var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (!this.cableType.isOutput && !this.cableType.isInput() && var1 instanceof ITransportConductor) {
            ITransportConductor conductor = (ITransportConductor)var1;
            return conductor.isItem() && this.isItem() || !conductor.isItem() && !this.isItem();
        }
        if (this.cableType.isItem()) {
            return var1.getHandler(var2.func_176734_d()) instanceof IItemHandler;
        }
        return var1.getHandler(var2.func_176734_d()) instanceof IFluidHandler;
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, EnumFacing var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (!this.cableType.isOutput && !this.cableType.isInput()) {
            if (var1 instanceof ITransportConductor) {
                ITransportConductor conductor = (ITransportConductor)var1;
                return conductor.isItem() && this.isItem() || !conductor.isItem() && !this.isItem();
            }
            return false;
        }
        if (this.cableType.isItem()) {
            return var1.getHandler(var2.func_176734_d()) instanceof IItemHandler;
        }
        return var1.getHandler(var2.func_176734_d()) instanceof IFluidHandler;
    }

    @Override
    public Object getHandler(EnumFacing facing) {
        if (this.cableType.isItem()) {
            return new ItemStackHandler();
        }
        return new FluidHandler();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }
}

