/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.InfoCable;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockUniversalCable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.EnumTypeOperation;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.UniversalType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityUniversalCable
extends TileEntityMultiCable
implements IEnergyConductor,
IHeatConductor,
ICoolConductor,
IConductor {
    public boolean addedToEnergyNet;
    protected UniversalType cableType;
    EnumTypeOperation enumTypeOperation = null;
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    Map<EnumFacing, IHeatTile> energyHeatConductorMap = new HashMap<EnumFacing, IHeatTile>();
    boolean updateConnect = false;
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    Map<EnergyType, Map<EnumFacing, ITile>> energyTypeConductorMap = new HashMap<EnergyType, Map<EnumFacing, ITile>>();
    Map<EnergyType, List<InfoTile<ITile>>> validTypeReceivers = new HashMap<EnergyType, List<InfoTile<ITile>>>();
    int hashCodeSource;
    Map<EnumFacing, ICoolTile> energyCoolConductorMap = new HashMap<EnumFacing, ICoolTile>();
    List<InfoTile<ICoolTile>> validColdReceivers = new LinkedList<InfoTile<ICoolTile>>();
    List<EnergyType> energies = Arrays.asList(EnergyType.QUANTUM, EnergyType.SOLARIUM, EnergyType.EXPERIENCE, EnergyType.RADIATION);
    private boolean needUpdate;
    private ChunkPos chunkPos;
    private boolean heat;
    private boolean quantum;
    private boolean experience;
    private boolean solarium;
    private boolean radiation;
    private boolean cold;
    private com.denfop.api.energy.InfoCable cable;
    private com.denfop.api.heat.InfoCable typeHeatCable;
    private long id;
    private com.denfop.api.sytem.InfoCable typeCable;
    private InfoCable typeColdCable;

    public TileEntityUniversalCable(UniversalType cableType) {
        super(cableType);
        this.cableType = cableType;
    }

    public TileEntityUniversalCable() {
        super(UniversalType.glass);
        this.cableType = UniversalType.glass;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public static TileEntityUniversalCable delegate(UniversalType cableType) {
        return new TileEntityUniversalCable(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockUniversalCable.universal_cable;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.universalcableblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public com.denfop.api.energy.InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(com.denfop.api.energy.InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = UniversalType.values[nbt.func_74771_c("cableType") & 0xFF];
        this.heat = nbt.func_74767_n("Heat");
        this.quantum = nbt.func_74767_n("Quantum");
        this.experience = nbt.func_74767_n("Experience");
        this.solarium = nbt.func_74767_n("Solarium");
        this.radiation = nbt.func_74767_n("Radiation");
        this.cold = nbt.func_74767_n("Cold");
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        nbt.func_74757_a("Heat", this.heat);
        nbt.func_74757_a("Quantum", this.quantum);
        nbt.func_74757_a("Experience", this.experience);
        nbt.func_74757_a("Solarium", this.solarium);
        nbt.func_74757_a("Radiation", this.radiation);
        nbt.func_74757_a("Cold", this.cold);
        return nbt;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
        if (this.heat) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
        }
        if (this.cold) {
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
        }
        if (this.quantum) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
        }
        if (this.experience) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
        }
        if (this.solarium) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
        }
        if (this.radiation) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.RADIATION, this));
        }
        this.needUpdate = true;
    }

    @Override
    public void AddHeatTile(IHeatTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyHeatConductorMap.containsKey(dir)) {
                this.energyHeatConductorMap.put(dir, tile);
                this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public com.denfop.api.heat.InfoCable getHeatCable() {
        return this.typeHeatCable;
    }

    @Override
    public void setHeatCable(com.denfop.api.heat.InfoCable cable) {
        this.typeHeatCable = cable;
    }

    @Override
    public void RemoveHeatTile(IHeatTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyHeatConductorMap.remove(dir);
            Iterator<InfoTile<IHeatTile>> iter = this.validHeatReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IHeatTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<EnumFacing, IHeatTile> getHeatTiles() {
        return this.energyHeatConductorMap;
    }

    @Override
    public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
        return this.validHeatReceivers;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            this.energyTypeConductorMap.clear();
            this.validTypeReceivers.clear();
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            this.validHeatReceivers.clear();
            this.energyHeatConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.RADIATION, this));
            }
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.enumTypeOperation != null) {
            switch (this.enumTypeOperation) {
                case HEAT: {
                    this.heat = true;
                    MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
                    break;
                }
                case COLD: {
                    this.cold = true;
                    MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
                    break;
                }
                case QUANTUM: {
                    this.quantum = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
                    break;
                }
                case EXPERIENCE: {
                    this.experience = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
                    break;
                }
                case SOLARIUM: {
                    this.solarium = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
                    break;
                }
                case RADIATION: {
                    this.radiation = true;
                }
            }
            this.enumTypeOperation = null;
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            this.energyTypeConductorMap.clear();
            this.validTypeReceivers.clear();
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.RADIATION, this));
            }
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == IUItem.qcable && !this.quantum) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.QUANTUM;
            return true;
        }
        if (stack.func_77973_b() == IUItem.scable && !this.solarium) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.SOLARIUM;
            return true;
        }
        if (stack.func_77973_b() == IUItem.radcable_item && !this.radiation) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.RADIATION;
            return true;
        }
        if (stack.func_77973_b() == IUItem.expcable && !this.experience) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.EXPERIENCE;
            return true;
        }
        if (stack.func_77973_b() == IUItem.coolpipes && stack.func_77952_i() == 4 && !this.cold) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.COLD;
            return true;
        }
        if (stack.func_77973_b() == IUItem.pipes && stack.func_77952_i() == 4 && !this.heat) {
            stack.func_190918_g(1);
            this.enumTypeOperation = EnumTypeOperation.HEAT;
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.RADIATION, this));
            }
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>(super.getSelfDrops(fortune, wrench));
        if (this.quantum) {
            stacks.add(new ItemStack((Item)IUItem.qcable));
        }
        if (this.solarium) {
            stacks.add(new ItemStack((Item)IUItem.scable));
        }
        if (this.radiation) {
            stacks.add(new ItemStack((Item)IUItem.radcable_item));
        }
        if (this.experience) {
            stacks.add(new ItemStack((Item)IUItem.expcable));
        }
        if (this.heat) {
            stacks.add(new ItemStack((Item)IUItem.pipes, 1, 4));
        }
        if (this.cold) {
            stacks.add(new ItemStack((Item)IUItem.coolpipes, 1, 4));
        }
        return stacks;
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.universal_cable, 1, this.cableType.ordinal());
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            if (this.getBlackList().contains(dir)) continue;
            Object tile = this.energyConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            Map map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.SOLARIUM, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = this.energyHeatConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = this.energyCoolConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.QUANTUM, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.RADIATION, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.EXPERIENCE, k -> new HashMap());
            tile = map.get(dir);
            if (tile == null) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.loss;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType energyType) {
        return 2.147483647E9;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddCoolTile(ICoolTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.energyCoolConductorMap.containsKey(dir)) {
                this.energyCoolConductorMap.put(dir, tile);
                this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void RemoveCoolTile(ICoolTile tile, EnumFacing dir) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyCoolConductorMap.remove(dir);
            Iterator<InfoTile<ICoolTile>> iter = this.validColdReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ICoolTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<EnumFacing, ICoolTile> getCoolTiles() {
        return this.energyCoolConductorMap;
    }

    @Override
    public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
        return this.validColdReceivers;
    }

    @Override
    public List<InfoTile<ITile>> getValidReceivers(EnergyType type) {
        return this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList());
    }

    @Override
    public Map<EnumFacing, ITile> getTiles(EnergyType type) {
        return this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap());
    }

    @Override
    public com.denfop.api.sytem.InfoCable getCable(EnergyType type) {
        return this.typeCable;
    }

    @Override
    public void setCable(EnergyType type, com.denfop.api.sytem.InfoCable cable) {
        this.typeCable = cable;
    }

    @Override
    public void RemoveTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap()).remove(facing1);
            Iterator iter = this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList()).iterator();
            while (iter.hasNext()) {
                InfoTile tileInfoTile = (InfoTile)iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyType type, ITile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            Map map = this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap());
            if (!map.containsKey(facing1)) {
                map.put(facing1, tile);
                this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList()).add(new InfoTile<ITile>(tile, facing1.func_176734_d()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public double getConductorBreakdownHeat() {
        return 16001.0;
    }

    @Override
    public double getConductorBreakdownCold() {
        return 65.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = UniversalType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update_render() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public InfoCable getCoolCable() {
        return this.typeColdCable;
    }

    @Override
    public void setCoolCable(InfoCable cable) {
        this.typeColdCable = cable;
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.QUANTUM;
    }

    @Override
    public boolean hasEnergies() {
        return true;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return this.energies;
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsFrom(IEmitter var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsTo(IAcceptor var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }
}

