/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.api.IKeyboard;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;

public class KeyboardIU
implements IKeyboard {
    private final Map<EntityPlayer, Set<Key>> playerKeys = new WeakHashMap<EntityPlayer, Set<Key>>();

    @Override
    public boolean isJumpKeyDown(EntityPlayer player) {
        return this.get(player, Key.JUMP);
    }

    @Override
    public boolean isArmorKey(EntityPlayer player) {
        return this.get(player, Key.ARMOR);
    }

    @Override
    public boolean isSneakKeyDown(EntityPlayer player) {
        return player.func_70093_af();
    }

    @Override
    public boolean isForwardKeyDown(EntityPlayer player) {
        return this.get(player, Key.FORWARD);
    }

    @Override
    public boolean isChangeKeyDown(EntityPlayer player) {
        return this.get(player, Key.CHANGE);
    }

    @Override
    public boolean isVerticalMode(EntityPlayer player) {
        return this.get(player, Key.VERTICALMODE);
    }

    @Override
    public boolean isBootsMode(EntityPlayer player) {
        return this.get(player, Key.BOOTS);
    }

    @Override
    public boolean isLeggingsMode(EntityPlayer player) {
        return this.get(player, Key.LEGGINGS);
    }

    @Override
    public boolean isFlyModeKeyDown(EntityPlayer player) {
        return this.get(player, Key.FLYMODE);
    }

    @Override
    public boolean isBlackListModeKeyDown(EntityPlayer player) {
        return this.get(player, Key.BLACKMODE);
    }

    @Override
    public boolean isBlackListModeViewKeyDown(EntityPlayer player) {
        return this.get(player, Key.BLACKLISTVIEWMODE);
    }

    public boolean isSaveModeKeyDown(EntityPlayer player) {
        return this.get(player, Key.SAVEMODE);
    }

    public void sendKeyUpdate() {
    }

    public void processKeyUpdate(EntityPlayer player, int keyState) {
        this.playerKeys.put(player, Key.fromInt(keyState));
    }

    public void removePlayerReferences(EntityPlayer player) {
        this.playerKeys.remove(player);
    }

    private boolean get(EntityPlayer player, Key key) {
        Set<Key> keys = this.playerKeys.get(player);
        return keys != null && keys.contains((Object)key);
    }

    @Override
    public boolean isStreakKeyDown(EntityPlayer player) {
        return this.get(player, Key.STREAK);
    }

    public static enum Key {
        CHANGE,
        BLACKLISTVIEWMODE,
        FLYMODE,
        VERTICALMODE,
        SAVEMODE,
        SHIFT,
        STREAK,
        BLACKMODE,
        FORWARD,
        JUMP,
        ARMOR,
        BOOTS,
        LEGGINGS;

        public static final Key[] keys;

        public static int toInt(Iterable<Key> keySet) {
            int ret = 0;
            for (Key key : keySet) {
                ret |= 1 << key.ordinal();
            }
            return ret;
        }

        public static Set<Key> fromInt(int keyState) {
            EnumSet<Key> ret = EnumSet.noneOf(Key.class);
            int i = 0;
            while (keyState != 0) {
                if ((keyState & 1) != 0) {
                    ret.add(keys[i]);
                }
                ++i;
                keyState >>= 1;
            }
            return ret;
        }

        static {
            keys = Key.values();
        }
    }
}

