/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockBasalts;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.FluidName;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.TileEntityVolcanoChest;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.BlockSnapshot;

public class GeneratorVolcano {
    public static final int[][] protrusionOffsets = new int[][]{{-1, 1, -1}, {0, 2, -1}, {1, 3, -1}, {1, 4, 0}, {1, 5, 1}, {0, 6, 1}, {-1, 7, 1}, {-1, 8, 0}, {0, 9, 0}};
    private static IBlockState basalt_smooth = IUItem.basalts.getState(BlockBasalts.Type.basalt_smooth);
    private static IBlockState basalt_sulfur_ore = IUItem.basalts.getState(BlockBasalts.Type.basalt_sulfur_ore);
    private static IBlockState basalt_pylon = IUItem.basalts.getState(BlockBasalts.Type.basalt_pylon);
    private static IBlockState basalt_magma = IUItem.basalts.getState(BlockBasalts.Type.basalt_magma);
    private static IBlockState basalt_cobblestone = IUItem.basalts.getState(BlockBasalts.Type.basalt_cobblestone);
    private static IBlockState basalt_melted = IUItem.basalts.getState(BlockBasalts.Type.basalt_melted);
    private static IBlockState basalt = IUItem.basalts.getState(BlockBasalts.Type.basalt);
    private static IBlockState basalt_boron_ore = IUItem.basalts.getState(BlockBasalts.Type.basalt_boron_ore);
    private static IBlockState basalt_spongy = IUItem.basalts.getState(BlockBasalts.Type.basalt_spongy);
    private static IBlockState basalt_blocked = IUItem.basalts.getState(BlockBasalts.Type.basalt_blocked);
    private static IBlockState[][] basalts_ores = null;
    private final World world;
    private BlockPos position;
    private final Random rand;
    private final Thread thread;
    private final LinkedList<BlockPos> blockPosList1;
    private final LinkedList<BlockPos> blockPosList;
    private final ChunkPos chunkPos;
    private final Chunk chunk;
    private final int baseHeight;
    private final int baseRadius;
    private final double protrusionChance;
    private final double lavaFlowChance;
    private final double stalagmiteChance;
    boolean genChest = false;
    private Map<ChunkPos, Chunk> chunkPosChunkMap = new HashMap<ChunkPos, Chunk>();
    private boolean end;
    private int y;
    private int maxbaseHeight;

    public GeneratorVolcano(final World world, BlockPos position1) {
        this.world = world;
        BlockPos position2 = new BlockPos(position1.func_177958_n(), 30, position1.func_177952_p());
        this.rand = world.field_73012_v;
        this.end = false;
        this.chunkPos = new ChunkPos(position2);
        this.chunk = world.func_72964_e(this.chunkPos.field_77276_a, this.chunkPos.field_77275_b);
        this.baseHeight = 60 + this.rand.nextInt(30);
        this.baseRadius = 25 + this.rand.nextInt(20);
        this.protrusionChance = 0.05;
        this.lavaFlowChance = 0.01;
        this.stalagmiteChance = 0.1;
        this.blockPosList = new LinkedList();
        this.blockPosList1 = new LinkedList();
        this.maxbaseHeight = 0;
        for (int y = 0; y < this.baseHeight; ++y) {
            int radius = this.baseRadius - y / 2;
            if (radius >= 10) continue;
            this.maxbaseHeight = y;
            break;
        }
        if (basalts_ores == null) {
            this.initBasaltsOres();
        }
        int height = this.chunk.func_177433_f(position2);
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(position2.func_177958_n(), height, position2.func_177952_p());
        this.position = checkPos.func_177982_a(0, -this.maxbaseHeight / 2, 0);
        if (this.position.func_177956_o() > 60) {
            this.position = this.position.func_177982_a(0, -(this.position.func_177956_o() - 60), 0);
        }
        this.y = 0;
        this.end = false;
        this.thread = new Thread(){

            @Override
            public void run() {
                if (GeneratorVolcano.this.y == GeneratorVolcano.this.baseHeight) {
                    while (!GeneratorVolcano.this.genChest) {
                        BlockPos pos;
                        int index = GeneratorVolcano.this.rand.nextInt(GeneratorVolcano.this.blockPosList1.size());
                        if (GeneratorVolcano.this.rand.nextDouble() >= 0.95) {
                            pos = (BlockPos)GeneratorVolcano.this.blockPosList1.get(index);
                            if (world.func_180495_p(pos).func_185904_a() != Material.field_151579_a) {
                                pos = pos.func_177984_a();
                            }
                            GeneratorVolcano.this.generateChest(pos);
                            GeneratorVolcano.this.genChest = true;
                            continue;
                        }
                        pos = (BlockPos)GeneratorVolcano.this.blockPosList1.remove(index);
                        if (!GeneratorVolcano.this.blockPosList1.isEmpty()) continue;
                        if (world.func_180495_p(pos).func_185904_a() != Material.field_151579_a) {
                            pos = pos.func_177984_a();
                        }
                        GeneratorVolcano.this.generateChest(pos);
                        GeneratorVolcano.this.genChest = true;
                    }
                    GeneratorVolcano.this.end = true;
                    return;
                }
                int radius = GeneratorVolcano.this.baseRadius - GeneratorVolcano.this.y / 2;
                if (radius < 10) {
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + z * z > radius * radius) continue;
                            BlockPos pos = GeneratorVolcano.this.position.func_177982_a(x, GeneratorVolcano.this.y, z);
                            GeneratorVolcano.this.setBlockState1(world, pos, Blocks.field_150350_a.func_176223_P(), 3);
                        }
                    }
                    GeneratorVolcano.this.y++;
                    return;
                }
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + z * z > radius * radius) continue;
                        BlockPos pos = GeneratorVolcano.this.position.func_177982_a(x, GeneratorVolcano.this.y, z);
                        if (GeneratorVolcano.this.y >= GeneratorVolcano.this.baseHeight - 1 || x * x + z * z > (radius - 2) * (radius - 2)) {
                            world.func_180501_a(pos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                            if (GeneratorVolcano.this.y < GeneratorVolcano.this.baseHeight - 5 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.1 && GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.stalagmiteChance) {
                                for (int i = 1; i <= GeneratorVolcano.this.rand.nextInt(3); ++i) {
                                    BlockPos belowPos = pos.func_177979_c(i);
                                    GeneratorVolcano.this.setBlockState1(world, belowPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                            } else if ((double)GeneratorVolcano.this.y < (double)GeneratorVolcano.this.maxbaseHeight * 0.6 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.1 && GeneratorVolcano.this.rand.nextDouble() < 0.05) {
                                world.func_180501_a(pos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                for (int i = 1; i <= 3 + GeneratorVolcano.this.rand.nextInt(6); ++i) {
                                    BlockPos belowPos = pos.func_177979_c(i);
                                    GeneratorVolcano.this.setBlockState1(world, belowPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                            } else if ((double)GeneratorVolcano.this.y < (double)GeneratorVolcano.this.maxbaseHeight * 0.25 && (double)GeneratorVolcano.this.y > (double)GeneratorVolcano.this.maxbaseHeight * 0.025 && GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.lavaFlowChance) {
                                BlockPos belowPos = pos.func_177977_b();
                                GeneratorVolcano.this.setBlockState1(world, belowPos, FluidName.fluidpahoehoe_lava.getInstance().getBlock().func_176223_P(), 3);
                            }
                            if (GeneratorVolcano.this.rand.nextInt(1000) > 20) continue;
                            BlockPos belowPos = pos.func_177984_a();
                            GeneratorVolcano.this.setBlockState1(world, belowPos, FluidName.fluidpahoehoe_lava.getInstance().getBlock().func_176223_P(), 3);
                            continue;
                        }
                        if (GeneratorVolcano.this.y == 0) {
                            if (GeneratorVolcano.this.rand.nextDouble() < GeneratorVolcano.this.protrusionChance) {
                                int z1;
                                int i;
                                int type = GeneratorVolcano.this.rand.nextInt(5);
                                if (type == 0) {
                                    BlockPos protrusionPos = pos.func_177981_b(0);
                                    GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                    continue;
                                }
                                if (type == 1) {
                                    int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos protrusionPos = pos.func_177981_b(i);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                    GeneratorVolcano.this.blockPosList1.add(pos.func_177981_b(protrusionSize - 1));
                                    continue;
                                }
                                if (type == 2) {
                                    for (int x1 = -1; x1 < 2; ++x1) {
                                        for (z1 = -1; z1 < 2; ++z1) {
                                            BlockPos protrusionPos = pos.func_177982_a(x1, 0, z1);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                            GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                            GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        }
                                    }
                                    int[][] x1 = protrusionOffsets;
                                    z1 = x1.length;
                                    for (int protrusionPos = 0; protrusionPos < z1; ++protrusionPos) {
                                        int[] offset = x1[protrusionPos];
                                        for (int yy = 0; yy < offset[1]; ++yy) {
                                            BlockPos protrusionPos2 = pos.func_177982_a(offset[0], yy, offset[2]);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos2);
                                            GeneratorVolcano.this.setBlockState1(world, protrusionPos2, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                    continue;
                                }
                                if (type == 3) {
                                    for (int x1 = -1; x1 < 2; ++x1) {
                                        for (z1 = -1; z1 < 2; ++z1) {
                                            BlockPos protrusionPos = pos.func_177982_a(x1, 0, z1);
                                            GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                            GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockDownState(GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                            GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        }
                                    }
                                    int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos protrusionPos = pos.func_177981_b(i);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockStatePylon(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                    protrusionSize = GeneratorVolcano.this.rand.nextInt(protrusionSize);
                                    for (i = 0; i < protrusionSize; ++i) {
                                        BlockPos pos1;
                                        BlockPos protrusionPos = pos.func_177981_b(i);
                                        for (int z12 = -1; z12 < 2; z12 += 2) {
                                            pos1 = protrusionPos.func_177965_g(z12);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 32);
                                        }
                                        for (int x1 = -1; x1 < 2; x1 += 2) {
                                            pos1 = protrusionPos.func_177964_d(x1);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                    continue;
                                }
                                for (int x1 = -1; x1 < 2; ++x1) {
                                    for (z1 = -1; z1 < 2; ++z1) {
                                        BlockPos protrusionPos = pos.func_177982_a(x1, 0, z1);
                                        GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                        GeneratorVolcano.this.blockPosList1.add(protrusionPos);
                                        GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                    }
                                }
                                int protrusionSize = GeneratorVolcano.this.rand.nextInt(5) + 2;
                                for (i = 0; i < protrusionSize; ++i) {
                                    BlockPos protrusionPos = pos.func_177981_b(i);
                                    GeneratorVolcano.this.blockPosList.add(protrusionPos);
                                    GeneratorVolcano.this.setBlockState1(world, protrusionPos, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                }
                                protrusionSize = GeneratorVolcano.this.rand.nextInt(protrusionSize);
                                for (i = 0; i < protrusionSize; ++i) {
                                    BlockPos protrusionPos = pos.func_177981_b(i);
                                    for (int z13 = -1; z13 < 2; z13 += 2) {
                                        for (int x1 = -1; x1 < 2; x1 += 2) {
                                            BlockPos pos1 = protrusionPos.func_177965_g(z13);
                                            pos1 = pos1.func_177964_d(x1);
                                            GeneratorVolcano.this.blockPosList.add(pos1);
                                            GeneratorVolcano.this.setBlockState1(world, pos1, GeneratorVolcano.this.getBlockState(GeneratorVolcano.this.maxbaseHeight, GeneratorVolcano.this.y, GeneratorVolcano.this.rand), 3);
                                        }
                                    }
                                }
                                continue;
                            }
                            boolean remove = GeneratorVolcano.this.blockPosList.remove(pos);
                            if (remove) continue;
                            GeneratorVolcano.this.setBlockState1(world, pos, Blocks.field_150356_k.func_176223_P(), 3);
                            continue;
                        }
                        if (GeneratorVolcano.this.blockPosList.isEmpty() || GeneratorVolcano.this.y > 10) {
                            GeneratorVolcano.this.setBlockState1(world, pos, Blocks.field_150350_a.func_176223_P(), 3);
                            continue;
                        }
                        boolean remove = GeneratorVolcano.this.blockPosList.remove(pos);
                        if (remove) continue;
                        GeneratorVolcano.this.setBlockState1(world, pos, Blocks.field_150350_a.func_176223_P(), 3);
                    }
                }
                GeneratorVolcano.this.y = GeneratorVolcano.this.y + 1;
            }
        };
        this.thread.setPriority(1);
    }

    public IBlockState setBlockState(Chunk chunk, BlockPos pos, IBlockState state) {
        TileEntity te;
        int k;
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        if (j >= chunk.field_76638_b[l = (k = pos.func_177952_p() & 0xF) << 4 | i] - 1) {
            chunk.field_76638_b[l] = -999;
        }
        int i1 = chunk.field_76634_f[l];
        IBlockState iblockstate = chunk.func_177435_g(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        int k1 = iblockstate.getLightOpacity((IBlockAccess)this.world, pos);
        ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            chunk.field_76652_q[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, this.world.field_73011_w.func_191066_m());
            flag = j >= i1;
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!this.world.field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(this.world, pos, iblockstate);
            }
            if ((te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(this.world, pos, iblockstate, state)) {
                this.world.func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(this.world, pos, iblockstate, state)) {
            this.world.func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (!(this.world.field_72995_K || block1 == block || this.world.captureBlockSnapshots && !block.hasTileEntity(state))) {
            block.func_176213_c(this.world, pos, state);
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(this.world, state);
                this.world.func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        chunk.func_76630_e();
        return iblockstate;
    }

    public boolean setBlockState1(World world, BlockPos pos, IBlockState newState, int flags) {
        IBlockState iblockstate;
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Chunk chunk = this.chunkPosChunkMap.get(chunkPos);
        if (chunk == null) {
            chunk = world.func_175726_f(pos);
            this.chunkPosChunkMap.put(chunkPos, chunk);
        }
        pos = pos.func_185334_h();
        BlockSnapshot blockSnapshot = null;
        if (world.captureBlockSnapshots && !world.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos, (int)flags);
            world.capturedBlockSnapshots.add(blockSnapshot);
        }
        if ((iblockstate = this.setBlockState(chunk, pos, newState)) == null) {
            if (blockSnapshot != null) {
                world.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        if (blockSnapshot == null) {
            world.markAndNotifyBlock(pos, chunk, iblockstate, newState, flags);
        }
        return true;
    }

    private void initBasaltsOres() {
        basalts_ores = new IBlockState[WorldBaseGen.veinTypes.size()][];
        for (int i = 0; i < WorldBaseGen.veinTypes.size(); ++i) {
            ChanceOre chanceOre;
            int j;
            VeinType type = WorldBaseGen.veinTypes.get(i);
            int mineral = type.getHeavyOre() == null ? 0 : 1;
            GeneratorVolcano.basalts_ores[i] = new IBlockState[mineral + type.getOres().size()];
            if (type.getHeavyOre() != null) {
                if (type.getHeavyOre() instanceof BlockHeavyOre) {
                    GeneratorVolcano.basalts_ores[i][0] = IUItem.basaltheavyore.getStateMeta(type.getMeta());
                } else if (type.getHeavyOre() instanceof BlockMineral) {
                    GeneratorVolcano.basalts_ores[i][0] = IUItem.basaltheavyore1.getStateMeta(type.getMeta());
                }
                for (j = 0; j < type.getOres().size(); ++j) {
                    chanceOre = type.getOres().get(j);
                    GeneratorVolcano.basalts_ores[i][1 + j] = chanceOre.getBlock();
                }
                continue;
            }
            for (j = 0; j < type.getOres().size(); ++j) {
                chanceOre = type.getOres().get(j);
                GeneratorVolcano.basalts_ores[i][j] = chanceOre.getBlock();
            }
        }
    }

    public void generateChest(BlockPos pos) {
        IBlockState oldState = this.world.func_180495_p(pos);
        IBlockState newState = IUItem.invalid.func_176223_P();
        IMultiTileBlock teBlock = IUItem.volcanoChest.item.getTeBlock(new ItemStack((Block)IUItem.volcanoChest));
        Class<? extends TileEntityBlock> teClass = teBlock.getTeClass();
        TileEntityVolcanoChest te = (TileEntityVolcanoChest)TileEntityBlock.instantiate(teClass);
        if (this.world.func_180501_a(pos, newState, 0)) {
            this.world.func_175690_a(pos, (TileEntity)te);
            te.onPlaced(ItemStack.field_190927_a, null, EnumFacing.NORTH);
            this.world.markAndNotifyBlock(pos, this.world.func_175726_f(pos), oldState, te.getBlockState(), 3);
            if (!this.world.field_72995_K) {
                new PacketUpdateTile(te);
            }
        }
    }

    public IBlockState getBlockDownState(int y, Random random) {
        double chance = random.nextDouble();
        if (chance < 0.7) {
            double chance1 = random.nextDouble();
            if (chance1 < 0.9) {
                return basalt_blocked;
            }
            int meta = random.nextInt(WorldBaseGen.veinTypes.size());
            while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                meta = random.nextInt(WorldBaseGen.veinTypes.size());
            }
            return basalts_ores[meta][0];
        }
        if (chance < 0.9) {
            return basalt_cobblestone;
        }
        return basalt_magma;
    }

    public IBlockState getBlockState(int baseHeight, int y, Random random) {
        if ((double)y < (double)baseHeight * 0.15) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_melted;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.9) {
                return basalt_cobblestone;
            }
            return basalt_magma;
        }
        if ((double)y < (double)baseHeight * 0.7) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.8) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_spongy;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                VeinType vein = WorldBaseGen.veinTypes.get(meta);
                int index = vein.getHeavyOre() == null ? 0 : 1;
                int typeOreMeta = random.nextInt(vein.getOres().size());
                return basalts_ores[meta][index + typeOreMeta];
            }
            return basalt_magma;
        }
        double chance = random.nextDouble();
        if (chance < 0.25) {
            return basalt;
        }
        double chance1 = random.nextDouble();
        if (chance1 < 0.9) {
            if (chance1 < 0.45) {
                return basalt_smooth;
            }
            if (chance1 <= 0.48) {
                return basalt_sulfur_ore;
            }
            return Blocks.field_150348_b.func_176223_P();
        }
        int meta = random.nextInt(WorldBaseGen.veinTypes.size());
        VeinType vein = WorldBaseGen.veinTypes.get(meta);
        int index = vein.getHeavyOre() == null ? 0 : 1;
        int typeOreMeta = random.nextInt(vein.getOres().size());
        return basalts_ores[meta][index + typeOreMeta];
    }

    public IBlockState getBlockStatePylon(int baseHeight, int y, Random random) {
        if ((double)y < (double)baseHeight * 0.15) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.9) {
                return basalt_magma;
            }
            return basalt_boron_ore;
        }
        if ((double)y < (double)baseHeight * 0.7) {
            double chance = random.nextDouble();
            if (chance < 0.65) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                while (WorldBaseGen.veinTypes.get(meta).getHeavyOre() == null) {
                    meta = random.nextInt(WorldBaseGen.veinTypes.size());
                }
                return basalts_ores[meta][0];
            }
            if (chance < 0.8) {
                double chance1 = random.nextDouble();
                if (chance1 < 0.9) {
                    return basalt_pylon;
                }
                int meta = random.nextInt(WorldBaseGen.veinTypes.size());
                VeinType vein = WorldBaseGen.veinTypes.get(meta);
                int index = vein.getHeavyOre() == null ? 0 : 1;
                int typeOreMeta = random.nextInt(vein.getOres().size());
                return basalts_ores[meta][index + typeOreMeta];
            }
            return basalt_magma;
        }
        double chance = random.nextDouble();
        if (chance < 0.25) {
            return basalt_sulfur_ore;
        }
        double chance1 = random.nextDouble();
        if (chance1 < 0.9) {
            return basalt_pylon;
        }
        int meta = random.nextInt(WorldBaseGen.veinTypes.size());
        VeinType vein = WorldBaseGen.veinTypes.get(meta);
        int index = vein.getHeavyOre() == null ? 0 : 1;
        int typeOreMeta = random.nextInt(vein.getOres().size());
        return basalts_ores[meta][index + typeOreMeta];
    }

    public void generate() {
        this.thread.run();
    }

    public boolean isEnd() {
        return this.end;
    }
}

