/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.world.WorldBaseGen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class HiveGenerator
implements IWorldGenerator {
    private final Block hiveBlock;

    public HiveGenerator(Block hiveBlock) {
        this.hiveBlock = hiveBlock;
    }

    public static boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block.func_176200_f((IBlockAccess)world, pos) && !blockState.func_185904_a().func_76224_d();
    }

    public static boolean isTreeBlock(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block.isLeaves(blockState, (IBlockAccess)world, pos) || block.isWood((IBlockAccess)world, pos);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0 && WorldBaseGen.random.nextBoolean() && WorldBaseGen.random.nextInt(10) <= 5) {
            this.generateHives(world, rand, chunkX * 16, chunkZ * 16);
        }
    }

    public BlockPos getPosForHive(World world, int x, int z) {
        BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z)).func_177977_b();
        if (topPos.func_177956_o() <= 0) {
            return null;
        }
        IBlockState blockState = world.func_180495_p(topPos);
        if (!HiveGenerator.isTreeBlock(blockState, world, topPos)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        do {
            pos.func_189536_c(EnumFacing.DOWN);
        } while (HiveGenerator.isTreeBlock(blockState = world.func_180495_p((BlockPos)pos), world, (BlockPos)pos));
        return pos.func_185334_h();
    }

    private void generateHives(World world, Random rand, int x, int z) {
        int hivesPerChunk = 1;
        for (int i = 0; i < hivesPerChunk; ++i) {
            int posZ;
            int posX = x + rand.nextInt(16);
            BlockPos pos = this.getPosForHive(world, posX, posZ = z + rand.nextInt(16));
            if (pos == null) continue;
            Biome biome = world.func_180494_b(pos);
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                this.placeHive(world, pos, 2);
                continue;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                this.placeHive(world, pos, 0);
                continue;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                this.placeHive(world, pos, 1);
                continue;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                this.placeHive(world, pos, 3);
                continue;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
            this.placeHive(world, pos, 4);
        }
    }

    private void placeHive(World world, BlockPos pos, int meta) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos placePos = pos.func_177972_a(facing);
            if (!world.func_175623_d(placePos)) continue;
            IUItem.hive.item.placeBlockAt(new ItemStack((Block)IUItem.hive, 1, meta), null, world, pos, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f, this.hiveBlock.func_176203_a(meta));
            break;
        }
    }

    private BlockPos findLogInChunk(World world, int x, int z) {
        for (int y = 64; y < world.func_72800_K(); ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150364_r && world.func_180495_p(pos).func_177230_c() != Blocks.field_150363_s) continue;
            return pos;
        }
        return null;
    }
}

