/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.Config;
import com.denfop.IUItem;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.blocks.BlockThoriumOre;
import com.denfop.blocks.BlocksRadiationOre;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IMineral;
import com.denfop.world.HiveGenerator;
import com.denfop.world.TypeGas;
import com.denfop.world.WorldGenGas;
import com.denfop.world.WorldGenOil;
import com.denfop.world.WorldGenRubTree;
import com.denfop.world.WorldGenSandsOres;
import com.denfop.world.WorldGenVolcano;
import com.denfop.world.vein.AlgorithmVein;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldBaseGen
implements IWorldGenerator {
    public static List<VeinType> veinTypes = new ArrayList<VeinType>();
    public static List<VeinType> veinTypes1 = new ArrayList<VeinType>();
    public static Random random = new Random();
    final FluidName[] fluids = new FluidName[]{FluidName.fluidneft, FluidName.fluidsweet_medium_oil, FluidName.fluidsweet_heavy_oil, FluidName.fluidsour_light_oil, FluidName.fluidsour_medium_oil, FluidName.fluidsour_heavy_oil};

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldBaseGen(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new HiveGenerator(IUItem.hive), (int)0);
        WorldGenGas.registerFluid();
    }

    public static void initVein() {
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 0, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 60, 0), new ChanceOre(Blocks.field_150352_o.func_176223_P(), 25, 0), new ChanceOre(IUItem.ore2.func_176203_a(4), 15, 4)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 1, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(7), 28, 7), new ChanceOre(Blocks.field_150352_o.func_176223_P(), 44, 0), new ChanceOre(IUItem.classic_ore.func_176203_a(0), 28, 0)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 2, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(11), 26, 11), new ChanceOre(IUItem.classic_ore.func_176203_a(2), 74, 2)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 3, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 44, 8), new ChanceOre(IUItem.ore.func_176203_a(6), 56, 6)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 4, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 80, 0), new ChanceOre(IUItem.ore.func_176203_a(4), 20, 4)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 5, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(12), 16, 12), new ChanceOre(IUItem.ore.func_176203_a(11), 26, 11), new ChanceOre(IUItem.classic_ore.func_176203_a(1), 24, 1), new ChanceOre(IUItem.ore.func_176203_a(10), 34, 10)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 6, true, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(3).func_177226_a((IProperty)BlockClassicOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(true)), 60, 3, IUItem.classic_ore.func_176203_a(3)), new ChanceOre(IUItem.toriyore.func_176223_P(), 32, 0, IUItem.toriyore.func_176223_P().func_177226_a((IProperty)BlockThoriumOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false))), new ChanceOre(IUItem.radiationore.func_176203_a(1), 4, 1, IUItem.radiationore.func_176203_a(1).func_177226_a((IProperty)BlocksRadiationOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false))), new ChanceOre(IUItem.radiationore.func_176203_a(0), 3, 0, IUItem.radiationore.func_176203_a(0).func_177226_a((IProperty)BlocksRadiationOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false))), new ChanceOre(IUItem.radiationore.func_176203_a(2), 1, 2, IUItem.radiationore.func_176203_a(2).func_177226_a((IProperty)BlocksRadiationOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false)))));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 7, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(0), 55, 0), new ChanceOre(Blocks.field_150369_x.func_176223_P(), 23, 0), new ChanceOre(Blocks.field_150450_ax.func_176223_P(), 21, 0)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 8, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(13), 44, 13), new ChanceOre(IUItem.ore.func_176203_a(5), 28, 5), new ChanceOre(IUItem.ore.func_176203_a(0), 28, 0)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 9, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(4), 50, 4), new ChanceOre(IUItem.ore.func_176203_a(6), 50, 6)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 10, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 50, 8), new ChanceOre(IUItem.classic_ore.func_176203_a(3).func_177226_a((IProperty)BlockClassicOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(true)), 25, 3, IUItem.classic_ore.func_176203_a(3).func_177226_a((IProperty)BlockClassicOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false))), new ChanceOre(IUItem.toriyore.func_176223_P(), 25, 0, IUItem.toriyore.func_176223_P().func_177226_a((IProperty)BlockThoriumOre.BOOL_PROPERTY, (Comparable)Boolean.valueOf(false)))));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 11, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(12), 65, 12), new ChanceOre(Blocks.field_150365_q.func_176223_P(), 35, 0)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 12, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(8), 47, 8), new ChanceOre(Blocks.field_150366_p.func_176223_P(), 33, 0), new ChanceOre(IUItem.ore.func_176203_a(2), 33, 2)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 13, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(13), 66, 13), new ChanceOre(IUItem.ore.func_176203_a(5), 17, 5), new ChanceOre(IUItem.ore.func_176203_a(1), 17, 1)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 14, TypeVein.SMALL, new ChanceOre(Blocks.field_150366_p.func_176223_P(), 30, 0), new ChanceOre(IUItem.ore.func_176203_a(5), 40, 5), new ChanceOre(IUItem.ore.func_176203_a(1), 30, 1)));
        veinTypes.add(new VeinType((IMineral)IUItem.heavyore, 15, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(3), 80, 3), new ChanceOre(IUItem.classic_ore.func_176203_a(1), 20, 1)));
        veinTypes.add(new VeinType(null, 16, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(14), 70, 14), new ChanceOre(IUItem.ore.func_176203_a(7), 30, 7)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 3, 17, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(15), 60, 15), new ChanceOre(IUItem.classic_ore.func_176203_a(0), 20, 0), new ChanceOre(IUItem.ore3.func_176203_a(4), 20, 4)));
        veinTypes.add(new VeinType(null, 18, TypeVein.SMALL, new ChanceOre(IUItem.ore.func_176203_a(2), 50, 2), new ChanceOre(IUItem.ore.func_176203_a(9), 50, 9)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 7, 19, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(3), 65, 3), new ChanceOre(IUItem.ore.func_176203_a(14), 35, 14)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 4, 20, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(4), 50, 4), new ChanceOre(IUItem.ore.func_176203_a(13), 25, 13), new ChanceOre(IUItem.ore3.func_176203_a(9), 25, 9)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 8, 21, TypeVein.SMALL, new ChanceOre(IUItem.ore2.func_176203_a(5), 70, 5), new ChanceOre(IUItem.ore3.func_176203_a(0), 30, 0)));
        veinTypes.add(new VeinType(null, 22, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(0), 72, 0), new ChanceOre(IUItem.ore.func_176203_a(9), 28, 9)));
        veinTypes.add(new VeinType(null, 23, TypeVein.SMALL, new ChanceOre(IUItem.classic_ore.func_176203_a(1), 70, 1), new ChanceOre(IUItem.ore.func_176203_a(11), 30, 11)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 0, 24, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(0), 55, 0), new ChanceOre(Blocks.field_150366_p.func_176223_P(), 35, 0), new ChanceOre(IUItem.ore.func_176203_a(6), 10, 6)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 1, 25, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(10), 60, 10), new ChanceOre(IUItem.ore3.func_176203_a(11), 40, 11)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 2, 26, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(7), 50, 7), new ChanceOre(IUItem.ore.func_176203_a(3), 50, 3)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 6, 27, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(6), 70, 6), new ChanceOre(IUItem.ore3.func_176203_a(3), 30, 3)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 9, 28, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(12), 50, 12), new ChanceOre(IUItem.ore3.func_176203_a(2), 20, 2), new ChanceOre(IUItem.ore3.func_176203_a(0), 30, 0)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 5, 29, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(13), 50, 13), new ChanceOre(IUItem.classic_ore.func_176203_a(2), 50, 2)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 12, 30, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(14), 70, 14), new ChanceOre(IUItem.ore3.func_176203_a(5), 30, 5)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 11, 31, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(12), 70, 12), new ChanceOre(IUItem.ore3.func_176203_a(1), 30, 1)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 10, 32, TypeVein.SMALL, new ChanceOre(IUItem.ore3.func_176203_a(8), 70, 8), new ChanceOre(IUItem.ore3.func_176203_a(9), 30, 9)));
        veinTypes.add(new VeinType(null, 0, 33, TypeVein.SMALL, new ChanceOre(IUItem.apatite.func_176203_a(0), 30, 0), new ChanceOre(IUItem.apatite.func_176203_a(1), 30, 1), new ChanceOre(IUItem.apatite.func_176203_a(2), 18, 2), new ChanceOre(IUItem.apatite.func_176203_a(3), 11, 3), new ChanceOre(IUItem.apatite.func_176203_a(4), 11, 4)));
        veinTypes.add(new VeinType((IMineral)IUItem.mineral, 13, 34, TypeVein.SMALL, new ChanceOre(Blocks.field_150365_q.func_176223_P(), 35, 0), new ChanceOre(IUItem.preciousore.func_176203_a(3), 30, 3), new ChanceOre(IUItem.ore.func_176203_a(10), 25, 10), new ChanceOre(IUItem.ore3.func_176203_a(15), 10, 15)));
        veinTypes.add(new VeinType(null, 0, 35, TypeVein.SMALL, new ChanceOre(Blocks.field_150365_q.func_176223_P(), 100, 0)));
        veinTypes.add(new VeinType(null, 0, 36, TypeVein.SMALL, new ChanceOre(Blocks.field_150450_ax.func_176223_P(), 61, 0), new ChanceOre(IUItem.preciousore.func_176203_a(0), 13, 0), new ChanceOre(IUItem.preciousore.func_176203_a(1), 13, 1), new ChanceOre(IUItem.preciousore.func_176203_a(2), 13, 2)));
    }

    private static int randomX(Chunk chunk, Random rnd) {
        return chunk.field_76635_g * 16 + rnd.nextInt(16);
    }

    private static int randomZ(Chunk chunk, Random rnd) {
        return chunk.field_76647_h * 16 + rnd.nextInt(16);
    }

    private static void genRubberTree(Chunk chunk, float baseScale) {
        int i;
        int rubberTrees;
        Biome[] biomes = new Biome[6];
        for (rubberTrees = 0; rubberTrees < 5; ++rubberTrees) {
            int x = chunk.field_76635_g * 16 + 8 + (rubberTrees & 2) * 15;
            i = chunk.field_76647_h * 16 + 8 + ((rubberTrees & 2) >>> 1) * 15;
            BlockPos pos = new BlockPos(x, chunk.func_177412_p().func_181545_F(), i);
            biomes[rubberTrees] = chunk.func_177412_p().func_72959_q().func_180300_a(pos, Biomes.field_76772_c);
        }
        rubberTrees = 0;
        for (Biome biome : biomes) {
            if (biome == null) continue;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubberTrees += random.nextInt(10) + 2;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                rubberTrees += random.nextInt(15) + 5;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) continue;
            rubberTrees += random.nextInt(5) + 1;
        }
        rubberTrees = Math.round((float)rubberTrees * baseScale);
        if ((rubberTrees /= 2) > 0 && random.nextInt(100) < rubberTrees) {
            WorldGenRubTree gen = new WorldGenRubTree(false);
            for (i = 0; i < rubberTrees; ++i) {
                if (!TerrainGen.decorate((World)chunk.func_177412_p(), (Random)random, (ChunkPos)chunk.func_76632_l(), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) || gen.func_180709_b(chunk.func_177412_p(), random, new BlockPos(WorldBaseGen.randomX(chunk, random), chunk.func_177412_p().func_181545_F(), WorldBaseGen.randomZ(chunk, random)))) continue;
                rubberTrees -= 3;
            }
        }
    }

    public static void remove(Block block) {
        Iterator<VeinType> iter = veinTypes.iterator();
        while (iter.hasNext()) {
            VeinType vein = iter.next();
            if (vein.getHeavyOre() != null && vein.getHeavyOre().getBlock() == block) {
                iter.remove();
                continue;
            }
            vein.getOres().removeIf(chanceOre -> chanceOre.getBlock().func_177230_c() == block);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (Config.DimensionList.contains(world.field_73011_w.getDimension())) {
            int var5;
            int var4;
            int var3;
            BlockPos chunkPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            ChunkPos forgeChunkPos = new ChunkPos(chunkPos);
            if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY) && WorldBaseGen.random.nextInt(100) >= 70) {
                int i6;
                int l1;
                int i1;
                if (world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)) != Biome.func_150568_d((int)6)) {
                    if (WorldBaseGen.random.nextInt(100) > 39) {
                        for (i1 = 0; i1 < 1; ++i1) {
                            l1 = random.nextInt(16) + 8;
                            i6 = random.nextInt(16) + 8;
                            new WorldGenSandsOres(random.nextInt(4) + 4, IUItem.ore2.func_176203_a(7)).func_180709_b(world, random, world.func_175672_r(chunkPos.func_177982_a(l1, 0, i6)));
                        }
                    } else {
                        for (i1 = 0; i1 < 1; ++i1) {
                            l1 = random.nextInt(16) + 8;
                            i6 = random.nextInt(16) + 8;
                            new WorldGenSandsOres(random.nextInt(4) + 4, IUItem.ore2.func_176203_a(6)).func_180709_b(world, random, world.func_175672_r(chunkPos.func_177982_a(l1, 0, i6)));
                        }
                    }
                } else if (WorldBaseGen.random.nextInt(100) > 39) {
                    for (i1 = 0; i1 < 1; ++i1) {
                        l1 = random.nextInt(16) + 8;
                        i6 = random.nextInt(16) + 8;
                        new WorldGenSandsOres(random.nextInt(4) + 4, IUItem.blockResource.func_176203_a(10)).func_180709_b(world, random, world.func_175672_r(chunkPos.func_177982_a(l1, 0, i6)));
                    }
                }
            }
            if (random.nextInt(100) + 1 > 70 && world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)) == Biome.func_150568_d((int)2)) {
                for (int var2 = 0; var2 < 1; ++var2) {
                    var3 = chunkX * 16 + random.nextInt(16) + 8;
                    var4 = random.nextInt(random.nextInt(random.nextInt(112) + 8) + 8) + 60;
                    var5 = chunkZ * 16 + random.nextInt(16) + 8;
                    FluidName fluidName = this.fluids[random.nextInt(this.fluids.length)];
                    if (fluidName == null) continue;
                    new WorldGenOil(fluidName.getInstance().getBlock(), fluidName.getInstance().getBlock()).func_180709_b(world, random, new BlockPos(var3, var4, var5));
                }
            }
            if (WorldBaseGen.random.nextInt(900) + 1 > 500) {
                Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
                var3 = chunkX * 16 + random.nextInt(16) + 8;
                var4 = random.nextInt(random.nextInt(random.nextInt(30) + 20) + 8);
                var5 = chunkZ * 16 + random.nextInt(16) + 8;
                if (biome instanceof BiomeOcean || biome instanceof BiomeRiver) {
                    int rand = WorldBaseGen.random.nextInt(100);
                    TypeGas typeGas = rand < 50 ? TypeGas.GAS : (rand < 75 ? TypeGas.IODINE : TypeGas.FLUORINE);
                    new WorldGenGas(typeGas).func_180709_b(world, random, new BlockPos(var3, var4, var5));
                } else {
                    int rand = WorldBaseGen.random.nextInt(100);
                    TypeGas typeGas = rand < 50 ? TypeGas.GAS : (rand < 75 ? TypeGas.BROMIDE : TypeGas.CHLORINE);
                    new WorldGenGas(typeGas).func_180709_b(world, random, new BlockPos(var3, var4, var5));
                }
            }
            Chunk chunk = chunkProvider.func_186025_d(chunkX, chunkZ);
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16, chunkGenerator, chunkProvider, chunk);
            WorldBaseGen.genRubberTree(chunk, 2.0f);
        }
    }

    private void generateSurface(World world, Random random, int x, int y, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, Chunk chunk) {
        if (WorldBaseGen.random.nextInt(4) <= 2) {
            if (veinTypes1.isEmpty()) {
                veinTypes1 = new ArrayList<VeinType>(veinTypes);
            }
            int meta = WorldBaseGen.random.nextInt(veinTypes1.size());
            VeinType veinType = veinTypes1.remove(meta);
            AlgorithmVein.generate(world, veinType, new BlockPos(x + random.nextInt(16), 2, y + random.nextInt(16)), chunk, veinType.getDeposits_meta(), chunkProvider, chunkGenerator);
        }
        BlockPos pos1 = new BlockPos(x + random.nextInt(16), 2, y + random.nextInt(16));
        Biome biome = chunk.func_177412_p().func_72959_q().func_180300_a(pos1, Biomes.field_76772_c);
        if (biome instanceof BiomeHills && WorldBaseGen.random.nextInt(100) == 95 && WorldBaseGen.random.nextInt(100) >= 60) {
            new WorldGenVolcano().func_180709_b(world, world.field_73012_v, pos1);
        }
    }

    public void addOreSpawn(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

