/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.blocks.FluidName;
import com.denfop.world.GenData;
import com.denfop.world.TypeGas;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGas
extends WorldGenerator {
    public static Map<ChunkPos, GenData> gasMap = new HashMap<ChunkPos, GenData>();
    public static Map<TypeGas, FluidName> gasFluidMap = new HashMap<TypeGas, FluidName>();
    private final TypeGas typeGas;
    private Block block = FluidName.fluidgas.getInstance().getBlock();

    public WorldGenGas(TypeGas typeGas) {
        this.block = gasFluidMap.get((Object)typeGas).getInstance().getBlock();
        this.typeGas = typeGas;
    }

    public static void registerFluid() {
        gasFluidMap.put(TypeGas.GAS, FluidName.fluidgas);
        gasFluidMap.put(TypeGas.BROMIDE, FluidName.fluidbromine);
        gasFluidMap.put(TypeGas.CHLORINE, FluidName.fluidchlorum);
        gasFluidMap.put(TypeGas.FLUORINE, FluidName.fluidfluor);
        gasFluidMap.put(TypeGas.IODINE, FluidName.fluidiodine);
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int k;
        int j;
        int x = pos.func_177958_n() - 8;
        int z = pos.func_177952_p() - 8;
        int y = pos.func_177956_o();
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int zmin = Integer.MAX_VALUE;
        int zmax = Integer.MIN_VALUE;
        int ymin = 255;
        int ymax = 0;
        if (rand.nextInt(500) <= 450) {
            return false;
        }
        if (y > 40) {
            return false;
        }
        if (y <= 4) {
            return false;
        }
        boolean can = false;
        boolean[] arrayOfBoolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j2 = 0; j2 < i; ++j2) {
            double d1 = rand.nextDouble() * 6.0 + 3.0;
            double d2 = rand.nextDouble() * 4.0 + 2.0;
            double d3 = rand.nextDouble() * 6.0 + 3.0;
            double d4 = rand.nextDouble() * (16.0 - d1 - 2.0) + 1.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (8.0 - d2 - 4.0) + 2.0 + d2 / 2.0;
            double d6 = rand.nextDouble() * (16.0 - d3 - 2.0) + 1.0 + d3 / 2.0;
            for (int i2 = 1; i2 < 15; ++i2) {
                for (int i3 = 1; i3 < 15; ++i3) {
                    for (int i4 = 1; i4 < 7; ++i4) {
                        double d7 = ((double)i2 - d4) / (d1 / 2.0);
                        double d8 = ((double)i4 - d5) / (d2 / 2.0);
                        double d9 = ((double)i3 - d6) / (d3 / 2.0);
                        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (!(d10 < 1.0)) continue;
                        arrayOfBoolean[(i2 * 16 + i3) * 8 + i4] = true;
                    }
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    boolean n;
                    int i1 = (j * 16 + k) * 8 + m;
                    boolean bl = n = arrayOfBoolean[i1] && (j < 15 && arrayOfBoolean[((j + 1) * 16 + k) * 8 + m] || j > 0 && arrayOfBoolean[((j - 1) * 16 + k) * 8 + m] || k < 15 && arrayOfBoolean[(j * 16 + k + 1) * 8 + m] || k > 0 && arrayOfBoolean[(j * 16 + k - 1) * 8 + m] || m < 7 && arrayOfBoolean[(j * 16 + k) * 8 + m + 1] || m > 0 && arrayOfBoolean[i1 - 1]);
                    if (!n) continue;
                    IBlockState block_state1 = world.func_180495_p(new BlockPos(x + j, y + m, z + k));
                    Material localMaterial = block_state1.func_185904_a();
                    if (m >= 4 && localMaterial.func_76224_d()) {
                        return false;
                    }
                    if (m >= 4 || localMaterial.func_76220_a() || block_state1.func_177230_c() == this.block) continue;
                    return false;
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    if (!arrayOfBoolean[(j * 16 + k) * 8 + m]) continue;
                    BlockPos pos1 = new BlockPos(x + j, y + m, z + k);
                    world.func_180501_a(pos1, m >= 4 ? Blocks.field_150350_a.func_176223_P() : this.block.func_176223_P(), 2);
                    if (m >= 4) continue;
                    can = true;
                    if (xmin > x + j) {
                        xmin = x + j;
                    }
                    if (xmax < x + j) {
                        xmax = x + j;
                    }
                    if (zmin > z + k) {
                        zmin = z + k;
                    }
                    if (zmax < z + k) {
                        zmax = z + k;
                    }
                    if (ymin > y + m) {
                        ymin = y + m;
                    }
                    if (ymax >= y + m) continue;
                    ymax = y + m;
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 4; m < 8; ++m) {
                    IBlockState block_states = null;
                    boolean need = arrayOfBoolean[(j * 16 + k) * 8 + m];
                    if (need) {
                        block_states = world.func_180495_p(new BlockPos(x + j, y + m - 1, z + k));
                    }
                    if (!need || block_states.func_177230_c() != Blocks.field_150346_d && block_states.func_177230_c() != Blocks.field_150355_j || world.func_175657_ab() <= 0) continue;
                    world.func_175656_a(new BlockPos(x + j, y + m - 1, z + k), Blocks.field_150349_c.func_176223_P());
                }
            }
        }
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                for (int m = 0; m < 8; ++m) {
                    boolean i1;
                    int i2 = (j * 16 + k) * 8 + m;
                    boolean bl = i1 = arrayOfBoolean[i2] && (j < 15 && arrayOfBoolean[((j + 1) * 16 + k) * 8 + m] || j > 0 && arrayOfBoolean[((j - 1) * 16 + k) * 8 + m] || k < 15 && arrayOfBoolean[(j * 16 + k + 1) * 8 + m] || k > 0 && arrayOfBoolean[(j * 16 + k - 1) * 8 + m] || m < 7 && arrayOfBoolean[(j * 16 + k) * 8 + m + 1] || m > 0 && arrayOfBoolean[i2 - 1]);
                    if (!i1 || m >= 4 && rand.nextInt(2) == 0 || !world.func_180495_p(new BlockPos(x + j, y + m, z + k)).func_185904_a().func_76220_a()) continue;
                    world.func_175656_a(new BlockPos(x + j, y + m, z + k), this.block.func_176223_P());
                    if (xmin > x + j) {
                        xmin = x + j;
                    }
                    if (xmax < x + j) {
                        xmax = x + j;
                    }
                    if (zmin > z + k) {
                        zmin = z + k;
                    }
                    if (zmax < z + k) {
                        zmax = z + k;
                    }
                    if (ymin > y + m) {
                        ymin = y + m;
                    }
                    if (ymax < y + m) {
                        ymax = y + m;
                    }
                    can = true;
                }
            }
        }
        int xCenter = (xmin + xmax) / 2;
        int zCenter = (zmin + zmax) / 2;
        int yCenter = (ymin + ymax) / 2;
        if (can) {
            can = false;
            block16: for (int x1 = -1; x1 < 2; ++x1) {
                for (int z1 = -1; z1 < 2; ++z1) {
                    for (int y1 = -1; y1 < 2; ++y1) {
                        if (!world.func_180495_p(new BlockPos(xCenter + x1, yCenter + y1, zCenter + z1)).func_185904_a().func_76224_d()) continue;
                        can = true;
                        break block16;
                    }
                }
            }
            if (can) {
                gasMap.put(new ChunkPos(xCenter >> 4, zCenter >> 4), new GenData(yCenter, xCenter, zCenter, this.typeGas));
            }
        }
        return true;
    }
}

