/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.blocks.IULeaves;
import com.denfop.world.WorldBaseGen;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenRubTree
extends WorldGenAbstractTree {
    public WorldGenRubTree(boolean notify) {
        super(notify);
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd || blockType == IUItem.rubberSapling || blockType == IUItem.rubWood || blockType == IUItem.leaves;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(5) + rand.nextInt(4) + rand.nextInt(2);
        if (i <= 3) {
            i = 4;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                IBlockState state = worldIn.func_180495_p(position.func_177982_a(x, 0, z));
                if (state.func_185904_a() != Material.field_151575_d && state.func_177230_c() != IUItem.rubWood) continue;
                return false;
            }
        }
        boolean flag = true;
        BlockRubWood woodBlock = IUItem.rubWood;
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                Biome biome = worldIn.func_180494_b(position);
                if (!(biome instanceof BiomeSwamp) && !(biome instanceof BiomeJungle)) {
                    for (int i2 = position.func_177956_o() - i / 2 + i; i2 <= position.func_177956_o() + i + 1 + rand.nextInt(3); ++i2) {
                        int i3;
                        BlockPos blockpos;
                        IBlockState state2;
                        int l1;
                        int k1;
                        IBlockState state22;
                        BlockPos blockpos2;
                        int[][] offsets;
                        int k2 = i2 - (position.func_177956_o() + i + 1);
                        int l2 = 3;
                        if (i2 >= position.func_177956_o() + i) {
                            l2 = 1;
                        }
                        if (i2 == position.func_177956_o() + i) {
                            for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                                blockpos2 = new BlockPos(position.func_177958_n() + offset[0], i2, position.func_177952_p() + offset[1]);
                                state22 = worldIn.func_180495_p(blockpos2);
                                if (!state22.func_177230_c().isAir(state22, (IBlockAccess)worldIn, blockpos2)) continue;
                                this.func_175903_a(worldIn, blockpos2, leaves);
                            }
                        }
                        if (i2 == position.func_177956_o() - i / 2 + i + 1) {
                            l2 = 3;
                            for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                                blockpos2 = new BlockPos(position.func_177958_n() + offset[0], i2, position.func_177952_p() + offset[1]);
                                state22 = worldIn.func_180495_p(blockpos2);
                                if (!state22.func_177230_c().isAir(state22, (IBlockAccess)worldIn, blockpos2)) continue;
                                this.func_175903_a(worldIn, blockpos2, leaves);
                            }
                        }
                        if (i2 == position.func_177956_o() - i / 2 + i) {
                            l2 = 4;
                            if (i > 6) {
                                int i32;
                                for (i32 = position.func_177958_n() - l2 / 2; i32 <= position.func_177958_n() + l2 / 2; ++i32) {
                                    int j1 = i32 - position.func_177958_n();
                                    for (k1 = position.func_177952_p() - l2 / 2; k1 <= position.func_177952_p() + l2 / 2; ++k1) {
                                        l1 = k1 - position.func_177952_p();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i32, i2 - 1, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                                        this.func_175903_a(worldIn, blockpos, leaves);
                                    }
                                }
                                for (i32 = position.func_177958_n() - 2; i32 <= position.func_177958_n() + 2; i32 += 4) {
                                    int j1 = i32 - position.func_177958_n();
                                    for (k1 = position.func_177952_p() - 2; k1 <= position.func_177952_p() + 2; k1 += 4) {
                                        l1 = k1 - position.func_177952_p();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i32, i2 - 1, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                                        this.func_175903_a(worldIn, blockpos, Blocks.field_150350_a.func_176223_P());
                                    }
                                }
                            }
                            l2 = 4;
                        }
                        for (i3 = position.func_177958_n() - l2 / 2; i3 <= position.func_177958_n() + l2 / 2; ++i3) {
                            int j1 = i3 - position.func_177958_n();
                            for (k1 = position.func_177952_p() - l2 / 2; k1 <= position.func_177952_p() + l2 / 2; ++k1) {
                                l1 = k1 - position.func_177952_p();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                                this.func_175903_a(worldIn, blockpos, leaves);
                            }
                        }
                        if (i2 != position.func_177956_o() - i / 2 + i) continue;
                        for (i3 = position.func_177958_n() - 2; i3 <= position.func_177958_n() + 2; i3 += 4) {
                            int j1 = i3 - position.func_177958_n();
                            for (k1 = position.func_177952_p() - 2; k1 <= position.func_177952_p() + 2; k1 += 4) {
                                l1 = k1 - position.func_177952_p();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                                this.func_175903_a(worldIn, blockpos, Blocks.field_150350_a.func_176223_P());
                            }
                        }
                    }
                    int treeholechance = 40;
                    for (int j2 = 0; j2 < i; ++j2) {
                        BlockPos upN = position.func_177981_b(j2);
                        IBlockState state2 = worldIn.func_180495_p(upN);
                        if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) && state2.func_177230_c() != IUItem.rubberSapling) continue;
                        if (rand.nextInt(100) <= treeholechance) {
                            treeholechance -= 10;
                            this.func_175903_a(worldIn, position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                            continue;
                        }
                        this.func_175903_a(worldIn, position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
                    }
                } else if (biome instanceof BiomeSwamp) {
                    HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
                    boolean create = this.createSwampTree(WorldBaseGen.random, position, worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.func_175903_a(worldIn, (BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                        }
                    }
                } else {
                    HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
                    boolean create = this.createRubTree(WorldBaseGen.random, position, worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.func_175903_a(worldIn, (BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean createRubTree(Random rand, BlockPos position, World worldIn, Map<BlockPos, IBlockState> map) {
        BlockPos pos2;
        int max = 6 + WorldBaseGen.random.nextInt(3);
        int treeholechance = 90;
        BlockTropicalRubWood woodBlock = IUItem.tropicalRubWood;
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                BlockPos upN = position.func_177977_b().func_177982_a(x, 0, z);
                BlockTropicalRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                pos2 = upN;
                map.put(pos2, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
            }
        }
        for (int j2 = 0; j2 < max; ++j2) {
            BlockPos upN = position.func_177981_b(j2);
            IBlockState state2 = worldIn.func_180495_p(upN);
            if (j2 == max - 1) {
                BlockPos upN1;
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        int j;
                        int yy;
                        int zz;
                        BlockPos upN2;
                        int xx;
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.func_177982_a(x, 0, z);
                        BlockTropicalRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                        BlockPos pos22 = upN1;
                        map.put(pos22, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.func_177984_a();
                        if (x <= -1) {
                            upN1 = upN1.func_177982_a(-1, 0, 0);
                        } else if (z <= -1) {
                            upN1 = upN1.func_177982_a(0, 0, -1);
                        } else if (x >= 1) {
                            upN1 = upN1.func_177982_a(1, 0, 0);
                        } else if (z >= 1) {
                            upN1 = upN1.func_177982_a(0, 0, 1);
                        }
                        pos22 = upN1;
                        map.put(pos22, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (xx = -1; xx < 2; ++xx) {
                            for (int zz2 = -1; zz2 < 2; ++zz2) {
                                if (xx == 0 && zz2 == 0 || xx == -1 && zz2 == -1 || xx == 1 && zz2 == 1 || xx == 1 && zz2 == -1 || xx == -1 && zz2 == 1) continue;
                                upN2 = upN1.func_177982_a(xx, 0, zz2);
                                map.put(upN2, leaves);
                            }
                        }
                        pos22 = upN1 = upN1.func_177984_a();
                        map.put(pos22, leaves);
                        upN1 = upN1.func_177977_b();
                        if (x == -2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.func_177982_a(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(-1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN22;
                                pos22 = upN22 = upN1.func_177982_a(0, j, 0);
                                map.put(pos22, leaves);
                                if (j != 0) continue;
                                for (int zz3 = -1; zz3 < 2; ++zz3) {
                                    for (int yy2 = -1; yy2 < 2; ++yy2) {
                                        BlockPos upN3;
                                        if (zz3 == 0 && yy2 == 0 || zz3 == -1 && yy2 == -1 || zz3 == 1 && yy2 == 1 || zz3 == 1 && yy2 == -1 || zz3 == -1 && yy2 == 1) continue;
                                        pos22 = upN3 = upN1.func_177982_a(0, yy2, zz3);
                                        map.put(pos22, leaves);
                                    }
                                }
                            }
                            continue;
                        }
                        if (z == -2) {
                            for (xx = -1; xx < 2; ++xx) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.func_177982_a(xx, yy, 0);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(0, 0, -1);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN23;
                                pos22 = upN23 = upN1.func_177982_a(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (x == 2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.func_177982_a(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN24;
                                pos22 = upN24 = upN1.func_177982_a(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (z != 2) continue;
                        for (xx = -1; xx < 2; ++xx) {
                            for (yy = -1; yy < 2; ++yy) {
                                pos22 = upN2 = upN1.func_177982_a(xx, yy, 0);
                                map.put(pos22, leaves);
                            }
                        }
                        upN1 = upN1.func_177982_a(0, 0, 1);
                        for (j = 1; j > -4; --j) {
                            BlockPos upN25;
                            pos22 = upN25 = upN1.func_177982_a(0, j, 0);
                            map.put(pos22, leaves);
                        }
                    }
                }
                upN1 = upN.func_177984_a();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (!(xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1)) continue;
                        BlockPos upN2 = upN1.func_177982_a(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
                pos2 = upN1;
                map.put(pos2, leaves);
                upN1 = upN.func_177984_a().func_177984_a();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1) continue;
                        BlockPos upN2 = upN1.func_177982_a(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
            }
            if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) && state2.func_177230_c() != IUItem.rubberSapling) continue;
            if (rand.nextInt(100) <= treeholechance && j2 < max - 1) {
                treeholechance -= 10;
                map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                continue;
            }
            map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
        }
        return true;
    }

    private boolean createSwampTree(Random rand, BlockPos position, World worldIn, Map<BlockPos, IBlockState> map) {
        int treeholechance = 60;
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        BlockSwampRubWood woodBlock = IUItem.swampRubWood;
        if (rand.nextInt(2) == 0) {
            int max = 7 + rand.nextInt(4);
            EnumFacing facing = null;
            for (int j2 = 0; j2 < max; ++j2) {
                BlockPos upN = position.func_177981_b(j2);
                IBlockState state2 = worldIn.func_180495_p(upN);
                int type = WorldBaseGen.random.nextInt(3);
                if (WorldBaseGen.random.nextInt(100) <= 50 && j2 > 1 && j2 != max - 1) {
                    EnumFacing prevFacing;
                    if (type == 0) {
                        prevFacing = facing;
                        facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN.func_177972_a(facing);
                        IBlockState state1 = worldIn.func_180495_p(pos1);
                        if (!state1.func_177230_c().isAir(state1, (IBlockAccess)worldIn, pos1) && !state1.func_177230_c().isLeaves(state1, (IBlockAccess)worldIn, pos1) && state1.func_177230_c() != IUItem.rubberSapling) {
                            return false;
                        }
                        BlockSwampRubWood.RubberWoodState rubberWoodState = facing.func_176740_k() == EnumFacing.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        map.put(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (int x = -1; x < 2; ++x) {
                            for (int z = -1; z < 2; ++z) {
                                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                BlockPos pos2 = pos1.func_177982_a(x, 0, z);
                                IBlockState state3 = worldIn.func_180495_p(pos2);
                                if (state3.func_185904_a() == Material.field_151579_a) {
                                    map.put(pos2, leaves);
                                    continue;
                                }
                                return false;
                            }
                        }
                    } else if (type == 1) {
                        int ii;
                        prevFacing = facing;
                        facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN;
                        int max1 = 2;
                        for (ii = 0; ii < max1; ++ii) {
                            IBlockState state1 = worldIn.func_180495_p(pos1 = pos1.func_177972_a(facing));
                            if (!state1.func_177230_c().isAir(state1, (IBlockAccess)worldIn, pos1) && !state1.func_177230_c().isLeaves(state1, (IBlockAccess)worldIn, pos1) && state1.func_177230_c() != IUItem.rubberSapling) {
                                return false;
                            }
                            BlockSwampRubWood.RubberWoodState rubberWoodState = facing.func_176740_k() == EnumFacing.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                            map.put(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.func_177982_a(x, 0, z);
                                    IBlockState state3 = worldIn.func_180495_p(pos2);
                                    if (state3.func_185904_a() == Material.field_151579_a) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                        }
                        max1 = 1;
                        for (ii = 0; ii < max1; ++ii) {
                            pos1 = pos1.func_177984_a();
                            if (rand.nextInt(100) <= treeholechance) {
                                treeholechance -= 10;
                                this.func_175903_a(worldIn, pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                            } else {
                                this.func_175903_a(worldIn, pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                            }
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.func_177982_a(x, 0, z);
                                    IBlockState state3 = worldIn.func_180495_p(pos2);
                                    if (state3.func_185904_a() == Material.field_151579_a) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                            BlockPos pos2 = pos1.func_177984_a();
                            IBlockState state3 = worldIn.func_180495_p(pos2);
                            if (state3.func_185904_a() != Material.field_151579_a) {
                                return false;
                            }
                            map.put(pos2, leaves);
                        }
                    }
                }
                if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) && state2.func_177230_c() != IUItem.rubberSapling) continue;
                if (rand.nextInt(100) <= treeholechance) {
                    treeholechance -= 10;
                    map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                } else {
                    map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                }
                BlockPos pos = position.func_177981_b(j2);
                if (j2 >= 3) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || j2 >= max - 3 && (x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1)) continue;
                            BlockPos pos1 = pos.func_177982_a(x, 0, z);
                            IBlockState state1 = worldIn.func_180495_p(pos1);
                            if (state1.func_185904_a() == Material.field_151579_a) {
                                map.put(pos1, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (j2 != max - 1) continue;
                BlockPos pos2 = pos.func_177984_a();
                IBlockState state3 = worldIn.func_180495_p(pos2);
                if (state3.func_185904_a() == Material.field_151579_a) {
                    map.put(pos2, leaves);
                    continue;
                }
                return false;
            }
        } else {
            treeholechance = 60;
            woodBlock = IUItem.swampRubWood;
            int max = 5 + rand.nextInt(4);
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                    BlockPos upN = position.func_177977_b().func_177982_a(x, 0, z);
                    BlockSwampRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                    BlockPos pos2 = upN;
                    IBlockState state3 = worldIn.func_180495_p(pos2);
                    if (state3.func_185904_a() != Material.field_151579_a) {
                        return false;
                    }
                    map.put(pos2, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                }
            }
            for (int j2 = 0; j2 < max; ++j2) {
                IBlockState state3;
                int y;
                BlockPos upN = position.func_177981_b(j2);
                IBlockState state2 = worldIn.func_180495_p(upN);
                if (j2 < max - 1) {
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) && state2.func_177230_c() != IUItem.rubberSapling) continue;
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                        continue;
                    }
                    map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    continue;
                }
                if (j2 != max - 1) continue;
                if (state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) || state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) || state2.func_177230_c() == IUItem.rubberSapling) {
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                    } else {
                        map.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    }
                }
                BlockPos upN1 = position.func_177981_b(j2);
                for (y = 0; y < 5; ++y) {
                    int radius = 0;
                    if (y < 3) {
                        radius = 3;
                    }
                    if (y == 3) {
                        radius = 1;
                    }
                    if (y == 4) {
                        radius = 0;
                    }
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + z * z > radius * radius || Math.abs(x) == Math.abs(z) && Math.abs(x) == 2 || y == 2 && (Math.abs(z) == 0 && Math.abs(x) == 3 || Math.abs(z) == 3 && Math.abs(x) == 0)) continue;
                            BlockPos pos = upN1.func_177982_a(x, y, z);
                            state2 = worldIn.func_180495_p(pos);
                            if (state2.func_185904_a() == Material.field_151579_a) {
                                map.put(pos, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                upN1 = position.func_177981_b(j2).func_177977_b().func_177977_b();
                for (y = 0; y < 2; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || (y != 0 ? Math.abs(x) != Math.abs(z) : Math.abs(x) == Math.abs(z))) continue;
                            BlockPos upN2 = upN1.func_177982_a(x, y, z);
                            state3 = worldIn.func_180495_p(upN2);
                            if (state3.func_185904_a() == Material.field_151579_a) {
                                map.put(upN2, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.func_177982_a(x, 0, z);
                        BlockSwampRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        BlockPos pos2 = upN1;
                        state3 = worldIn.func_180495_p(pos2);
                        if (state3.func_185904_a() != Material.field_151579_a) {
                            return false;
                        }
                        map.put(pos2, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.func_177977_b();
                        state3 = worldIn.func_180495_p(upN1);
                        if (state3.func_185904_a() != Material.field_151579_a) {
                            return false;
                        }
                        map.put(upN1, leaves);
                        upN1 = upN1.func_177984_a().func_177984_a();
                        if (x == -1) {
                            upN1 = upN1.func_177982_a(-1, 0, 0);
                        } else if (z == -1) {
                            upN1 = upN1.func_177982_a(0, 0, -1);
                        } else if (x == 1) {
                            upN1 = upN1.func_177982_a(1, 0, 0);
                        } else {
                            if (z != 1) continue;
                            upN1 = upN1.func_177982_a(0, 0, 1);
                        }
                        rubberWoodState = BlockSwampRubWood.RubberWoodState.plain_y;
                        pos2 = upN1;
                        state3 = worldIn.func_180495_p(pos2);
                        if (state3.func_185904_a() != Material.field_151579_a) {
                            return false;
                        }
                        map.put(pos2, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    }
                }
            }
        }
        return true;
    }
}

