/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein;

import com.denfop.IUItem;
import com.denfop.api.pollution.Vec2f;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;

public class AlgorithmVein {
    static Random random = new Random();
    private static Map<ChunkPos, Chunk> chunkPosChunkMap = new HashMap<ChunkPos, Chunk>();
    private static HashSet<Vec2f> poses = new HashSet();

    public static void generate(World world, VeinType veinType, BlockPos pos, Chunk chunk, int meta1, IChunkProvider chunkProvider, IChunkGenerator chunkGenerator) {
        int chance_type;
        if (random.nextInt(3) > 0) {
            return;
        }
        Biome biome = chunk.func_177411_a(pos, world.field_73011_w.func_177499_m());
        int value = random.nextInt(101 + (biome instanceof BiomeHills ? 20 : 0));
        if (value <= 55) {
            veinType.setVein(TypeVein.SMALL);
        } else if (value < 86) {
            veinType.setVein(TypeVein.MEDIUM);
        } else if (value < 100) {
            veinType.setVein(TypeVein.BIG);
        }
        boolean isRadiation = veinType.isRadiation();
        boolean withRadiation = false;
        if (isRadiation) {
            boolean bl = withRadiation = WorldBaseGen.random.nextInt(4) == 0;
        }
        if ((chance_type = random.nextInt(101)) <= 15 && biome instanceof BiomeHills) {
            int height = chunk.func_177433_f(pos);
            int radius = 10;
            if (veinType.getVein() == TypeVein.SMALL) {
                radius = world.field_73012_v.nextInt(4) + 2;
            } else if (veinType.getVein() == TypeVein.MEDIUM) {
                radius = world.field_73012_v.nextInt(6) + 3;
            } else if (veinType.getVein() == TypeVein.BIG) {
                radius = world.field_73012_v.nextInt(7) + 5;
            }
            pos = new BlockPos((double)pos.func_177958_n(), (double)height - (double)radius * 0.9 - (double)random.nextInt(15), (double)pos.func_177952_p());
            ChunkPos chunkPos = null;
            Chunk chunk1 = null;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Vec2f vec2f;
                        ChunkPos pos2;
                        double distance = Math.sqrt(x * x + y * y + z * z);
                        if (distance <= (double)radius && distance > (double)radius * 0.45) {
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            BlockPos pos1 = pos.func_177982_a(x, y, z);
                            if (!ore.needGenerate(world) || random.nextInt(100) <= 50) continue;
                            pos2 = new ChunkPos(pos1);
                            chunk1 = chunkPosChunkMap.get(pos2);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = chunkProvider.func_186025_d(pos2.field_77276_a, pos2.field_77275_b);
                                chunkPos = chunk1.func_76632_l();
                                chunkPosChunkMap.put(chunkPos, chunk1);
                            } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                                chunk1 = chunkPosChunkMap.get(pos2);
                            }
                            if (!AlgorithmVein.canGenerateSphere(world, pos1, chunk1)) continue;
                            vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                            poses.add(vec2f);
                            AlgorithmVein.setBlockState1(world, pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                            continue;
                        }
                        if (distance <= (double)radius && distance >= (double)radius * 0.35) {
                            BlockPos pos1 = pos.func_177982_a(x, y, z);
                            if (veinType.getHeavyOre() != null) {
                                if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerateSphere(world, pos1, chunk1)) continue;
                                Vec2f vec2f2 = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                                poses.add(vec2f2);
                                AlgorithmVein.setBlockState1(world, pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                                continue;
                            }
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            if (!ore.needGenerate(world) || random.nextInt(100) <= 50) continue;
                            pos2 = new ChunkPos(pos1);
                            chunk1 = chunkPosChunkMap.get(pos2);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = world.func_175726_f(pos1);
                                chunkPos = chunk1.func_76632_l();
                                chunkPosChunkMap.put(chunkPos, chunk1);
                            } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                                chunk1 = chunkPosChunkMap.get(pos2);
                            }
                            if (!AlgorithmVein.canGenerateSphere(world, pos1, chunk1)) continue;
                            vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                            poses.add(vec2f);
                            AlgorithmVein.setBlockState1(world, pos1, ore.getBlock(), 2);
                            continue;
                        }
                        if (!(distance <= (double)radius) || !(distance < (double)radius * 0.35)) continue;
                        BlockPos pos1 = pos.func_177982_a(x, y, z);
                        AlgorithmVein.setBlockState1(world, pos1, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
            int ii = 0;
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            ArrayList<Vec2f> vec2fs = new ArrayList<Vec2f>(poses);
            while (ii < k && !vec2fs.isEmpty()) {
                int y;
                Vec2f pos1 = (Vec2f)vec2fs.remove(random.nextInt(vec2fs.size()));
                ChunkPos chunkpos = new ChunkPos(pos1.x >> 4, pos1.y >> 4);
                if (chunk1 == null || chunkPos == null) {
                    chunk1 = chunkProvider.func_186025_d(chunkpos.field_77276_a, chunkpos.field_77275_b);
                    chunkPos = chunk1.func_76632_l();
                    chunkPosChunkMap.put(chunkPos, chunk1);
                } else if (pos1.x >> 4 != chunkPos.field_77276_a && pos1.y >> 4 != chunk.field_76647_h) {
                    chunk1 = chunkPosChunkMap.get(chunkpos);
                }
                int height1 = y = chunk1.func_177433_f(new BlockPos(pos1.x, 70, pos1.y));
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.x, y - 1, pos1.y);
                    IBlockState oldState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y + 1, pos1.y);
                    IBlockState upState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y, pos1.y);
                    IBlockState oldState1 = world.func_180495_p(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                if (!need) continue;
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits.getStateMeta(meta1), 3);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits1.getStateMeta(meta1 - 16), 3);
                } else {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits2.getStateMeta(meta1 - 32), 3);
                }
                ++ii;
            }
        } else if (chance_type <= 80) {
            int height = chunk.func_177433_f(pos);
            pos = new BlockPos(pos.func_177958_n(), height / 2 + height / 4, pos.func_177952_p());
            int x1 = random.nextInt(veinType.getVein().getMax()) + 3;
            int y1 = random.nextInt(veinType.getVein().getMax()) + 3;
            int z1 = random.nextInt(veinType.getVein().getMax()) + 3;
            int minX = 10;
            int minY = 10;
            int minZ = 10;
            int maxX = -10;
            int maxY = -10;
            int maxZ = -10;
            ChunkPos chunkPos = null;
            Chunk chunk1 = null;
            for (int x = -x1; x < x1 + 1; ++x) {
                for (int y = -y1; y < y1; ++y) {
                    for (int z = -z1; z < z1 + 1; ++z) {
                        Vec2f vec2f;
                        BlockPos pos1;
                        ChunkPos pos2;
                        int meta = random.nextInt(veinType.getOres().size());
                        ChanceOre ore = veinType.getOres().get(meta);
                        int need = Math.max(Math.max(x, y), z);
                        if (need < veinType.getVein().getMinNeed()) {
                            need = 0;
                        }
                        if ((chunk1 = chunkPosChunkMap.get(pos2 = new ChunkPos(pos1 = pos.func_177982_a(x, y, z)))) == null || chunkPos == null) {
                            chunk1 = world.func_175726_f(pos1);
                            chunkPos = chunk1.func_76632_l();
                            chunkPosChunkMap.put(chunkPos, chunk1);
                        } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                            chunk1 = chunkPosChunkMap.get(pos2);
                        }
                        if (random.nextInt(50) > 10 && ore.needGenerate(world) && (need == 0 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) > 50) && AlgorithmVein.canGenerate(world, pos1, chunk1)) {
                            if (x < minX) {
                                minX = x;
                            }
                            if (x > maxX) {
                                maxX = x;
                            }
                            if (y < minY) {
                                minY = y;
                            }
                            if (y > maxY) {
                                maxY = y;
                            }
                            if (z < minZ) {
                                minZ = z;
                            }
                            if (z > maxZ) {
                                maxZ = z;
                            }
                            vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                            poses.add(vec2f);
                            AlgorithmVein.setBlockState1(world, pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                            continue;
                        }
                        if (veinType.getHeavyOre() == null || random.nextInt(50) <= 40 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) <= 50 || !AlgorithmVein.canGenerate(world, pos1, chunk1)) continue;
                        vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                        poses.add(vec2f);
                        AlgorithmVein.setBlockState1(world, pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                        if (x < minX) {
                            minX = x;
                        }
                        if (x > maxX) {
                            maxX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        if (z < minZ) {
                            minZ = z;
                        }
                        if (z <= maxZ) continue;
                        maxZ = z;
                    }
                }
            }
            int[] numbers = new int[]{maxY, minY, maxX, minX, maxZ, minZ};
            int[] number2 = new int[]{1, 0, 3, 2, 5, 4};
            int[] yxz = new int[]{0, 0, 0};
            int[][] yxz1 = new int[][]{{1, 2}, {0, 2}, {0, 1}};
            int[][] numbers1 = new int[][]{{3, 2, 5, 4}, {1, 0, 5, 4}, {1, 0, 3, 2}};
            chunk1 = null;
            chunkPos = null;
            int level = 1;
            int i = random.nextInt(6);
            while (level < veinType.getVein().getLevel() + 1) {
                Vec2f vec2f;
                ChunkPos pos2;
                BlockPos pos1;
                ChanceOre ore;
                int meta;
                if (i % 2 == 0) {
                    yxz[i / 2] = numbers[i];
                    while (yxz[i / 2] < random.nextInt(veinType.getVein().getMax_length()) + 3 + numbers[i] + 1) {
                        yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level * 2;
                        while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level * 2 + 1) {
                            yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level * 2;
                            while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level * 2 + 1) {
                                meta = random.nextInt(veinType.getOres().size());
                                ore = veinType.getOres().get(meta);
                                if (ore.needGenerate(world) && random.nextInt(100) > 50) {
                                    pos1 = pos.func_177982_a(yxz[1], yxz[0], yxz[2]);
                                    pos2 = new ChunkPos(pos1);
                                    chunk1 = chunkPosChunkMap.get(pos2);
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = chunkProvider.func_186025_d(pos2.field_77276_a, pos2.field_77275_b);
                                        chunkPos = chunk1.func_76632_l();
                                        chunkPosChunkMap.put(chunkPos, chunk1);
                                    } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                                        chunk1 = chunkPosChunkMap.get(pos2);
                                    }
                                    if (AlgorithmVein.canGenerate(world, pos1, chunk1)) {
                                        vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                                        poses.add(vec2f);
                                        AlgorithmVein.setBlockState1(world, pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                                    }
                                }
                                int n = yxz1[i / 2][1];
                                yxz[n] = yxz[n] + 1;
                            }
                            int n = yxz1[i / 2][0];
                            yxz[n] = yxz[n] + 1;
                        }
                        int n = i / 2;
                        yxz[n] = yxz[n] + 1;
                    }
                } else {
                    yxz[i / 2] = numbers[i];
                    while (yxz[i / 2] > numbers[i] - random.nextInt(veinType.getVein().getMax_length()) - 4) {
                        yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level * 2;
                        while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level * 2 + 1) {
                            yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level * 2;
                            while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level * 2 + 1) {
                                meta = random.nextInt(veinType.getOres().size());
                                ore = veinType.getOres().get(meta);
                                if (ore.needGenerate(world) && random.nextInt(100) > 50) {
                                    pos1 = pos.func_177982_a(yxz[1], yxz[0], yxz[2]);
                                    pos2 = new ChunkPos(pos1);
                                    chunk1 = chunkPosChunkMap.get(pos2);
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = chunkProvider.func_186025_d(pos2.field_77276_a, pos2.field_77275_b);
                                        chunkPos = chunk1.func_76632_l();
                                        chunkPosChunkMap.put(chunkPos, chunk1);
                                    } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                                        chunk1 = chunkPosChunkMap.get(pos2);
                                    }
                                    if (AlgorithmVein.canGenerate(world, pos1, chunk1)) {
                                        vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                                        poses.add(vec2f);
                                        AlgorithmVein.setBlockState1(world, pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                                    }
                                }
                                int n = yxz1[i / 2][1];
                                yxz[n] = yxz[n] + 1;
                            }
                            int n = yxz1[i / 2][0];
                            yxz[n] = yxz[n] + 1;
                        }
                        int n = i / 2;
                        yxz[n] = yxz[n] - 1;
                    }
                }
                int n = number2[i];
                numbers[n] = numbers[n] + (yxz[i / 2] - numbers[i]);
                numbers[i] = yxz[i / 2];
                ++level;
                int prev = i;
                random.nextInt();
                i = random.nextInt(6);
                while (i != prev) {
                    i = random.nextInt(6);
                }
            }
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            chunk1 = null;
            int ii = 0;
            ArrayList<Vec2f> vec2fs = new ArrayList<Vec2f>(poses);
            while (ii < k && !vec2fs.isEmpty()) {
                int y;
                Vec2f pos1 = (Vec2f)vec2fs.remove(random.nextInt(vec2fs.size()));
                ChunkPos chunkpos = new ChunkPos(pos1.x >> 4, pos1.y >> 4);
                if (chunk1 == null || chunkPos == null) {
                    chunk1 = chunkProvider.func_186025_d(chunkpos.field_77276_a, chunkpos.field_77275_b);
                    chunkPos = chunk1.func_76632_l();
                    chunkPosChunkMap.put(chunkPos, chunk1);
                } else if (pos1.x >> 4 != chunkPos.field_77276_a && pos1.y >> 4 != chunk.field_76647_h) {
                    chunk1 = chunkPosChunkMap.get(chunkpos);
                }
                int height1 = y = chunk1.func_177433_f(new BlockPos(pos1.x, 70, pos1.y));
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.x, y - 1, pos1.y);
                    IBlockState oldState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y + 1, pos1.y);
                    IBlockState upState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y, pos1.y);
                    IBlockState oldState1 = chunk1.func_177435_g(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                if (!need) continue;
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits.getStateMeta(meta1), 3);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits1.getStateMeta(meta1 - 16), 3);
                } else {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits2.getStateMeta(meta1 - 32), 3);
                }
                ++ii;
            }
        } else {
            Vec2f pos1;
            int height = chunk.func_177433_f(pos);
            pos = new BlockPos(pos.func_177958_n(), height / 2 + height / 4, pos.func_177952_p());
            int centerX = pos.func_177958_n();
            int centerY = pos.func_177956_o();
            int centerZ = pos.func_177952_p();
            int R = 0;
            int r = 0;
            int y1 = 0;
            if (veinType.getVein() == TypeVein.SMALL) {
                R = world.field_73012_v.nextInt(4) + 3;
                r = world.field_73012_v.nextInt(3) + 2;
                y1 = world.field_73012_v.nextInt(3) + 1;
            } else if (veinType.getVein() == TypeVein.MEDIUM) {
                R = world.field_73012_v.nextInt(6) + 3;
                r = world.field_73012_v.nextInt(4) + 3;
                y1 = world.field_73012_v.nextInt(3) + 2;
            } else if (veinType.getVein() == TypeVein.BIG) {
                R = world.field_73012_v.nextInt(7) + 5;
                r = world.field_73012_v.nextInt(4) + 4;
                y1 = world.field_73012_v.nextInt(5) + 3;
            }
            ChunkPos chunkPos = null;
            Chunk chunk1 = null;
            for (int y2 = centerY - y1; y2 < centerY + y1; ++y2) {
                for (int x = -(R + r); x <= R + r; ++x) {
                    for (int z = -(R + r); z <= R + r; ++z) {
                        if (x * x + z * z <= (R + r) * (R + r) && x * x + z * z > r * r) {
                            pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            if (!ore.needGenerate(world) || random.nextInt(100) <= 50) continue;
                            ChunkPos pos2 = new ChunkPos((BlockPos)pos1);
                            chunk1 = chunkPosChunkMap.get(pos2);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = world.func_175726_f((BlockPos)pos1);
                                chunkPos = chunk1.func_76632_l();
                                chunkPosChunkMap.put(chunkPos, chunk1);
                            } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                                chunk1 = chunkPosChunkMap.get(pos2);
                            }
                            if (!AlgorithmVein.canGenerate(world, (BlockPos)pos1, chunk1)) continue;
                            Vec2f vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                            poses.add(vec2f);
                            AlgorithmVein.setBlockState1(world, (BlockPos)pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                            continue;
                        }
                        if (x * x + z * z > (R + r) * (R + r) || x * x + z * z < r * r) continue;
                        pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                        ChunkPos pos2 = new ChunkPos((BlockPos)pos1);
                        chunk1 = chunkPosChunkMap.get(pos2);
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = chunkProvider.func_186025_d(pos2.field_77276_a, pos2.field_77275_b);
                            chunkPos = chunk1.func_76632_l();
                            chunkPosChunkMap.put(chunkPos, chunk1);
                        } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                            chunk1 = chunkPosChunkMap.get(pos2);
                        }
                        if (veinType.getHeavyOre() != null) {
                            if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerate(world, (BlockPos)pos1, chunk1)) continue;
                            Vec2f vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                            poses.add(vec2f);
                            AlgorithmVein.setBlockState1(world, (BlockPos)pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2);
                            continue;
                        }
                        int meta = random.nextInt(veinType.getOres().size());
                        ChanceOre ore = veinType.getOres().get(meta);
                        if (!ore.needGenerate(world) || random.nextInt(100) <= 50) continue;
                        ChunkPos pos3 = new ChunkPos((BlockPos)pos1);
                        chunk1 = chunkPosChunkMap.get(pos3);
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = chunkProvider.func_186025_d(pos3.field_77276_a, pos3.field_77275_b);
                            chunkPos = chunk1.func_76632_l();
                            chunkPosChunkMap.put(chunkPos, chunk1);
                        } else if (pos1.func_177958_n() >> 4 != chunkPos.field_77276_a && pos1.func_177952_p() >> 4 != chunk.field_76647_h) {
                            chunk1 = chunkPosChunkMap.get(pos3);
                        }
                        if (!AlgorithmVein.canGenerate(world, (BlockPos)pos1, chunk1)) continue;
                        Vec2f vec2f = new Vec2f(pos1.func_177958_n(), pos1.func_177952_p());
                        poses.add(vec2f);
                        AlgorithmVein.setBlockState1(world, (BlockPos)pos1, withRadiation ? ore.getBlock() : ore.getWithoutRadiation(), 2);
                    }
                }
            }
            chunk1 = null;
            int ii = 0;
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            ArrayList<Vec2f> vec2fs = new ArrayList<Vec2f>(poses);
            while (ii < k && !vec2fs.isEmpty()) {
                int y;
                pos1 = (Vec2f)vec2fs.remove(random.nextInt(vec2fs.size()));
                ChunkPos chunkpos = new ChunkPos(pos1.x >> 4, pos1.y >> 4);
                if (chunk1 == null || chunkPos == null) {
                    chunk1 = chunkProvider.func_186025_d(chunkpos.field_77276_a, chunkpos.field_77275_b);
                    chunkPos = chunk1.func_76632_l();
                    chunkPosChunkMap.put(chunkPos, chunk1);
                } else if (pos1.x >> 4 != chunkPos.field_77276_a && pos1.y >> 4 != chunk.field_76647_h) {
                    chunk1 = chunkPosChunkMap.get(chunkpos);
                }
                int height1 = y = chunk1.func_177433_f(new BlockPos(pos1.x, 70, pos1.y));
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.x, y - 1, pos1.y);
                    IBlockState oldState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y + 1, pos1.y);
                    IBlockState upState = chunk1.func_177435_g(pos2);
                    pos2 = new BlockPos(pos1.x, y, pos1.y);
                    IBlockState oldState1 = chunk1.func_177435_g(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                if (!need) continue;
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits.getStateMeta(meta1), 3);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits1.getStateMeta(meta1 - 16), 3);
                } else {
                    AlgorithmVein.setBlockState1(world, pos2, IUItem.blockdeposits2.getStateMeta(meta1 - 32), 3);
                }
                ++ii;
            }
        }
        chunkPosChunkMap.clear();
        poses.clear();
    }

    private static boolean canSpawn(IBlockState underState, IBlockState state, IBlockState upState) {
        boolean can;
        Block block = underState.func_177230_c();
        boolean bl = can = block == Blocks.field_150349_c || block == Blocks.field_150351_n || block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150347_e || block == Blocks.field_150348_b;
        if (can) {
            if (state.func_185904_a() == Material.field_151579_a || state.func_177230_c() == Blocks.field_150329_H || state.func_177230_c() == Blocks.field_150398_cm || state.func_177230_c() == Blocks.field_150328_O) {
                return true;
            }
            return state.func_185904_a().func_76224_d() && upState.func_185904_a().func_76224_d();
        }
        return false;
    }

    public static IBlockState setBlockState(World world, Chunk chunk, BlockPos pos, IBlockState state) {
        TileEntity te;
        int k;
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        if (j >= chunk.field_76638_b[l = (k = pos.func_177952_p() & 0xF) << 4 | i] - 1) {
            chunk.field_76638_b[l] = -999;
        }
        int i1 = chunk.field_76634_f[l];
        IBlockState iblockstate = chunk.func_177435_g(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        int k1 = iblockstate.getLightOpacity((IBlockAccess)world, pos);
        ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            chunk.field_76652_q[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, world.field_73011_w.func_191066_m());
            flag = j >= i1;
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!world.field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(world, pos, iblockstate);
            }
            if ((te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
                world.func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
            world.func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (!(world.field_72995_K || block1 == block || world.captureBlockSnapshots && !block.hasTileEntity(state))) {
            block.func_176213_c(world, pos, state);
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(world, state);
                world.func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        chunk.func_76630_e();
        return iblockstate;
    }

    private static boolean canGenerate(World world, BlockPos pos, Chunk chunk) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151579_a || pos.func_177956_o() >= chunk.func_177433_f(pos) - 4) {
            return false;
        }
        if (pos.func_177956_o() >= 60) {
            return false;
        }
        if (state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_151571_B || state.func_185904_a() == Material.field_151575_d || state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_185904_a() == Material.field_151579_a || state.func_177230_c().field_149782_v != -1.0f;
    }

    public static boolean setBlockState1(World world, BlockPos pos, IBlockState newState, int flags) {
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Chunk chunk = chunkPosChunkMap.get(chunkPos);
        if (chunk == null) {
            chunk = world.func_175726_f(pos);
            chunkPosChunkMap.put(chunkPos, chunk);
        }
        pos = pos.func_185334_h();
        Object blockSnapshot = null;
        IBlockState iblockstate = AlgorithmVein.setBlockState(world, chunk, pos, newState);
        return true;
    }

    private static boolean canGenerateSphere(World world, BlockPos pos, Chunk chunk) {
        IBlockState state = world.func_180495_p(pos);
        if (pos.func_177956_o() >= 60) {
            if (state.func_185904_a() == Material.field_151579_a || pos.func_177956_o() >= chunk.func_177433_f(pos) - 4) {
                return false;
            }
            return state.func_185904_a() != Material.field_151595_p && state.func_185904_a() != Material.field_151571_B && state.func_185904_a() != Material.field_151575_d && !state.func_185904_a().func_76224_d();
        }
        if (state.func_185904_a() == Material.field_151579_a || pos.func_177956_o() >= chunk.func_177433_f(pos) - 4) {
            return false;
        }
        if (state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_151571_B || state.func_185904_a() == Material.field_151575_d || state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_177230_c().field_149782_v != -1.0f;
    }
}

