/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api;

import java.lang.reflect.Field;
import matteroverdrive.api.MatterOverdriveAPI;
import matteroverdrive.api.exceptions.CoreInaccessibleException;

final class MOApi {
    private static final String CORE_API_CLASS = "matteroverdrive.core.MOAPIInternal";
    private static final String CORE_API_FIELD = "INSTANCE";
    private static MatterOverdriveAPI API_INSTANCE;

    MOApi() {
    }

    static MatterOverdriveAPI instance() {
        if (API_INSTANCE == null) {
            try {
                Class<?> apiClass = Class.forName(CORE_API_CLASS);
                Field apiField = apiClass.getField(CORE_API_FIELD);
                API_INSTANCE = (MatterOverdriveAPI)apiField.get(apiClass);
            }
            catch (ClassNotFoundException e) {
                throw new CoreInaccessibleException("MatterOverdrive API tried  to access the %s class, without it being declared", CORE_API_CLASS);
            }
            catch (IllegalAccessException e) {
                throw new CoreInaccessibleException("MatterOverdrive API tried to access the %s field in %s without it being declared.", CORE_API_FIELD, CORE_API_CLASS);
            }
            catch (NoSuchFieldException e) {
                throw new CoreInaccessibleException("MatterOverdrive API tried to access the %s field in %s without enough access permissions.", CORE_API_FIELD, CORE_API_CLASS);
            }
        }
        return API_INSTANCE;
    }
}

