/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.quest;

import java.util.List;
import java.util.UUID;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.IQuestReward;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class QuestStack {
    boolean completed;
    private NBTTagCompound tagCompound;
    private UUID giverUniqueID;
    private Entity giver;
    private IQuest quest;

    QuestStack() {
    }

    public QuestStack(IQuest quest, Entity giver) {
        this.quest = quest;
        if (giver != null) {
            this.giverUniqueID = giver.func_110124_au();
        }
        this.giver = giver;
    }

    public QuestStack(IQuest quest) {
        this.quest = quest;
    }

    public static QuestStack loadFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null) {
            QuestStack questStack = new QuestStack();
            questStack.readFromNBT(tagCompound);
            return questStack;
        }
        return null;
    }

    public static boolean canComplete(EntityPlayer entityPlayer, QuestStack questStack) {
        for (int i = 0; i < questStack.getObjectivesCount(entityPlayer); ++i) {
            if (questStack.isObjectiveCompleted(entityPlayer, i)) continue;
            return false;
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (this.tagCompound != null) {
            tagCompound.func_74782_a("Data", (NBTBase)this.tagCompound);
        }
        if (this.giverUniqueID != null) {
            tagCompound.func_74772_a("giveIdLow", this.giverUniqueID.getLeastSignificantBits());
            tagCompound.func_74772_a("giveIdHigh", this.giverUniqueID.getMostSignificantBits());
        }
        tagCompound.func_74777_a("Quest", (short)MatterOverdrive.QUESTS.getQuestID(this.quest));
        tagCompound.func_74757_a("Completed", this.completed);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("Data", 10)) {
            this.tagCompound = tagCompound.func_74775_l("Data");
        }
        if (tagCompound.func_150297_b("giveIdLow", 4) && tagCompound.func_150297_b("giveIdHigh", 4)) {
            this.giverUniqueID = new UUID(tagCompound.func_74763_f("giveIdLow"), tagCompound.func_74763_f("giveIdHigh"));
        }
        if (tagCompound.func_150297_b("Quest", 2)) {
            this.quest = MatterOverdrive.QUESTS.getQuestWithID(tagCompound.func_74765_d("Quest"));
        }
        this.completed = tagCompound.func_74767_n("Completed");
    }

    public String getTitle() {
        return this.quest.getTitle(this);
    }

    public int getXP(EntityPlayer entityPlayer) {
        return this.quest.getXpReward(this, entityPlayer);
    }

    public String getTitle(EntityPlayer entityPlayer) {
        return this.quest.getTitle(this, entityPlayer);
    }

    public String getInfo(EntityPlayer entityPlayer) {
        return this.quest.getInfo(this, entityPlayer);
    }

    public String getObjective(EntityPlayer entityPlayer, int objectiveIndex) {
        return this.quest.getObjective(this, entityPlayer, objectiveIndex);
    }

    public int getObjectivesCount(EntityPlayer entityPlayer) {
        return this.quest.getObjectivesCount(this, entityPlayer);
    }

    public boolean isObjectiveCompleted(EntityPlayer entityPlayer, int objectiveID) {
        return this.quest.isObjectiveCompleted(this, entityPlayer, objectiveID);
    }

    public Entity getGiver() {
        return this.giver;
    }

    public void setGiver(Entity entity) {
        this.giver = entity;
        this.giverUniqueID = this.giver.func_110124_au();
    }

    public boolean isGiver(Entity entity) {
        if (this.giver != null && this.giver == entity) {
            return true;
        }
        return this.giverUniqueID != null && entity.func_110124_au().equals(this.giverUniqueID);
    }

    public boolean hasGiver() {
        if (this.getGiver() != null) {
            return true;
        }
        return this.giverUniqueID != null;
    }

    public void addRewards(List<IQuestReward> rewards, EntityPlayer entityPlayer) {
        this.quest.addToRewards(this, entityPlayer, rewards);
    }

    public IQuest getQuest() {
        return this.quest;
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    public void setTagCompound(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void markComplited(EntityPlayer entityPlayer, boolean force) {
        if (force) {
            this.completed = true;
        } else {
            this.quest.setCompleted(this, entityPlayer);
        }
    }

    public QuestStack copy() {
        QuestStack questStack = new QuestStack(this.quest);
        questStack.giverUniqueID = this.giverUniqueID;
        questStack.giver = this.giver;
        if (this.getTagCompound() != null) {
            questStack.setTagCompound(this.getTagCompound().func_74737_b());
        }
        return questStack;
    }

    public ItemStack getContract() {
        ItemStack contract = new ItemStack((Item)MatterOverdrive.ITEMS.contract);
        NBTTagCompound questTag = new NBTTagCompound();
        this.writeToNBT(questTag);
        contract.func_77982_d(questTag);
        return contract;
    }

    public boolean canAccept(EntityPlayer entityPlayer, QuestStack questStack) {
        return this.quest.canBeAccepted(questStack, entityPlayer);
    }
}

