/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.transport;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TransportLocation {
    public BlockPos pos;
    public String name;

    public TransportLocation(BlockPos pos, String name) {
        this.pos = pos;
        this.name = name;
    }

    public TransportLocation(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public TransportLocation(NBTTagCompound nbt) {
        if (nbt != null) {
            this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("tl"));
            this.name = nbt.func_74779_i("tl_name");
        }
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74772_a("tl", this.pos.func_177986_g());
        nbtTagCompound.func_74778_a("tl_name", this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPosition(BlockPos pos) {
        this.pos = pos;
    }

    public int getDistance(BlockPos pos) {
        return (int)Math.sqrt(pos.func_177951_i((Vec3i)this.pos));
    }
}

