/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.api.IScannable;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGravitationalAnomaly
extends MOBlockContainer<TileEntityGravitationalAnomaly>
implements IScannable,
IConfigSubscriber {
    public BlockGravitationalAnomaly(Material material, String name) {
        super(material, name);
        this.setBoundingBox(new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.6f, (double)0.6f, (double)0.6f));
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149649_H();
    }

    @Deprecated
    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return super.func_180636_a(state, world, pos, start, end);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityGravitationalAnomaly tileEntity = (TileEntityGravitationalAnomaly)this.getTileEntity(source, pos);
        if (tileEntity != null) {
            double range = tileEntity.getEventHorizon();
            range = Math.max(range, 0.4);
            float rangeMin = (float)(0.5 - range / 2.0);
            float rangeMax = (float)(0.5 + range / 2.0);
            return new AxisAlignedBB((double)rangeMin, (double)rangeMin, (double)rangeMin, (double)rangeMax, (double)rangeMax, (double)rangeMax);
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public Class<TileEntityGravitationalAnomaly> getTileEntityClass() {
        return TileEntityGravitationalAnomaly.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityGravitationalAnomaly();
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null && tileEntity instanceof TileEntityGravitationalAnomaly) {
            ((TileEntityGravitationalAnomaly)tileEntity).addInfo(world, x, y, z, infos);
        }
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        TileEntityGravitationalAnomaly.BLOCK_ENTETIES = config.getBool("gravitational anomaly block entities", "server." + this.func_149739_a().substring(5), true, "Should the blocks drop entities or be directly consumed when destroyed by the gravitational anomaly");
        TileEntityGravitationalAnomaly.FALLING_BLOCKS = config.getBool("gravitational anomaly falling blocks", "server." + this.func_149739_a().substring(5), true, "Should blocks be turned into falling blocks when broken");
        TileEntityGravitationalAnomaly.VANILLA_FLUIDS = config.getBool("gravitational anomaly vanilla fluids", "server." + this.func_149739_a().substring(5), true, "Should vanilla fluid block such as water and lava be consumed by the anomaly");
        TileEntityGravitationalAnomaly.FORGE_FLUIDS = config.getBool("gravitational anomaly forge fluids", "server." + this.func_149739_a().substring(5), true, "Should other mod fluid blocks be consumed by the anomaly");
        TileEntityGravitationalAnomaly.BLOCK_DESTRUCTION = config.getBool("block destruction", "server." + this.func_149739_a().substring(5), true, "Should the gravitational anomaly destroy blocks");
        TileEntityGravitationalAnomaly.GRAVITATION = config.getBool("gravitational pull", "server." + this.func_149739_a().substring(5), true, "Should the gravitational entity pull entities towards it");
    }
}

