/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientUtil {
    private static final float fluidOffset = 0.005f;

    public static void registerModel(Item item, String location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(location), "inventory"));
    }

    public static void registerModel(Block block, String location) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(location), "inventory"));
    }

    public static void registerToNormal(Block block) {
        final String resourcePath = block.getRegistryName().toString();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(resourcePath, "normal");
            }
        });
        NonNullList subBlocks = NonNullList.func_191196_a();
        block.func_149666_a(null, subBlocks);
        for (ItemStack stack : subBlocks) {
            IBlockState state = block.func_176203_a(stack.func_77960_j());
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, "inventory"));
        }
    }

    public static void registerWithMapper(Block block) {
        if (block != null) {
            final String resourcePath = block.getRegistryName().toString();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation(resourcePath, this.func_178131_a((Map)state.func_177228_b()));
                }
            });
            NonNullList subBlocks = NonNullList.func_191196_a();
            block.func_149666_a(null, subBlocks);
            for (ItemStack stack : subBlocks) {
                IBlockState state = block.func_176203_a(stack.func_77960_j());
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, ClientUtil.getPropertyString(state.func_177228_b(), new String[0])));
            }
        }
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(ClientUtil.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }

    public static void setCustomModelLocation(Item item) {
        ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
    }

    public static void setCustomModelLocation(Block block) {
        ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)location);
    }

    public static void renderTexturedQuad(TextureAtlasSprite texture, EnumFacing face, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, face, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderTexturedCuboid(TextureAtlasSprite[] textures, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientUtil.putTexturedQuad(renderer, textures[0], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, textures[1], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, textures[2], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, textures[3], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, textures[4], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, textures[5], x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderTexturedCuboid(TextureAtlasSprite texture, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int brightness, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, texture, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BufferBuilder buffer) {
        ClientUtil.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, buffer);
        ClientUtil.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, buffer);
        ClientUtil.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, buffer);
        ClientUtil.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, buffer);
        ClientUtil.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, buffer);
        ClientUtil.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, buffer);
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        ClientUtil.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        ClientUtil.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        ClientUtil.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, r, g, b, a * 0.8f, buffer);
        ClientUtil.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, r, g, b, a * 1.1f, buffer);
        ClientUtil.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
        ClientUtil.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, BufferBuilder buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double w, double h, double d) {
        double wd = (1.0 - w) / 2.0;
        double hd = (1.0 - h) / 2.0;
        double dd = (1.0 - d) / 2.0;
        ClientUtil.renderFluidCuboid(fluid, pos, x, y, z, wd, hd, dd, 1.0 - wd, 1.0 - hd, 1.0 - dd);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        ClientUtil.renderFluidCuboid(fluid, pos, x, y, z, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        ClientUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
        ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
        ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
        ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
        ClientUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax) {
        if (ymin < ymax) {
            int y;
            BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int color = fluid.getFluid().getColor(fluid);
            int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
            GlStateManager.func_179109_b((float)from.func_177958_n(), (float)from.func_177956_o(), (float)from.func_177952_p());
            TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
            TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
            if (still == null) {
                still = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            if (flowing == null) {
                flowing = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            int xd = to.func_177958_n() - from.func_177958_n();
            int yd = (int)(ymax - ymin);
            int zd = to.func_177952_p() - from.func_177952_p();
            double xmin = 0.005f;
            double xmax = (double)xd + 1.0 - (double)0.005f;
            double zmin = 0.005f;
            double zmax = (double)zd + 1.0 - (double)0.005f;
            double[] xs = new double[2 + xd];
            double[] ys = new double[2 + yd];
            double[] zs = new double[2 + zd];
            xs[0] = xmin;
            for (y = 1; y <= xd; ++y) {
                xs[y] = y;
            }
            xs[xd + 1] = xmax;
            ys[0] = ymin;
            for (y = 1; y <= yd; ++y) {
                ys[y] = y;
            }
            ys[yd + 1] = ymax;
            zs[0] = zmin;
            for (y = 1; y <= zd; ++y) {
                zs[y] = y;
            }
            zs[zd + 1] = zmax;
            for (y = 0; y <= yd; ++y) {
                for (int z = 0; z <= zd; ++z) {
                    for (int x = 0; x <= xd; ++x) {
                        double x1 = xs[x];
                        double x2 = xs[x + 1] - x1;
                        double y1 = ys[y];
                        double y2 = ys[y + 1] - y1;
                        double z1 = zs[z];
                        double z2 = zs[z + 1] - z1;
                        if (x == 0) {
                            ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.WEST, color, brightness, true);
                        }
                        if (x == xd) {
                            ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.EAST, color, brightness, true);
                        }
                        if (y == 0) {
                            ClientUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.DOWN, color, brightness, false);
                        }
                        if (y == yd) {
                            ClientUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.UP, color, brightness, false);
                        }
                        if (z == 0) {
                            ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.NORTH, color, brightness, true);
                        }
                        if (z != zd) continue;
                        ClientUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.SOUTH, color, brightness, true);
                    }
                }
            }
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        ClientUtil.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        if (sprite != null) {
            double maxV;
            double minV;
            double maxU;
            double minU;
            double zt2;
            double yt2;
            double xt2;
            double size = 16.0;
            if (flowing) {
                size = 8.0;
            }
            double x2 = x + w;
            double y2 = y + h;
            double z2 = z + d;
            double xt1 = x % 1.0;
            for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
            }
            double yt1 = y % 1.0;
            for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
            }
            double zt1 = z % 1.0;
            for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
            }
            if (flowing) {
                double tmp = 1.0 - yt1;
                yt1 = 1.0 - yt2;
                yt2 = tmp;
            }
            switch (face) {
                case DOWN: 
                case UP: {
                    minU = sprite.func_94214_a(xt1 * size);
                    maxU = sprite.func_94214_a(xt2 * size);
                    minV = sprite.func_94207_b(zt1 * size);
                    maxV = sprite.func_94207_b(zt2 * size);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    minU = sprite.func_94214_a(xt2 * size);
                    maxU = sprite.func_94214_a(xt1 * size);
                    minV = sprite.func_94207_b(yt1 * size);
                    maxV = sprite.func_94207_b(yt2 * size);
                    break;
                }
                case WEST: 
                case EAST: {
                    minU = sprite.func_94214_a(zt2 * size);
                    maxU = sprite.func_94214_a(zt1 * size);
                    minV = sprite.func_94207_b(yt1 * size);
                    maxV = sprite.func_94207_b(yt2 * size);
                    break;
                }
                default: {
                    minU = sprite.func_94209_e();
                    maxU = sprite.func_94212_f();
                    minV = sprite.func_94206_g();
                    maxV = sprite.func_94210_h();
                }
            }
            switch (face) {
                case DOWN: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case UP: {
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case NORTH: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case SOUTH: {
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case WEST: {
                    renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    break;
                }
                case EAST: {
                    renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                    renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                }
            }
        }
    }
}

