/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.model.baked;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import matteroverdrive.client.TextureArray;
import matteroverdrive.client.model.ModelBase;
import matteroverdrive.client.model.ModelUtil;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BakedModelBase
implements IBakedModel {
    public Function<ResourceLocation, TextureAtlasSprite> getter;
    public VertexFormat format;
    public TextureArray textureArray;
    private Cache<Pair<IBlockState, EnumFacing>, List<BakedQuad>> quadCache = CacheBuilder.newBuilder().build();

    public BakedModelBase(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ModelBase model) {
        this.getter = bakedTextureGetter;
        this.format = format;
        this.textureArray = new TextureArray(this.getter.apply(model.textures.get("particle")), this.getter.apply(model.textures.get("north")), this.getter.apply(model.textures.get("south")), this.getter.apply(model.textures.get("up")), this.getter.apply(model.textures.get("down")), this.getter.apply(model.textures.get("east")), this.getter.apply(model.textures.get("west")));
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List<BakedQuad> quads = (List<BakedQuad>)this.quadCache.getIfPresent((Object)Pair.of((Object)state, (Object)side));
        if (quads != null) {
            return quads;
        }
        quads = this.buildQuads(state, side, rand);
        this.quadCache.put((Object)Pair.of((Object)state, (Object)side), quads);
        return quads;
    }

    public abstract List<BakedQuad> buildQuads(@Nullable IBlockState var1, @Nullable EnumFacing var2, long var3);

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textureArray.getParticleTexture();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        if (ModelUtil.BLOCK_TRANSFORMS.containsKey(type)) {
            return Pair.of((Object)this, (Object)ModelUtil.BLOCK_TRANSFORMS.get(type).getMatrix());
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

