/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderBeam;
import matteroverdrive.client.render.tileentity.TileEntityRendererStation;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.items.weapon.OmniTool;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.StackUtils;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWeaponsBeam
extends RenderBeam<EntityPlayer> {
    private static final ResourceLocation beamTexture = new ResourceLocation("matteroverdrive:textures/fx/plasmabeam.png");
    final Map<Entity, WeaponSound> soundMap = new HashMap<Entity, WeaponSound>();

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)1, (int)1, (int)0, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-Minecraft.func_71410_x().field_71439_g.field_70165_t), (double)(-Minecraft.func_71410_x().field_71439_g.field_70163_u), (double)(-Minecraft.func_71410_x().field_71439_g.field_70161_v));
        this.renderClient(renderHandler, event.getPartialTicks());
        this.renderOthers(renderHandler, event.getPartialTicks());
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    public void renderOthers(RenderHandler renderHandler, float ticks) {
        Minecraft.func_71410_x().field_71441_e.func_72910_y().stream().filter(o -> o instanceof EntityPlayer).filter(player -> !player.equals((Object)Minecraft.func_71410_x().field_71439_g)).forEach(o -> {
            EntityPlayer player = (EntityPlayer)o;
            if (this.shouldRenderBeam(player)) {
                this.renderRaycastedBeam(player.func_174824_e(ticks).func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_70676_i(0.0f), new Vec3d(-0.5, -0.3, 1.0), player);
            } else {
                this.stopWeaponSound(player);
            }
        });
    }

    public void renderClient(RenderHandler renderHandler, float ticks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.shouldRenderBeam((EntityPlayer)player)) {
            Vec3d pos = player.func_174824_e(ticks);
            Vec3d look = player.func_70676_i(0.0f);
            this.renderRaycastedBeam(pos, look, new Vec3d(-0.1, -0.1, 0.15), player);
        } else {
            this.stopWeaponSound((EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playWeaponSound(EntityPlayer player, Random random) {
        if (!this.soundMap.containsKey(player)) {
            ItemStack weaponStack = player.func_184607_cu();
            if (!StackUtils.isNullOrEmpty(weaponStack) && weaponStack.func_77973_b() instanceof IWeapon) {
                WeaponSound sound = ((IWeapon)weaponStack.func_77973_b()).getFireSound(weaponStack, (EntityLivingBase)player);
                this.soundMap.put((Entity)player, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
        } else if (this.soundMap.get(player).func_147667_k()) {
            this.stopWeaponSound(player);
            this.playWeaponSound(player, random);
        } else {
            this.soundMap.get(player).setPosition((float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        }
    }

    private void stopWeaponSound(EntityPlayer entity) {
        if (this.soundMap.containsKey(entity)) {
            WeaponSound sound = this.soundMap.get(entity);
            sound.stopPlaying();
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            this.soundMap.remove(entity);
        }
    }

    @Override
    protected boolean shouldRenderBeam(EntityPlayer entity) {
        return entity.func_184587_cr() && !StackUtils.isNullOrEmpty(entity.func_184607_cu()) && (entity.func_184607_cu().func_77973_b() instanceof Phaser || entity.func_184607_cu().func_77973_b() instanceof OmniTool);
    }

    @Override
    protected void onBeamRaycastHit(RayTraceResult hit, EntityPlayer caster) {
        ItemStack weaponStack = caster.func_184607_cu();
        if (!StackUtils.isNullOrEmpty(weaponStack) && weaponStack.func_77973_b() instanceof EnergyWeapon) {
            ((EnergyWeapon)weaponStack.func_77973_b()).onProjectileHit(hit, weaponStack, caster.field_70170_p, 1.0f);
            if (weaponStack.func_77973_b() instanceof OmniTool && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                GlStateManager.func_179094_E();
                RenderUtils.applyColorWithMultipy(this.getBeamColor(caster), 0.5f + (float)(1.0 + Math.sin((float)caster.field_70170_p.func_72820_D() * 0.5f)) * 0.5f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TileEntityRendererStation.glowTexture);
                GlStateManager.func_179137_b((double)((double)hit.func_178782_a().func_177958_n() + 0.5), (double)((double)hit.func_178782_a().func_177956_o() + 0.5), (double)((double)hit.func_178782_a().func_177952_p() + 0.5));
                GlStateManager.func_179137_b((double)((double)hit.field_178784_b.func_176730_m().func_177958_n() * 0.5), (double)((double)hit.field_178784_b.func_176730_m().func_177956_o() * 0.5), (double)((double)hit.field_178784_b.func_176730_m().func_177952_p() * 0.5));
                if (hit.field_178784_b == EnumFacing.SOUTH) {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                } else if (hit.field_178784_b == EnumFacing.NORTH) {
                    GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                } else if (hit.field_178784_b == EnumFacing.EAST) {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                } else if (hit.field_178784_b == EnumFacing.WEST) {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (hit.field_178784_b == EnumFacing.DOWN) {
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GlStateManager.func_179139_a((double)1.0, (double)(1.5 + Math.sin((double)caster.field_70170_p.func_72820_D() * 0.5) * 0.5), (double)1.0);
                GlStateManager.func_179121_F();
            }
        }
    }

    @Override
    protected void onBeamRender(EntityPlayer caster) {
        this.playWeaponSound(caster, this.random);
    }

    @Override
    protected Color getBeamColor(EntityPlayer caster) {
        return new Color(WeaponHelper.getColor(caster.func_184607_cu()));
    }

    @Override
    protected ResourceLocation getBeamTexture(EntityPlayer caster) {
        ItemStack weaponStack = caster.func_184607_cu();
        if (!StackUtils.isNullOrEmpty(weaponStack) && weaponStack.func_77973_b() instanceof IWeapon) {
            if (weaponStack.func_77973_b() instanceof Phaser) {
                return beamTexture;
            }
            if (weaponStack.func_77973_b() instanceof OmniTool) {
                return beamTexture;
            }
        }
        return null;
    }

    @Override
    protected float getBeamMaxDistance(EntityPlayer caster) {
        int range = 18;
        ItemStack weaponStack = caster.func_184607_cu();
        if (!StackUtils.isNullOrEmpty(weaponStack) && weaponStack.func_77973_b() instanceof IWeapon) {
            range = ((IWeapon)weaponStack.func_77973_b()).getRange(weaponStack);
        }
        return range;
    }

    @Override
    protected float getBeamThickness(EntityPlayer caster) {
        ItemStack weaponStack = caster.func_184607_cu();
        if (!StackUtils.isNullOrEmpty(weaponStack) && weaponStack.func_77973_b() instanceof IWeapon) {
            if (weaponStack.func_77973_b() instanceof Phaser) {
                return 0.03f;
            }
            if (weaponStack.func_77973_b() instanceof OmniTool) {
                return 0.07f;
            }
        }
        return 0.05f;
    }
}

