/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import java.util.Collection;
import matteroverdrive.api.renderer.ISpaceBodyHoloRenderer;
import matteroverdrive.client.render.tileentity.TileEntityRendererStation;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererStarMap
extends TileEntityRendererStation<TileEntityMachineStarMap> {
    @Override
    protected void renderHologram(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks, double noise) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap)) {
            if (this.isUsable(starMap)) {
                this.render(starMap, x, y, z, partialTicks);
            } else {
                super.renderHologram(starMap, x, y, z, partialTicks, noise);
            }
        }
    }

    public void render(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks) {
        if (!starMap.shouldRender()) {
            return;
        }
        this.renderHologramBase(starMap, x, y, z, partialTicks);
    }

    protected void renderHologramBase(TileEntityMachineStarMap starMap, double x, double y, double z, float partialTicks) {
        Collection<ISpaceBodyHoloRenderer> renderers;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        RenderUtils.disableLightmap();
        GlStateManager.func_179112_b((int)1, (int)1);
        float distance = (float)new Vec3d(x, y, z).func_72433_c();
        if (starMap.getActiveSpaceBody() != null && (renderers = ClientProxy.renderHandler.getStarmapRenderRegistry().getStarmapRendererCollection(starMap.getActiveSpaceBody().getClass())) != null) {
            for (ISpaceBodyHoloRenderer renderer : renderers) {
                SpaceBody spaceBody;
                if (!renderer.displayOnZoom(starMap.getZoomLevel(), starMap.getActiveSpaceBody()) || (spaceBody = starMap.getActiveSpaceBody()) == null) continue;
                GlStateManager.func_179137_b((double)0.0, (double)renderer.getHologramHeight(spaceBody), (double)0.0);
                GlStateManager.func_179094_E();
                renderer.renderBody(GalaxyClient.getInstance().getTheGalaxy(), spaceBody, starMap, partialTicks, distance);
                GlStateManager.func_179121_F();
                if (!this.drawHoloLights()) continue;
                GlStateManager.func_179094_E();
                Vec3d playerPosition = Minecraft.func_71410_x().func_175606_aa().func_174824_e(partialTicks);
                playerPosition = new Vec3d(playerPosition.field_72450_a, 0.0, playerPosition.field_72449_c);
                Vec3d mapPosition = new Vec3d((double)starMap.func_174877_v().func_177958_n() + 0.5, 0.0, (double)starMap.func_174877_v().func_177952_p() + 0.5);
                Vec3d dir = mapPosition.func_178788_d(playerPosition).func_72432_b();
                double angle = Math.acos(dir.func_72430_b(new Vec3d(1.0, 0.0, 0.0)));
                Vec3d vec3d = new Vec3d(0.0, 1.0, 0.0);
                Vec3d vec3d2 = new Vec3d(1.0, 0.0, 0.0);
                if (vec3d.func_72430_b(dir.func_72431_c(vec3d2)) < 0.0) {
                    angle = Math.PI * 2 - angle;
                }
                this.drawHoloGuiInfo(renderer, spaceBody, starMap, (1.5707963267948966 - angle) * 57.29577951308232, partialTicks);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
        RenderUtils.enableLightmap();
    }

    @Override
    protected boolean drawHoloLights() {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap);
    }

    @Override
    protected double getLightHeight() {
        return 1.0;
    }

    @Override
    protected double getLightsSize() {
        return 2.0;
    }

    public void drawHoloGuiInfo(ISpaceBodyHoloRenderer renderer, SpaceBody spaceBody, TileEntityMachineStarMap starMap, double angle, float partialTicks) {
        GlStateManager.func_179140_f();
        angle = Math.round(angle / 90.0) * 90L;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(-renderer.getHologramHeight(spaceBody) + 0.3), (double)0.0);
        GlStateManager.func_179114_b((float)((float)angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)1.0, (double)0.0, (double)-0.8);
        GlStateManager.func_179139_a((double)0.01, (double)0.01, (double)0.01);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (spaceBody != null) {
            renderer.renderGUIInfo(GalaxyClient.getInstance().getTheGalaxy(), spaceBody, starMap, partialTicks, 0.5f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }
}

