/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRenderGalaxy
extends StarMapRendererStars {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        double distanceMultiply = 2.0;
        GlStateManager.func_179132_a((boolean)false);
        GL11.glLineWidth((float)1.0f);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (Quadrant quadrant : galaxy.getQuadrants()) {
            this.renderStars(quadrant, starMap, distanceMultiply, 2.0);
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179090_x();
        GlStateManager.func_179098_w();
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        GlStateManager.func_179141_d();
        int ownedSystemCount = galaxy.getOwnedSystemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int enemySystemCount = galaxy.getEnemySystemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int freeSystemCount = galaxy.getStarCount() - ownedSystemCount - enemySystemCount;
        Color color = Reference.COLOR_HOLO_GREEN;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 0.0, -30.0);
        RenderUtils.drawString(String.format("x%s", ownedSystemCount), 24, -23, color, opacity);
        color = Reference.COLOR_HOLO_RED;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 64.0, -30.0);
        RenderUtils.drawString(String.format("x%s", enemySystemCount), 88, -23, color, opacity);
        color = Reference.COLOR_HOLO;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 128.0, -30.0);
        RenderUtils.drawString(String.format("x%s", freeSystemCount), 152, -23, color, opacity);
        GlStateManager.func_179118_c();
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 2.5;
    }
}

