/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererPlanet
extends StarMapRendererAbstract {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        if (spaceBody instanceof Planet) {
            GL11.glLineWidth((float)1.0f);
            Planet planet = (Planet)spaceBody;
            GlStateManager.func_179094_E();
            this.renderPlanet(planet, viewerDistance);
            GlStateManager.func_179121_F();
            GL11.glPolygonMode((int)1032, (int)6914);
            GlStateManager.func_179098_w();
        }
    }

    protected void renderPlanet(Planet planet, float viewerDistance) {
        GlStateManager.func_179094_E();
        float size = this.getClampedSize(planet);
        GlStateManager.func_179114_b((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71441_e.func_72820_D() * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPolygonMode((int)1028, (int)6913);
        GlStateManager.func_179089_o();
        GlStateManager.func_179094_E();
        GL11.glPolygonMode((int)1032, (int)6914);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        this.sphere.draw(size * 0.99f, 64, 32);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderUtils.applyColorWithMultipy(Planet.getGuiColor(planet), 0.2f * (1.0f / viewerDistance));
        GL11.glPolygonMode((int)1032, (int)6913);
        this.sphere.draw(size, 64, 32);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179129_p();
        GlStateManager.func_179121_F();
        this.drawPlanetInfoClose(planet);
        GL11.glPolygonMode((int)1032, (int)6914);
        GlStateManager.func_179098_w();
    }

    protected float getClampedSize(Planet planet) {
        return Math.min(Math.max(planet.getSize(), 1.0f), 2.2f) * 0.5f;
    }

    protected void drawPlanetInfoClose(Planet planet) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        if (spaceBody instanceof Planet) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)1);
            Color color = Reference.COLOR_HOLO;
            Planet planet = (Planet)spaceBody;
            int x = 0;
            int y = -16;
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
            ClientProxy.holoIcons.renderIcon("icon_size", (double)x, (double)y);
            RenderUtils.drawString(DecimalFormat.getPercentInstance().format(planet.getSize()), x += 18, y + 6, Reference.COLOR_HOLO, opacity);
            if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                x = -2;
                float happines = planet.getHappiness();
                color = RenderUtils.lerp(Reference.COLOR_HOLO_RED, Reference.COLOR_HOLO, MathHelper.func_76131_a((float)happines, (float)0.0f, (float)1.0f));
                RenderUtils.applyColorWithMultipy(color, opacity);
                ClientProxy.holoIcons.renderIcon("smile", (double)x, (double)(y -= 20));
                String info = DecimalFormat.getPercentInstance().format(happines);
                RenderUtils.drawString(info, x += 18, y + 6, color, opacity);
                int population = planet.getPopulation();
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("sort_random", (double)(x += this.fontRenderer.func_78256_a(DecimalFormat.getPercentInstance().format(happines)) + 4), (double)y);
                info = String.format("%,d", population);
                RenderUtils.drawString(info, x += 18, y + 6, Reference.COLOR_HOLO, opacity);
                x = -3;
                int powerProduction = planet.getPowerProduction();
                RenderUtils.applyColorWithMultipy(powerProduction < 0 ? Reference.COLOR_HOLO_RED : Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("battery", (double)x, (double)(y -= 20));
                info = Integer.toString(powerProduction) + "m" + MOEnergyHelper.ENERGY_UNIT;
                RenderUtils.drawString(info, x += 18, y + 6, powerProduction < 0 ? Reference.COLOR_HOLO_RED : Reference.COLOR_HOLO, opacity);
            }
        }
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return zoom == 3;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 1.5;
    }
}

