/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.weapons;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public abstract class WeaponItemRenderer
implements IBakedModel {
    protected ResourceLocation weaponModelLocation;
    protected OBJModel weaponModel;
    protected WeaponMetadataSection weaponMetadata;
    protected OBJModel.OBJBakedModel bakedModel;
    protected Map<ItemCameraTransforms.TransformType, Matrix4f> transforms = new HashMap<ItemCameraTransforms.TransformType, Matrix4f>();
    private Matrix4f identity;

    public WeaponItemRenderer(ResourceLocation weaponModelLocation) {
        this.weaponModelLocation = weaponModelLocation;
    }

    protected static Matrix4f getCombinedRotation(float x, float y, float z) {
        Matrix4f xMat = new Matrix4f();
        xMat.rotX((float)Math.toRadians(x));
        Matrix4f yMat = new Matrix4f();
        yMat.rotY((float)Math.toRadians(y));
        Matrix4f zMat = new Matrix4f();
        zMat.rotZ((float)Math.toRadians(z));
        xMat.mul(yMat);
        xMat.mul(zMat);
        return xMat;
    }

    public void init() {
        this.createModel(this.weaponModelLocation);
        this.loadWeaponMetadata();
        this.identity = new Matrix4f();
        this.identity.setIdentity();
        Matrix4f mat = new Matrix4f();
        mat.setIdentity();
        mat.rotY((float)Math.toRadians(180.0));
        mat.setTranslation(new Vector3f(-0.8f, 0.8f, -0.6f));
        mat.setScale(1.6f);
        this.transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, mat);
        mat = new Matrix4f();
        mat.setIdentity();
        mat.mul(WeaponItemRenderer.getCombinedRotation(20.0f, 45.0f, 0.0f));
        mat.setTranslation(new Vector3f(0.8f, 0.9f, 0.0f));
        mat.setScale(1.5f);
        this.transforms.put(ItemCameraTransforms.TransformType.GUI, mat);
        mat = new Matrix4f();
        mat.setIdentity();
        mat.setTranslation(new Vector3f(0.6f, 0.5f, 0.3f));
        mat.setScale(1.2f);
        this.transforms.put(ItemCameraTransforms.TransformType.GROUND, mat);
    }

    protected void loadWeaponMetadata() {
        this.weaponMetadata = new WeaponMetadataSection();
        try {
            IMetadataSection section;
            IResource metadataResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.weaponModelLocation);
            if (metadataResource.func_110528_c() && (section = metadataResource.func_110526_a("weapon")) instanceof WeaponMetadataSection) {
                this.weaponMetadata = (WeaponMetadataSection)section;
            }
        }
        catch (IOException e) {
            MOLog.log(Level.ERROR, e, "There was a problem reading weapon metadata from %s", this.weaponMetadata);
        }
    }

    protected void createModel(ResourceLocation weaponModelLocation) {
        try {
            this.weaponModel = (OBJModel)OBJLoader.INSTANCE.loadModel(weaponModelLocation);
            ImmutableMap customOptions = new ImmutableMap.Builder().put((Object)"flip-v", (Object)"true").put((Object)"ambient", (Object)"false").build();
            this.weaponModel = (OBJModel)this.weaponModel.process(customOptions);
        }
        catch (Exception e) {
            MOLog.error("Missing weapon model. %s", e, weaponModelLocation.toString());
        }
    }

    public void bakeModel() {
        if (this.weaponModel == null) {
            MOLog.error("Missing weapon model. Unable to bake %s", this.weaponModelLocation.toString());
            return;
        }
        ArrayList<String> visibleGroups = new ArrayList<String>();
        visibleGroups.add("OBJModel.Group.All.Key");
        this.bakedModel = (OBJModel.OBJBakedModel)this.weaponModel.bake((IModelState)new OBJModel.OBJState(visibleGroups, true), DefaultVertexFormats.field_176599_b, input -> Minecraft.func_71410_x().func_147117_R().func_110572_b(input.toString()));
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Matrix4f mat = this.transforms.get(type);
        if (mat == null) {
            mat = this.identity;
        }
        return ImmutablePair.of((Object)this, (Object)mat);
    }

    public void transformFirstPersonWeapon(EnergyWeapon energyWeapon, ItemStack weaponStack, float zoomValue, float recoilValue) {
        this.transformRecoil(recoilValue, zoomValue);
        GlStateManager.func_179137_b((double)0.0, (double)MOMathHelper.Lerp(0.0, 0.04, (double)zoomValue), (double)MOMathHelper.Lerp(0.0, -0.3, (double)zoomValue));
    }

    protected void transformRecoil(float recoilValue, float zoomValue) {
        GlStateManager.func_179109_b((float)0.0f, (float)(recoilValue * -0.005f), (float)(recoilValue * -0.02f));
        GlStateManager.func_179114_b((float)(recoilValue * 0.7f), (float)-1.0f, (float)0.0f, (float)0.0f);
    }

    public void renderHand(RenderPlayer renderPlayer) {
        renderPlayer.func_177139_c((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public void transformHand(float recoilValue, float zoomValue) {
        this.transformRecoil(recoilValue, zoomValue);
        GlStateManager.func_179137_b((double)MOMathHelper.Lerp(0.01, -0.15, (double)zoomValue), (double)-0.3, (double)0.4);
        GlStateManager.func_179114_b((float)MOMathHelper.Lerp(35.0f, 10.0f, zoomValue), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)MOMathHelper.Lerp(20.0f, 0.0f, zoomValue), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.bakedModel == null) {
            return Collections.emptyList();
        }
        return this.bakedModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.bakedModel.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.bakedModel.func_177552_f();
    }

    public float getHorizontalSpeed() {
        return 0.05f;
    }

    public WeaponMetadataSection getWeaponMetadata() {
        return this.weaponMetadata;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

