/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.compat.modules.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.RenderUtils;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class InscriberRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation ARROW = new ResourceLocation("matteroverdrive:textures/gui/elements/progress_arrow_right.png");
    private final List<ItemStack> inputs;
    private final List<ItemStack> outputs;
    private final int energy;
    private final int time;

    public InscriberRecipeWrapper(InscriberRecipe recipe) {
        this.inputs = ImmutableList.of((Object)recipe.getMain(), (Object)recipe.getSec());
        this.outputs = ImmutableList.of((Object)recipe.getOutput());
        this.energy = recipe.getEnergy();
        this.time = recipe.getTime();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(ARROW);
        int width = (int)((float)(minecraft.field_71441_e.func_82737_E() % (long)this.time) / (float)this.time * 24.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        RenderUtils.drawPlaneWithUV(35.0, 15.0, 0.0, width, 16.0, 0.5, 0.0, (float)width / 48.0f, 1.0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        String line1 = String.format("-%,d%s", this.energy, MOEnergyHelper.ENERGY_UNIT);
        int line1W = minecraft.field_71466_p.func_78256_a(line1);
        minecraft.field_71466_p.func_175063_a(line1, (float)(78 - line1W / 2), 38.0f, Reference.COLOR_HOLO_RED.getColor());
        String line2 = I18n.func_135052_a((String)"mo.jei.time", (Object[])new Object[]{this.time / 20});
        int line2W = minecraft.field_71466_p.func_78256_a(line2);
        minecraft.field_71466_p.func_175063_a(line2, (float)(78 - line2W / 2), 53.0f, Reference.COLOR_HOLO_RED.getColor());
    }
}

