/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.container;

import javax.annotation.Nonnull;
import matteroverdrive.api.container.IMachineWatcher;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.container.slot.SlotInventory;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.MOInventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerMachine<T extends MOTileEntityMachine>
extends MOBaseContainer
implements IMachineWatcher {
    protected T machine;
    EntityPlayer entityPlayer;
    private int progressScaled;

    public ContainerMachine() {
    }

    public ContainerMachine(InventoryPlayer inventory, T machine) {
        super(inventory);
        this.machine = machine;
        this.entityPlayer = inventory.field_70458_d;
        this.init(inventory);
    }

    protected void init(InventoryPlayer inventory) {
    }

    public void func_75132_a(IContainerListener icrafting) {
        super.func_75132_a(icrafting);
        if (icrafting instanceof EntityPlayerMP) {
            ((MOTileEntityMachine)this.machine).addWatcher(this);
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        if (playerIn instanceof EntityPlayerMP) {
            ((MOTileEntityMachine)this.machine).removeWatcher(this);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.machine != null) {
            short progressScaled = (short)(((MOTileEntityMachine)this.machine).getProgress() * 32767.0f);
            for (IContainerListener listener : this.field_75149_d) {
                if (this.progressScaled == progressScaled) continue;
                listener.func_71112_a((Container)this, 0, (int)progressScaled);
            }
            this.progressScaled = progressScaled;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int slot, int newValue) {
        if (slot == 0) {
            this.progressScaled = newValue;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void addUpgradeSlots(Inventory inventory) {
        this.addUpgradeSlots(inventory, 0, 0);
    }

    public void addUpgradeSlots(Inventory inventory, int x, int y) {
        int upgradeSlotIndex = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!(inventory.getSlot(i) instanceof UpgradeSlot)) continue;
            this.func_75146_a(new SlotInventory((IInventory)inventory, inventory.getSlot(i), x + upgradeSlotIndex % 5 * 24, y + upgradeSlotIndex / 5 * 24));
            ++upgradeSlotIndex;
        }
    }

    public void addAllSlotsFromInventory(Inventory inventory) {
        for (Slot slot : inventory.getSlots()) {
            this.func_75146_a(new SlotInventory((IInventory)inventory, inventory.getSlot(slot.getId()), 0, 0));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack itemstack = ItemStack.field_190927_a;
        net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)this.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (slotID < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean putInPlayerInventory(ItemStack itemStack) {
        return MOInventoryHelper.mergeItemStack(this.field_75151_b, itemStack, ((MOTileEntityMachine)this.machine).func_70302_i_(), this.field_75151_b.size() - ((MOTileEntityMachine)this.machine).func_70302_i_(), true, true);
    }

    protected boolean tryAndPutInMachineSlots(ItemStack itemStack, IInventory inventory) {
        return MOInventoryHelper.mergeItemStack(this.field_75151_b, itemStack, 0, inventory.func_70302_i_(), false, true);
    }

    public T getMachine() {
        return this.machine;
    }

    public float getProgress() {
        return (float)this.progressScaled / 32767.0f;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.entityPlayer;
    }

    @Override
    public void onWatcherAdded(MOTileEntityMachine machine) {
    }

    @Override
    public boolean isWatcherValid() {
        if (this.entityPlayer instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)this.entityPlayer).func_71121_q().func_152378_a(this.entityPlayer.func_110124_au()) != null;
        }
        return false;
    }
}

