/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import matteroverdrive.data.IUsableCondition;
import matteroverdrive.data.inventory.Slot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class Inventory
implements IInventory {
    final NonNullList<Slot> slots = NonNullList.func_191196_a();
    String name;
    IUsableCondition usableCondition;

    public Inventory(String name) {
        this(name, new ArrayList<Slot>());
    }

    public Inventory(String name, Collection<Slot> slots) {
        this(name, slots, null);
    }

    public Inventory(String name, Collection<Slot> slots, IUsableCondition usableCondition) {
        this.slots.addAll(slots);
        this.name = name;
        this.usableCondition = usableCondition;
    }

    public boolean func_191420_l() {
        return this.slots.isEmpty();
    }

    public int AddSlot(Slot slot) {
        if (this.slots.add((Object)slot)) {
            slot.setId(this.slots.size() - 1);
            return this.slots.size() - 1;
        }
        return 0;
    }

    public void setUsableCondition(IUsableCondition condition) {
        this.usableCondition = condition;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (nbttagcompound1.func_74764_b("id")) {
                this.func_70299_a(b0, new ItemStack(nbttagcompound1));
                continue;
            }
            this.func_70299_a(b0, ItemStack.field_190927_a);
        }
    }

    public void writeToNBT(NBTTagCompound compound, boolean toDisk) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.writeSlotToNBT(nbttaglist, i, toDisk);
        }
        if (nbttaglist.func_74745_c() > 0) {
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    protected void writeSlotToNBT(NBTTagList nbttaglist, int slotId, boolean toDisk) {
        Slot slot = this.getSlot(slotId);
        if (slot != null) {
            if (toDisk && !slot.getItem().func_190926_b()) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)slotId);
                if (!slot.getItem().func_190926_b()) {
                    slot.getItem().func_77955_b(nbttagcompound1);
                }
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            } else if (!toDisk && slot.sendsToClient()) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)slotId);
                if (!slot.getItem().func_190926_b()) {
                    slot.getItem().func_77955_b(nbttagcompound1);
                }
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
        }
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return ((Slot)this.slots.get(slot)).getItem();
    }

    @Nonnull
    public ItemStack func_70298_a(int slotId, int size) {
        Slot slot = this.getSlot(slotId);
        if (slot != null && !slot.getItem().func_190926_b()) {
            if (slot.getItem().func_190916_E() <= size) {
                ItemStack itemstack = slot.getItem();
                slot.setItem(ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = slot.getItem().func_77979_a(size);
            if (slot.getItem().func_190916_E() == 0) {
                slot.setItem(ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = this.getSlot(index).getItem();
        this.getSlot(index).setItem(ItemStack.field_190927_a);
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.getSlot(slot).setItem(item);
        if (!item.func_190926_b() && item.func_190916_E() > this.func_70297_j_()) {
            item.func_190920_e(this.func_70297_j_());
        }
    }

    public void addItem(ItemStack itemStack) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = this.getSlot(i);
            if (!slot.isValidForSlot(itemStack)) continue;
            if (slot.getItem().func_190926_b()) {
                slot.setItem(itemStack);
                return;
            }
            if (!ItemStack.func_77989_b((ItemStack)slot.getItem(), (ItemStack)itemStack) || slot.getItem().func_190916_E() >= slot.getItem().func_77976_d()) continue;
            int newStackSize = Math.min(slot.getItem().func_190916_E() + itemStack.func_190916_E(), slot.getItem().func_77976_d());
            int leftStackSize = slot.getItem().func_190916_E() + itemStack.func_190916_E() - newStackSize;
            slot.getItem().func_190920_e(newStackSize);
            if (leftStackSize <= 0) {
                return;
            }
            itemStack.func_190920_e(newStackSize);
        }
    }

    public void clearItems() {
        for (Slot slot : this.slots) {
            slot.setItem(ItemStack.field_190927_a);
        }
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name != null && !this.name.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.name);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    public boolean func_94041_b(int slotID, ItemStack item) {
        if (slotID >= 0 && slotID < this.func_70302_i_() && this.getSlot(slotID) != null) {
            Slot slot = this.getSlot(slotID);
            if (!slot.getItem().func_190926_b()) {
                return slot.getItem().func_190916_E() <= slot.getMaxStackSize() && slot.isValidForSlot(item);
            }
            return slot.isValidForSlot(item);
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (Slot slot : this.slots) {
            slot.setItem(ItemStack.field_190927_a);
        }
    }

    public Slot getSlot(int slotID) {
        return (Slot)this.slots.get(slotID);
    }

    public int getLastSlotId() {
        return this.slots.size() - 1;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }
}

