/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class ScaleTexture {
    int texW;
    int texH;
    int leftOffset;
    int rightOffset;
    int topOffset;
    int bottomOffset;
    int width;
    int height;
    int u;
    int v;
    private ResourceLocation location;

    public ScaleTexture(ResourceLocation location, int width, int height) {
        this.location = location;
        this.texW = width;
        this.texH = height;
        this.width = width;
        this.height = height;
    }

    public ScaleTexture setOffsets(int left, int right, int top, int bottom) {
        this.leftOffset = this.clamp(left, this.texW);
        this.rightOffset = this.clamp(right, this.texW - left);
        this.topOffset = this.clamp(top, this.texH);
        this.bottomOffset = this.clamp(bottom, this.texH - top);
        return this;
    }

    public void render(int x, int y, int width, int height) {
        this.render(x, y, width, height, 0);
    }

    public void render(int x, int y, int width, int height, int zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        float u = (float)this.u / (float)this.texW;
        float v = (float)this.v / (float)this.texH;
        float leftOffset = (float)this.leftOffset / (float)this.texW;
        float rightOffset = (float)this.rightOffset / (float)this.texW;
        float topOffset = (float)this.topOffset / (float)this.texH;
        float bottomOffset = (float)this.bottomOffset / (float)this.texH;
        int centerWidth = width - (this.leftOffset + this.rightOffset);
        int centerHeight = height - (this.topOffset + this.bottomOffset);
        float centerUWidth = (float)this.width / (float)this.texW - (leftOffset + rightOffset);
        float centerVHeight = (float)this.height / (float)this.texH - (topOffset + bottomOffset);
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(0.0, (double)this.topOffset, 0.0).func_187315_a((double)u, (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, 0.0, 0.0).func_187315_a((double)(u + leftOffset), (double)v).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), 0.0, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)v).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, 0.0, 0.0).func_187315_a((double)(u + leftOffset), (double)v).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), 0.0, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)v).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), 0.0, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)v).func_181675_d();
        wr.func_181662_b(0.0, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)u, (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b(0.0, (double)this.topOffset, 0.0).func_187315_a((double)u, (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)this.topOffset, 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset)).func_181675_d();
        wr.func_181662_b(0.0, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)u, (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b(0.0, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)u, (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)this.leftOffset, (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight + this.bottomOffset), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight + bottomOffset)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth + this.rightOffset), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth + rightOffset), (double)(v + topOffset + centerVHeight)).func_181675_d();
        wr.func_181662_b((double)(this.leftOffset + centerWidth), (double)(this.topOffset + centerHeight), 0.0).func_187315_a((double)(u + leftOffset + centerUWidth), (double)(v + topOffset + centerVHeight)).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    private int clamp(int value, int max) {
        return MathHelper.func_76125_a((int)value, (int)0, (int)max);
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ScaleTexture setTextureSize(int width, int height) {
        this.texW = width;
        this.texH = height;
        return this;
    }

    public ScaleTexture setUV(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }
}

