/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BioticStatShockwave
extends AbstractBioticStat {
    private static final int DELAY = 240;
    private static final int ENERGY = 512;

    public BioticStatShockwave(String name, int xp) {
        super(name, xp);
        this.showOnWheel = true;
    }

    @Override
    public String getDetails(int level) {
        String keyName = TextFormatting.AQUA + GameSettings.func_74298_c((int)ClientProxy.keyHandler.getBinding(1).func_151463_i()) + TextFormatting.GRAY;
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.YELLOW + Integer.toString(10) + TextFormatting.GRAY, keyName);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (this.equals(android.getActiveStat()) && !android.getPlayer().field_70122_E && android.getPlayer().field_70181_x < 0.0 && android.getPlayer().func_70093_af()) {
            Vec3d motion = new Vec3d(android.getPlayer().field_70159_w, android.getPlayer().field_70181_x, android.getPlayer().field_70179_y).func_178788_d(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            android.getPlayer().func_70024_g(motion.field_72450_a * 0.2, motion.field_72448_b * 0.2, motion.field_72449_c * 0.2);
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
        if (this.equals(androidPlayer.getActiveStat()) && server) {
            this.createShockwave(androidPlayer, (EntityLivingBase)androidPlayer.getPlayer(), 5.0f);
        }
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if ((event instanceof LivingFallEvent || event instanceof PlayerFlyableFallEvent) && event.getEntityLiving().func_70093_af() && this.equals(androidPlayer.getActiveStat())) {
            if (event instanceof LivingFallEvent) {
                this.createShockwave(androidPlayer, event.getEntityLiving(), ((LivingFallEvent)event).getDistance());
            } else {
                this.createShockwave(androidPlayer, event.getEntityLiving(), ((PlayerFlyableFallEvent)event).getDistance());
            }
        }
    }

    private void createShockwave(AndroidPlayer androidPlayer, EntityLivingBase entityPlayer, float distance) {
        if (this.getLastShockwaveTime(androidPlayer) < androidPlayer.getPlayer().field_70170_p.func_82737_E() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, androidPlayer.getUnlockedLevel(this), androidPlayer)) && !entityPlayer.field_70170_p.field_72995_K) {
            float range = MathHelper.func_76131_a((float)distance, (float)5.0f, (float)10.0f);
            float power = MathHelper.func_76131_a((float)distance, (float)1.0f, (float)3.0f) * 0.8f;
            if (androidPlayer.hasEnoughEnergyScaled((int)(range * 512.0f))) {
                AxisAlignedBB area = new AxisAlignedBB(entityPlayer.field_70165_t - (double)range, entityPlayer.field_70163_u - (double)range, entityPlayer.field_70161_v - (double)range, entityPlayer.field_70165_t + (double)range, entityPlayer.field_70163_u + (double)range, entityPlayer.field_70161_v + (double)range);
                List entities = entityPlayer.field_70170_p.func_72872_a(EntityLivingBase.class, area);
                for (EntityLivingBase entityLivingBase : entities) {
                    if (entityLivingBase == entityPlayer || entityLivingBase instanceof EntityPlayer && entityPlayer.field_70170_p.func_73046_m() != null && !entityPlayer.field_70170_p.func_73046_m().func_71219_W()) continue;
                    Vec3d dir = entityLivingBase.func_174791_d().func_178788_d(entityPlayer.func_174791_d());
                    double localDistance = dir.func_72433_c();
                    double distanceMultiply = (double)range / Math.max(1.0, localDistance);
                    dir = dir.func_72432_b();
                    entityLivingBase.func_70024_g(dir.field_72450_a * (double)power * distanceMultiply, (double)(power * 0.2f), dir.field_72449_c * (double)power * distanceMultiply);
                    entityLivingBase.field_70133_I = true;
                    ShockwaveDamage damageSource = new ShockwaveDamage("android_shockwave", entityPlayer);
                    entityLivingBase.func_70097_a((DamageSource)damageSource, power * 3.0f);
                }
                this.setLastShockwaveTime(androidPlayer, androidPlayer.getPlayer().field_70170_p.func_82737_E() + 240L);
                androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
                entityPlayer.field_70170_p.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, MatterOverdriveSounds.androidShockwave, SoundCategory.PLAYERS, 1.0f, 0.9f + entityPlayer.func_70681_au().nextFloat() * 0.1f);
                for (int i = 0; i < 20; ++i) {
                    double d0 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                    double d1 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                    double d2 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                    double d3 = 10.0;
                    entityPlayer.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, entityPlayer.field_70165_t + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70130_N * 2.0f) - (double)entityPlayer.field_70130_N - d0 * d3, entityPlayer.field_70163_u + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70131_O) - d1 * d3, entityPlayer.field_70161_v + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70130_N * 2.0f) - (double)entityPlayer.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
                }
                androidPlayer.extractEnergyScaled((int)(range * 512.0f));
                MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSpawnParticle("shockwave", androidPlayer.getPlayer().field_70165_t, androidPlayer.getPlayer().field_70163_u + (double)(androidPlayer.getPlayer().func_70047_e() / 2.0f), androidPlayer.getPlayer().field_70161_v, 1, RenderParticlesHandler.Blending.Additive, 10.0f), androidPlayer.getPlayer(), 64.0);
            }
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.equals(android.getActiveStat()) || this.getDelay(android, level) > 0;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && this.getDelay(android, level) <= 0 && android.hasEnoughEnergyScaled(5120);
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        long shockwaveTime = this.getLastShockwaveTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        if (shockwaveTime > 0L) {
            return (int)shockwaveTime;
        }
        return 0;
    }

    private long getLastShockwaveTime(AndroidPlayer androidPlayer) {
        return androidPlayer.getAndroidEffects().getEffectLong(5);
    }

    private void setLastShockwaveTime(AndroidPlayer androidPlayer, long time) {
        androidPlayer.getAndroidEffects().updateEffect(5, time);
    }

    public class ShockwaveDamage
    extends DamageSource {
        private final EntityLivingBase source;

        public ShockwaveDamage(String p_i1566_1_, EntityLivingBase source) {
            super(p_i1566_1_);
            this.source = source;
            this.func_94540_d();
            this.func_76348_h();
        }

        @Nullable
        public Entity func_76346_g() {
            return this.source;
        }
    }
}

