/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.Quest;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GenericQuest
extends Quest {
    protected IQuestLogic questLogic;

    public GenericQuest(String title, JsonObject questObj, IQuestLogic questLogic) {
        super(title, questObj);
        this.questLogic = questLogic;
    }

    public GenericQuest(IQuestLogic questLogic, String title, int xpReward) {
        super(title, xpReward);
        this.questLogic = questLogic;
    }

    @Override
    public boolean canBeAccepted(QuestStack questStack, EntityPlayer entityPlayer) {
        OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer);
        if (extendedProperties != null) {
            return this.questLogic.canAccept(questStack, entityPlayer) && !extendedProperties.hasCompletedQuest(questStack) && !extendedProperties.hasQuest(questStack);
        }
        return false;
    }

    @Override
    public String getTitle(QuestStack questStack) {
        return this.questLogic.modifyTitle(questStack, MOStringHelper.translateToLocal("quest." + this.title + ".title", new Object[0]));
    }

    @Override
    public String getTitle(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyTitle(questStack, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".title", new Object[0]), entityPlayer));
    }

    @Override
    public String getInfo(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyInfo(questStack, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".info", new Object[0]), entityPlayer));
    }

    @Override
    public String getObjective(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.questLogic.modifyObjective(questStack, entityPlayer, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + ".objective." + objectiveIndex, new Object[0]), entityPlayer), objectiveIndex);
    }

    @Override
    public int getObjectivesCount(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyObjectiveCount(questStack, entityPlayer, 1);
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.questLogic.isObjectiveCompleted(questStack, entityPlayer, objectiveIndex);
    }

    @Override
    public boolean areQuestStacksEqual(QuestStack questStackOne, QuestStack questStackTwo) {
        if (questStackOne.getQuest() instanceof GenericQuest && questStackTwo.getQuest() instanceof GenericQuest && ((GenericQuest)questStackOne.getQuest()).getQuestLogic() == ((GenericQuest)questStackTwo.getQuest()).getQuestLogic()) {
            return ((GenericQuest)questStackTwo.getQuest()).getQuestLogic().areQuestStacksEqual(questStackOne, questStackTwo);
        }
        return false;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.questLogic.initQuestStack(random, questStack);
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public QuestState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        QuestLogicState state = this.questLogic.onEvent(questStack, event, entityPlayer);
        if (state == null) {
            return null;
        }
        return new QuestState(state.getType(), new int[]{0}, state.isShowOnHud());
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        this.questLogic.onQuestCompleted(questStack, entityPlayer);
    }

    @Override
    public int getXpReward(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyXP(questStack, entityPlayer, this.xpReward);
    }

    @Override
    public void addToRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
        rewards.addAll(this.questRewards);
        this.questLogic.modifyRewards(questStack, entityPlayer, rewards);
    }

    public String replaceVariables(String text, EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return text.replace("$player", entityPlayer.func_145748_c_().func_150254_d());
        }
        return text;
    }

    public IQuestLogic getQuestLogic() {
        return this.questLogic;
    }

    public void setQuestLogic(IQuestLogic questLogic) {
        this.questLogic = questLogic;
    }
}

