/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public abstract class AbstractQuestLogic
implements IQuestLogic {
    protected List<IQuestReward> rewards = new ArrayList<IQuestReward>();
    protected boolean autoComplete;
    private String id;

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        this.autoComplete = MOJsonHelper.getBool(jsonObject, "auto_complete", false);
        if (jsonObject.has("rewards")) {
            this.rewards.addAll(MatterOverdrive.QUEST_ASSEMBLER.parseRewards(jsonObject.getAsJsonArray("rewards")));
        }
    }

    @Override
    public String modifyTitle(QuestStack questStack, String original) {
        return original;
    }

    @Override
    public boolean canAccept(QuestStack questStack, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public int modifyObjectiveCount(QuestStack questStack, EntityPlayer entityPlayer, int count) {
        return count;
    }

    @Override
    public boolean areQuestStacksEqual(QuestStack questStackOne, QuestStack questStackTwo) {
        return true;
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp;
    }

    public int random(Random random, int min, int max) {
        int randomCount = max - min;
        return min + (randomCount > 0 ? random.nextInt(randomCount) : 0);
    }

    protected String getEntityClassName(Class<? extends Entity> entityClass, String unknownTargetName) {
        if (entityClass != null) {
            EntityRegistry.EntityRegistration entityRegistration = EntityRegistry.instance().lookupModSpawn(entityClass, true);
            if (entityRegistration != null) {
                return entityRegistration.getEntityName();
            }
            String name = EntityList.func_191306_a(entityClass).toString();
            if (name != null) {
                return name;
            }
        }
        return unknownTargetName;
    }

    public AbstractQuestLogic setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        return this;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected boolean hasTag(QuestStack questStack) {
        if (this.getID() == null) {
            return questStack.getTagCompound() != null;
        }
        return questStack.getTagCompound() != null && questStack.getTagCompound().func_74764_b(this.getID());
    }

    protected void initTag(QuestStack questStack) {
        if (!this.hasTag(questStack)) {
            if (this.getID() == null) {
                questStack.setTagCompound(new NBTTagCompound());
            } else {
                NBTTagCompound tagCompound = questStack.getTagCompound();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                }
                tagCompound.func_74782_a(this.getID(), (NBTBase)new NBTTagCompound());
                questStack.setTagCompound(tagCompound);
            }
        }
    }

    protected NBTTagCompound getTag(QuestStack questStack) {
        if (this.getID() == null) {
            return questStack.getTagCompound();
        }
        return questStack.getTagCompound().func_74775_l(this.getID());
    }

    protected void markComplete(QuestStack questStack, EntityPlayer entityPlayer) {
        if (this.autoComplete) {
            questStack.markComplited(entityPlayer, false);
        }
        if (this.rewards != null) {
            for (IQuestReward reward : this.rewards) {
                reward.giveReward(questStack, entityPlayer);
            }
        }
    }
}

