/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicMine
extends AbstractQuestLogic {
    QuestBlock[] blocks;
    int minMineCount;
    int maxMineCount;
    int xpPerMine;
    boolean randomBlock;
    boolean destryDrops;

    public QuestLogicMine() {
    }

    public QuestLogicMine(IBlockState block, int minMineCount, int maxMineCount, int xpPerMine) {
        this.blocks = new QuestBlock[]{QuestBlock.fromBlock(block)};
        this.minMineCount = minMineCount;
        this.maxMineCount = maxMineCount;
        this.xpPerMine = xpPerMine;
        this.randomBlock = true;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        JsonArray blocksElement = jsonObject.getAsJsonArray("blocks");
        this.blocks = new QuestBlock[blocksElement.size()];
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new QuestBlock(blocksElement.get(i).getAsJsonObject());
        }
        this.minMineCount = MOJsonHelper.getInt(jsonObject, "mine_count_min");
        this.maxMineCount = MOJsonHelper.getInt(jsonObject, "mine_count_max");
        this.xpPerMine = MOJsonHelper.getInt(jsonObject, "xp", 0);
        this.randomBlock = MOJsonHelper.getBool(jsonObject, "random", false);
        this.destryDrops = MOJsonHelper.getBool(jsonObject, "destroy_drops", false);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$maxMineAmount", Integer.toString(this.getMaxMineCount(questStack)));
        IBlockState state = this.getBlock(questStack);
        info = info.replace("$mineBlock", state != null ? state.func_177230_c().func_149732_F() : "Unknown Block");
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getMineCount(questStack) >= this.getMaxMineCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = objective.replace("$mineAmount", Integer.toString(this.getMineCount(questStack)));
        objective = objective.replace("$maxMineAmount", Integer.toString(this.getMaxMineCount(questStack)));
        IBlockState state = this.getBlock(questStack);
        objective = objective.replace("$mineBlock", state.func_177230_c() != null ? state.func_177230_c().func_149732_F() : "Unknown Block");
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.initBlockType(random, questStack);
        this.getTag(questStack).func_74768_a("MaxMineCount", this.random(random, this.minMineCount, this.maxMineCount));
    }

    private void initBlockType(Random random, QuestStack questStack) {
        if (this.randomBlock) {
            ArrayList<Integer> avalibleBlocks = new ArrayList<Integer>();
            for (int i = 0; i < this.blocks.length; ++i) {
                IBlockState block = this.blocks[i].getBlockState();
                if (block == null) continue;
                avalibleBlocks.add(i);
            }
            if (avalibleBlocks.size() > 0) {
                this.setBlockType(questStack, (Integer)avalibleBlocks.get(random.nextInt(avalibleBlocks.size())));
            }
        } else {
            for (int i = 0; i < this.blocks.length; ++i) {
                IBlockState block = this.blocks[i].getBlockState();
                if (block == null) continue;
                this.setBlockType(questStack, i);
            }
        }
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof BlockEvent.HarvestDropsEvent) {
            BlockEvent.HarvestDropsEvent harvestEvent = (BlockEvent.HarvestDropsEvent)event;
            IBlockState state = this.getBlock(questStack);
            if (state != null && harvestEvent.getState().equals(state) && this.getMineCount(questStack) < this.getMaxMineCount(questStack)) {
                if (this.destryDrops) {
                    harvestEvent.getDrops().clear();
                }
                this.setMineCount(questStack, this.getMineCount(questStack) + 1);
                if (this.isObjectiveCompleted(questStack, entityPlayer, 0)) {
                    this.markComplete(questStack, entityPlayer);
                    return new QuestLogicState(QuestState.Type.COMPLETE, true);
                }
                return new QuestLogicState(QuestState.Type.UPDATE, true);
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxMineCount(questStack) * this.xpPerMine;
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public int getMineCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MineCount");
        }
        return 0;
    }

    public void setMineCount(QuestStack questStack, int mineCount) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("MineCount", mineCount);
    }

    public int getMaxMineCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxMineCount");
        }
        return 0;
    }

    public int getBlockType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("BlockType");
        }
        return 0;
    }

    public void setBlockType(QuestStack questStack, int blockType) {
        this.initTag(questStack);
        this.getTag(questStack).func_74774_a("BlockType", (byte)blockType);
    }

    public IBlockState getBlock(QuestStack questStack) {
        int blockType = this.getBlockType(questStack);
        if (blockType < this.blocks.length) {
            return this.blocks[blockType].getBlockState();
        }
        return null;
    }

    public QuestLogicMine setRandomBlock(boolean randomBlock) {
        this.randomBlock = randomBlock;
        return this;
    }

    public QuestLogicMine setDestroyDrops(boolean destryDrops) {
        this.destryDrops = destryDrops;
        return this;
    }
}

