/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.logic.AbstractQuestLogicBlock;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicScanBlock
extends AbstractQuestLogicBlock {
    private int minBlockScan;
    private int maxBlockScan;
    private int xpPerBlock;
    private boolean onlyDestroyable;

    public QuestLogicScanBlock() {
    }

    public QuestLogicScanBlock(QuestBlock block, int minBlockScan, int maxBlockScan, int xpPerBlock) {
        super(block);
        this.minBlockScan = minBlockScan;
        this.maxBlockScan = maxBlockScan;
        this.xpPerBlock = xpPerBlock;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.minBlockScan = MOJsonHelper.getInt(jsonObject, "scan_count_min");
        this.maxBlockScan = MOJsonHelper.getInt(jsonObject, "scan_count_max");
        this.xpPerBlock = MOJsonHelper.getInt(jsonObject, "xp", 0);
        this.onlyDestroyable = MOJsonHelper.getBool(jsonObject, "only_destroyable", false);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return this.replaceBlockNameInText(info);
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getBlockScan(questStack) >= this.getMaxBlockScan(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = this.replaceBlockNameInText(objective);
        objective = objective.replace("$scanAmount", Integer.toString(this.getBlockScan(questStack)));
        objective = objective.replace("$maxScanAmount", Integer.toString(this.getMaxBlockScan(questStack)));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.setMaxBlockScan(questStack, this.random(random, this.minBlockScan, this.maxBlockScan));
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof MOEventScan) {
            MOEventScan eventScan = (MOEventScan)event;
            if (eventScan.position.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (this.onlyDestroyable && eventScan.scannerStack.func_77973_b() instanceof IBlockScanner && !((IBlockScanner)eventScan.scannerStack.func_77973_b()).destroysBlocks(eventScan.scannerStack)) {
                    return null;
                }
                IBlockState state = entityPlayer.field_70170_p.func_180495_p(eventScan.position.func_178782_a());
                if (this.block != null && this.areBlocksTheSame(state) && this.getBlockScan(questStack) < this.getMaxBlockScan(questStack)) {
                    this.setBlocScan(questStack, this.getBlockScan(questStack) + 1);
                    if (this.getBlockScan(questStack) >= this.getMaxBlockScan(questStack) && this.autoComplete) {
                        questStack.markComplited(entityPlayer, false);
                        return new QuestLogicState(QuestState.Type.COMPLETE, true);
                    }
                    return new QuestLogicState(QuestState.Type.UPDATE, true);
                }
            }
        }
        return null;
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxBlockScan(questStack) * this.xpPerBlock;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    protected void setMaxBlockScan(QuestStack questStack, int maxBlockScan) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("MaxBlockScan", (short)maxBlockScan);
    }

    protected int getMaxBlockScan(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("MaxBlockScan");
        }
        return 0;
    }

    protected int getBlockScan(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("BlockScan");
        }
        return 0;
    }

    protected void setBlocScan(QuestStack questStack, int blockScan) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("BlockScan", (short)blockScan);
    }

    public QuestLogicScanBlock setOnlyDestroyable(boolean onlyDestroyable) {
        this.onlyDestroyable = true;
        return this;
    }
}

