/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.exceptions.MOQuestParseException;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicSingleEvent
extends AbstractQuestLogic {
    Class<? extends Event> event;

    public QuestLogicSingleEvent() {
    }

    public QuestLogicSingleEvent(Class<? extends Event> event) {
        this.event = event;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        String eventName = MOJsonHelper.getString(jsonObject, "event");
        try {
            this.event = Class.forName(eventName);
        }
        catch (ClassNotFoundException e) {
            throw new MOQuestParseException(String.format("Could not find event class from type: %s", eventName), e);
        }
        catch (ClassCastException e) {
            throw new MOQuestParseException(String.format("Class must be derived form Forge Event Super class", new Object[0]), e);
        }
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.hasEventFired(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (!this.hasEventFired(questStack) && this.event.isInstance(event)) {
            this.markComplete(questStack, entityPlayer);
            this.setEventFired(questStack);
            return new QuestLogicState(QuestState.Type.COMPLETE, true);
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public boolean hasEventFired(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74767_n("e");
        }
        return false;
    }

    public void setEventFired(QuestStack questStack) {
        this.initTag(questStack);
        this.getTag(questStack).func_74757_a("e", true);
    }
}

