/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import matteroverdrive.api.transport.IGridNetwork;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.data.transport.ConnectionPathfind;
import matteroverdrive.handler.matter_network.GridNetworkHandler;
import matteroverdrive.util.MOLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractGridNetwork<T extends IGridNode>
implements IGridNetwork<T> {
    private final Class<T> nodeTypes;
    private final Set<T> nodes;
    private GridNetworkHandler gridNetworkHandler;

    public AbstractGridNetwork(GridNetworkHandler gridNetworkHandler, Class<T> nodeTypes) {
        this.nodeTypes = nodeTypes;
        this.nodes = new HashSet<T>();
        this.gridNetworkHandler = gridNetworkHandler;
    }

    @Override
    public void onNodeDestroy(IBlockState blockState, T node) {
        this.removeNode(node);
        if (this.nodes.size() > 0) {
            ConnectionPathfind<IGridNode> pathfind = new ConnectionPathfind<IGridNode>((IGridNode)node, (Class<IGridNode>)this.nodeTypes);
            ArrayList<IGridNode> connections = new ArrayList<IGridNode>();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                IGridNode otherNode;
                if (!node.canConnectFromSide(blockState, dir)) continue;
                BlockPos otherNodePos = node.getNodePos().func_177972_a(dir);
                if (!node.getNodeWorld().func_175667_e(otherNodePos)) continue;
                TileEntity otherNodeTile = node.getNodeWorld().func_175625_s(otherNodePos);
                IBlockState otherNodeBlockState = node.getNodeWorld().func_180495_p(otherNodePos);
                if (!this.nodeTypes.isInstance(otherNodeTile) || !node.canConnectToNetworkNode(blockState, otherNode = (IGridNode)this.nodeTypes.cast(otherNodeTile), dir) || !otherNode.canConnectToNetworkNode(otherNodeBlockState, (IGridNode)node, dir.func_176734_d())) continue;
                connections.add(otherNode);
            }
            if (connections.size() > 1) {
                for (IGridNode c : connections) {
                    if (pathfind.init(c)) continue;
                    for (IGridNode n : pathfind.getBurnedNodes()) {
                        this.removeNode(n);
                    }
                }
            }
        }
        if (this.nodes.size() <= 0) {
            this.recycle();
            this.gridNetworkHandler.recycleNetwork(this);
        }
    }

    @Override
    public void addNode(T node) {
        if (node.getNetwork() != null) {
            if (node.getNetwork() != this) {
                if (node.getNetwork().canMerge(this)) {
                    this.mergeNetworks((IGridNetwork<T>)node.getNetwork());
                }
            } else {
                MOLog.info("Adding Node %s to it's own network %s", node, this);
            }
        } else {
            this.nodes.add(node);
            node.setNetwork((AbstractGridNetwork)this);
            this.onNodeAdded(node);
        }
    }

    protected void mergeNetworks(IGridNetwork<T> network) {
        Iterator<T> iterator = network.getNodesIterator();
        while (iterator.hasNext()) {
            IGridNode node = (IGridNode)iterator.next();
            iterator.remove();
            node.setNetwork(null);
            this.addNode(node);
        }
        network.recycle();
        this.gridNetworkHandler.recycleNetwork(network);
    }

    @Override
    public void removeNode(T node) {
        if (node.getNetwork() == null || node.getNetwork() == this) {
            node.setNetwork(null);
            this.nodes.remove(node);
            this.onNodeRemoved(node);
        } else if (node.getNetwork() != null) {
            MOLog.info("Trying to remove node from a different network than it's assigned one", new Object[0]);
        }
    }

    @Override
    public void recycle() {
        this.nodes.clear();
    }

    @Override
    public Collection<T> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterator<T> getNodesIterator() {
        return this.nodes.iterator();
    }

    protected abstract void onNodeAdded(T var1);

    protected abstract void onNodeRemoved(T var1);
}

