/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.util.math.MathHelper;

public class ElementGroupList
extends ElementBaseGroup {
    private int selectedIndex;
    private int scroll;
    private int smoothScroll;
    private float smoothScrollMultiply = 0.1f;
    private int padding = 6;
    private IListHandler listHandler;

    public ElementGroupList(MOGuiBase gui, IListHandler listHandler, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
        this.listHandler = listHandler;
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
        int heightCount = 0;
        for (MOElementBase element : this.elements) {
            element.setPosition(0, heightCount + this.smoothScroll);
            if (this.smoothScroll + (heightCount += element.getHeight() + this.padding) >= 0 && heightCount + this.smoothScroll - element.getHeight() < this.sizeY) {
                element.setVisible(true);
                continue;
            }
            element.setVisible(false);
        }
        this.smoothScroll = (int)MOMathHelper.Lerp(this.smoothScroll, this.scroll, this.smoothScrollMultiply);
        this.selectedIndex = MathHelper.func_76125_a((int)this.selectedIndex, (int)0, (int)(this.elements.size() - 1));
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endStencil();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawForeground(mouseX, mouseY);
        RenderUtils.endStencil();
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        boolean didScroll = super.onMouseWheel(mouseX, mouseY, movement);
        this.scroll = (int)((double)this.scroll + (double)movement * 0.2);
        this.limitScroll();
        return didScroll;
    }

    public void limitScroll() {
        int elementsHeight = -(this.getElementsHeight() - this.sizeY + 32);
        this.scroll = Math.min(0, this.scroll);
        this.scroll = Math.max(elementsHeight, this.scroll);
    }

    public int getElementsHeight() {
        int height = 0;
        for (MOElementBase element : this.elements) {
            height += element.getHeight() + this.padding;
        }
        return height;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        int newSelectedIndex = MathHelper.func_76125_a((int)selectedIndex, (int)0, (int)(this.elements.size() - 1));
        if (newSelectedIndex != this.selectedIndex) {
            this.selectedIndex = newSelectedIndex;
            this.listHandler.ListSelectionChange(this.getName(), selectedIndex);
        } else {
            this.selectedIndex = newSelectedIndex;
        }
    }

    public boolean isSelected(MOElementBase elementBase) {
        return this.selectedIndex < this.elements.size() && ((MOElementBase)this.elements.get(this.selectedIndex)).equals(elementBase);
    }

    public void resetSmoothScroll() {
        this.smoothScroll = this.scroll;
    }

    public int getScroll() {
        return this.scroll;
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
    }
}

