/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.Iterator;
import matteroverdrive.data.matter_network.ItemPatternMapping;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementGrid;
import matteroverdrive.gui.element.ElementItemPattern;
import matteroverdrive.gui.element.ElementMonitorItemPattern;
import matteroverdrive.gui.element.MOElementBase;
import net.minecraft.util.math.BlockPos;

public class ElementPatternsGrid
extends ElementGrid {
    String filter = "";

    public ElementPatternsGrid(MOGuiBase guiBase, int x, int y, int width, int height) {
        super(guiBase, x, y, width, height, width);
        this.setMargins(0, 0, 4, 0);
    }

    public void setPattern(ItemPatternMapping patternMapping) {
        Iterator elementBaseIterator = this.elements.iterator();
        boolean patternSet = false;
        while (elementBaseIterator.hasNext()) {
            ItemPatternMapping elementPatternMapping;
            MOElementBase elementBase = (MOElementBase)elementBaseIterator.next();
            if (!(elementBase instanceof ElementItemPattern) || !(elementPatternMapping = ((ElementItemPattern)elementBase).getPatternMapping()).getDatabaseId().equals((Object)patternMapping.getDatabaseId()) || elementPatternMapping.getStorageId() != patternMapping.getStorageId() || elementPatternMapping.getPatternId() != patternMapping.getPatternId()) continue;
            if (patternMapping.getItemPattern() == null) {
                elementBaseIterator.remove();
                continue;
            }
            ((ElementItemPattern)elementBase).setPatternMapping(patternMapping);
            patternSet = true;
            break;
        }
        if (!patternSet && patternMapping.getItemPattern() != null) {
            this.elements.add(new ElementMonitorItemPattern(this.gui, patternMapping, this.gui));
        }
    }

    public void removePatterns(BlockPos database) {
        Iterator elementBaseIterator = this.elements.iterator();
        while (elementBaseIterator.hasNext()) {
            MOElementBase elementBase = (MOElementBase)elementBaseIterator.next();
            if (!(elementBase instanceof ElementItemPattern) || !((ElementItemPattern)elementBase).getPatternMapping().getDatabaseId().equals((Object)database)) continue;
            elementBaseIterator.remove();
        }
    }

    public void removePatterns(BlockPos database, int storageId) {
        Iterator elementBaseIterator = this.elements.iterator();
        while (elementBaseIterator.hasNext()) {
            MOElementBase elementBase = (MOElementBase)elementBaseIterator.next();
            if (!(elementBase instanceof ElementItemPattern) || !((ElementItemPattern)elementBase).getPatternMapping().getDatabaseId().equals((Object)database) || ((ElementItemPattern)elementBase).getPatternMapping().getStorageId() != storageId) continue;
            elementBaseIterator.remove();
        }
    }

    public void clearPattern() {
        this.elements.clear();
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public boolean shouldBeDisplayed(MOElementBase element) {
        return element.getName() != null && element.getName().toLowerCase().contains(this.filter.toLowerCase());
    }
}

