/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.android_station;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.network.packet.server.PacketUnlockBioticStat;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ElementBioStat
extends MOElementButton {
    private IBioticStat stat;
    private AndroidPlayer player;
    private int level;
    private EnumFacing direction;
    private boolean strongConnection;
    private ResourceLocation strongConnectionTex = new ResourceLocation("matteroverdrive:textures/gui/elements/connection.png");
    private ResourceLocation strongConnectionBrokenTex = new ResourceLocation("matteroverdrive:textures/gui/elements/connection_broken.png");

    public ElementBioStat(MOGuiBase gui, int posX, int posY, IBioticStat stat, int level, AndroidPlayer player) {
        super(gui, gui, posX, posY, stat.getUnlocalizedName(), 0, 0, 0, 0, 22, 22, "");
        this.texture = ElementSlot.getTexture("holo");
        this.texW = 22;
        this.texH = 22;
        this.stat = stat;
        this.player = player;
        this.level = level;
    }

    @Override
    public boolean isEnabled() {
        return this.stat.canBeUnlocked(this.player, this.level) && this.player.getUnlockedLevel(this.stat) < this.stat.maxLevel();
    }

    @Override
    protected void ApplyColor() {
        if (this.stat.canBeUnlocked(this.player, this.level) || this.player.isUnlocked(this.stat, this.level)) {
            if (this.level <= 0) {
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.5f);
            } else {
                RenderUtils.applyColor(Reference.COLOR_HOLO);
            }
        } else {
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO_RED, 0.5f);
        }
    }

    @Override
    protected void ResetColor() {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        this.stat.onTooltip(this.player, MathHelper.func_76125_a((int)this.level, (int)0, (int)this.stat.maxLevel()), list, mouseX, mouseY);
    }

    @Override
    public void onAction(int mouseX, int mouseY, int mouseButton) {
        if (super.intersectsWith(mouseX, mouseY) && this.stat.canBeUnlocked(this.player, this.level + 1) && this.level < this.stat.maxLevel()) {
            MOGuiBase.playSound(MatterOverdriveSounds.guiBioticStatUnlock, 1.0f, 1.0f);
            MatterOverdrive.NETWORK.sendToServer(new PacketUnlockBioticStat(this.stat.getUnlocalizedName(), ++this.level));
        }
        super.onAction(mouseX, mouseY, mouseButton);
    }

    @Override
    public void drawTexturedModalRect(int var1, int var2, int var3, int var4, int var5, int var6) {
        this.ApplyColor();
        this.gui.drawSizedTexturedModalRect(var1, var2, var3, var4, var5, var6, this.texW, this.texH);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GlStateManager.func_179147_l();
        this.ApplyColor();
        super.drawBackground(mouseX, mouseY, gameTicks);
        this.drawIcon(this.stat.getIcon(this.level), this.posX + 3, this.posY + 3);
        if (this.direction != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
            GlStateManager.func_179109_b((float)(this.sizeX / 2), (float)(this.sizeY / 2), (float)0.0f);
            GlStateManager.func_179137_b((double)((double)this.direction.func_82601_c() * ((double)this.sizeX * 0.75)), (double)((double)(-this.direction.func_96559_d()) * ((double)this.sizeY * 0.75)), (double)0.0);
            if (this.direction == EnumFacing.EAST) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (this.direction == EnumFacing.WEST) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (this.direction == EnumFacing.DOWN) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.strongConnection) {
                GlStateManager.func_179137_b((double)-3.5, (double)-26.0, (double)0.0);
                if (this.stat.isLocked(this.player, this.level)) {
                    RenderUtils.bindTexture(this.strongConnectionBrokenTex);
                } else {
                    RenderUtils.bindTexture(this.strongConnectionTex);
                }
                RenderUtils.drawPlane(7.0, 30.0);
            } else {
                GlStateManager.func_179137_b((double)-3.5, (double)-3.5, (double)0.0);
                ClientProxy.holoIcons.renderIcon("up_arrow", 0.0, 0.0);
            }
            GlStateManager.func_179121_F();
        }
        this.ResetColor();
        GlStateManager.func_179084_k();
    }

    @Override
    public void drawForeground(int x, int y) {
        if (this.stat.maxLevel() > 1 && this.level > 0) {
            String levelInfo = Integer.toString(this.level);
            ClientProxy.holoIcons.renderIcon("black_circle", (double)(this.posX + 14), (double)(this.posY + 14), 10, 10);
            this.getFontRenderer().func_78276_b(levelInfo, this.posX + 16, this.posY + 16, 0xFFFFFF);
        }
    }

    public void drawIcon(HoloIcon icon, int x, int y) {
        if (icon != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            ClientProxy.holoIcons.renderIcon(icon, (double)x, (double)y, 16, 16);
            GlStateManager.func_179084_k();
        }
    }

    public IBioticStat getStat() {
        return this.stat;
    }

    public void setStrongConnection(boolean strongConnection) {
        this.strongConnection = strongConnection;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }
}

