/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import java.util.HashSet;
import java.util.Set;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;

public class GuideCategory {
    private String name;
    private Set<MOGuideEntry> entries;
    private String holoIcon;

    public GuideCategory(String name) {
        this.name = name;
        this.entries = new HashSet<MOGuideEntry>();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return MOStringHelper.translateToLocal(String.format("guide.category.%s.name", this.name), new Object[0]);
    }

    public void addEntry(MOGuideEntry entry) {
        this.entries.add(entry);
    }

    public HoloIcon getHoloIcon() {
        return ClientProxy.holoIcons.getIcon(this.holoIcon);
    }

    public GuideCategory setHoloIcon(String holoIcon) {
        this.holoIcon = holoIcon;
        return this;
    }

    public Set<MOGuideEntry> getEntries() {
        return this.entries;
    }
}

