/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.MOEventDialogConstruct;
import matteroverdrive.api.events.MOEventDialogInteract;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.VersionCheckerHandler;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerEventHandler {
    public final List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
    private final VersionCheckerHandler versionCheckerHandler = new VersionCheckerHandler();

    public PlayerEventHandler(ConfigurationHandler configurationHandler) {
        configurationHandler.subscribe(this.versionCheckerHandler);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            if (MatterOverdrive.MATTER_REGISTRY.hasComplitedRegistration) {
                if (!event.player.func_184102_h().func_71264_H()) {
                    MatterOverdrive.NETWORK.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.MATTER_REGISTRY), (EntityPlayerMP)event.player);
                }
            } else {
                this.players.add((EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        OverdriveExtendedProperties extendedProperties;
        AndroidPlayer player;
        ItemStack itemstack;
        if (event.phase == TickEvent.Phase.START && event.player.func_184587_cr() && event.side == Side.CLIENT && event.player.func_184600_cs() == EnumHand.MAIN_HAND && !(itemstack = event.player.field_71071_by.func_70448_g()).func_190926_b() && itemstack.func_77973_b() instanceof IWeapon && event.player.func_184605_cv() > 0) {
            event.player.func_184602_cy();
            event.player.func_184598_c(EnumHand.MAIN_HAND);
        }
        if ((player = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.player)) != null && event.phase.equals((Object)TickEvent.Phase.START)) {
            if (event.side == Side.CLIENT) {
                this.onAndroidTickClient(player, event);
            } else {
                this.onAndroidServerTick(player, event);
            }
        }
        if ((extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.player)) != null && event.phase.equals((Object)TickEvent.Phase.START)) {
            if (event.side == Side.CLIENT) {
                extendedProperties.update(Side.CLIENT);
            } else {
                extendedProperties.update(Side.SERVER);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAndroidTickClient(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.func_71410_x().field_71439_g) {
            androidPlayer.onAndroidTick(event.side);
        }
    }

    private void onAndroidServerTick(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        androidPlayer.onAndroidTick(event.side);
    }

    @SubscribeEvent
    public void onPlayerLoadFromFile(PlayerEvent.LoadFromFile event) {
        AndroidPlayer player = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityPlayer());
        if (player != null) {
            player.onPlayerLoad(event);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() != null) {
            OverdriveExtendedProperties extendedProperties;
            AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityPlayer());
            if (androidPlayer != null && androidPlayer.isAndroid()) {
                androidPlayer.sync(event.getEntityPlayer(), EnumSet.allOf(IAndroid.DataType.class), false);
            }
            if ((extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
                extendedProperties.sync(EnumSet.allOf(PlayerQuestData.DataType.class));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent deathEvent) {
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (MatterOverdrive.MATTER_REGISTRY.hasComplitedRegistration) {
            for (int i = 0; i < MatterOverdrive.PLAYER_EVENT_HANDLER.players.size(); ++i) {
                MatterOverdrive.NETWORK.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.MATTER_REGISTRY), MatterOverdrive.PLAYER_EVENT_HANDLER.players.get(i));
            }
            MatterOverdrive.PLAYER_EVENT_HANDLER.players.clear();
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null) {
            if (event.player.field_70170_p.field_72995_K) {
                if (!event.crafting.func_190926_b() && event.crafting.func_77973_b() instanceof MOBaseItem) {
                    // empty if block
                }
            } else {
                OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.player);
                if (extendedProperties != null) {
                    extendedProperties.onEvent((Event)event);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntityPlayer() != null && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability(event.getEntity())) != null && androidPlayer.isAndroid()) {
            androidPlayer.triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onPlayerScanEvent(MOEventScan event) {
        OverdriveExtendedProperties extendedProperties;
        if (event.getSide() == Side.SERVER && event.getEntityPlayer() != null && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onBioticStatUse(MOEventBionicStat event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilUpdateEvent event) {
        if (!event.getLeft().func_190926_b() && !event.getRight().func_190926_b() && event.getLeft().func_77973_b() == MatterOverdrive.ITEMS.portableDecomposer) {
            event.setOutput(event.getLeft().func_77946_l());
            event.setMaterialCost(1);
            event.setCost(3);
            MatterOverdrive.ITEMS.portableDecomposer.addStackToList(event.getOutput(), event.getRight());
        }
    }

    @SubscribeEvent
    public void onPlayerBlockInteract(PlayerInteractEvent event) {
        OverdriveExtendedProperties extendedProperties;
        if (!event.getWorld().field_72995_K && event.getEntityPlayer() != null && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent event) {
        OverdriveExtendedProperties extendedProperties;
        if (event.getEntityPlayer() != null && !event.getEntityPlayer().field_70170_p.field_72995_K && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onDialogMessageInteract(MOEventDialogInteract event) {
        OverdriveExtendedProperties extendedProperties;
        if (event.getEntityPlayer() != null && event.side.equals((Object)Side.SERVER) && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onDialogMessageConstruct(MOEventDialogConstruct event) {
        OverdriveExtendedProperties extendedProperties;
        if (event.getEntityPlayer() != null && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }
}

