/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.internal.OreDictItem;
import matteroverdrive.items.Battery;
import matteroverdrive.items.Contract;
import matteroverdrive.items.CreativeBattery;
import matteroverdrive.items.DataPad;
import matteroverdrive.items.IsolinearCircuit;
import matteroverdrive.items.ItemRecordTransformation;
import matteroverdrive.items.ItemUpgrade;
import matteroverdrive.items.MatterContainer;
import matteroverdrive.items.MatterDust;
import matteroverdrive.items.MatterItem;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.items.NetworkFlashDrive;
import matteroverdrive.items.PatternDrive;
import matteroverdrive.items.PortableDecomposer;
import matteroverdrive.items.SecurityProtocol;
import matteroverdrive.items.SpacetimeEqualizer;
import matteroverdrive.items.TransportFlashDrive;
import matteroverdrive.items.Wrench;
import matteroverdrive.items.android.RougeAndroidParts;
import matteroverdrive.items.android.TritaniumSpine;
import matteroverdrive.items.armour.TritaniumArmor;
import matteroverdrive.items.food.AndroidPill;
import matteroverdrive.items.food.EarlGrayTea;
import matteroverdrive.items.food.MOItemFood;
import matteroverdrive.items.food.RomulanAle;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.items.includes.MOItemOre;
import matteroverdrive.items.tools.TritaniumAxe;
import matteroverdrive.items.tools.TritaniumHoe;
import matteroverdrive.items.tools.TritaniumPickaxe;
import matteroverdrive.items.tools.TritaniumShovel;
import matteroverdrive.items.tools.TritaniumSword;
import matteroverdrive.items.weapon.EnergyPack;
import matteroverdrive.items.weapon.IonSniper;
import matteroverdrive.items.weapon.OmniTool;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.items.weapon.PhaserRifle;
import matteroverdrive.items.weapon.PlasmaShotgun;
import matteroverdrive.items.weapon.module.WeaponModuleBarrel;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.items.weapon.module.WeaponModuleHoloSights;
import matteroverdrive.items.weapon.module.WeaponModuleRicochet;
import matteroverdrive.items.weapon.module.WeaponModuleSniperScope;
import matteroverdrive.util.MOLog;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MatterOverdriveItems {
    public static final Item.ToolMaterial TOOL_MATERIAL_TRITANIUM = EnumHelper.addToolMaterial((String)"TRITANIUM", (int)2, (int)3122, (float)6.0f, (float)2.0f, (int)14);
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_TRITANIUM = EnumHelper.addArmorMaterial((String)"TRITANIUM", (String)"tritanium", (int)66, (int[])new int[]{4, 9, 7, 4}, (int)20, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
    public static List<Item> items = new ArrayList<Item>();
    public MOItemOre dilithium_crystal;
    public MOItemOre tritanium_ingot;
    public MOItemOre tritanium_nugget;
    public MOItemOre tritanium_dust;
    public MOBaseItem tritanium_plate;
    public MatterDust matter_dust;
    public MatterDust matter_dust_refined;
    public AndroidPill androidPill;
    public MOItemFood emergency_ration;
    public EarlGrayTea earl_gray_tea;
    public RomulanAle romulan_ale;
    public Battery battery;
    public Battery hc_battery;
    public Battery creative_battery;
    public MatterContainer matterContainer;
    public MOBaseItem me_conversion_matrix;
    public MOBaseItem h_compensator;
    public MOBaseItem integration_matrix;
    public MOBaseItem machine_casing;
    public MOBaseItem s_magnet;
    public IsolinearCircuit isolinear_circuit;
    public MOBaseItem forceFieldEmitter;
    public MOBaseItem weaponHandle;
    public MOBaseItem weaponReceiver;
    public MOBaseItem plasmaCore;
    public MatterItem matterItem;
    public Phaser phaser;
    public PhaserRifle phaserRifle;
    public PlasmaShotgun plasmaShotgun;
    public IonSniper ionSniper;
    public OmniTool omniTool;
    public WeaponModuleColor weapon_module_color;
    public WeaponModuleBarrel weapon_module_barrel;
    public WeaponModuleSniperScope sniperScope;
    public WeaponModuleRicochet weaponModuleRicochet;
    public WeaponModuleHoloSights weaponModuleHoloSights;
    public Wrench wrench;
    public TritaniumAxe tritaniumAxe;
    public TritaniumPickaxe tritaniumPickaxe;
    public TritaniumSword tritaniumSword;
    public TritaniumHoe tritaniumHoe;
    public TritaniumShovel tritaniumShovel;
    public TritaniumArmor tritaniumHelmet;
    public TritaniumArmor tritaniumChestplate;
    public TritaniumArmor tritaniumLeggings;
    public TritaniumArmor tritaniumBoots;
    public RougeAndroidParts androidParts;
    public TritaniumSpine tritaniumSpine;
    public MatterScanner matter_scanner;
    public PatternDrive pattern_drive;
    public NetworkFlashDrive networkFlashDrive;
    public ItemUpgrade item_upgrade;
    public TransportFlashDrive transportFlashDrive;
    public EnergyPack energyPack;
    public DataPad dataPad;
    public Contract contract;
    public PortableDecomposer portableDecomposer;
    public SecurityProtocol security_protocol;
    public SpacetimeEqualizer spacetime_equalizer;
    public ItemRecordTransformation recordTransformation;
    public MOBaseItem trilithiumCrystal;
    public MOBaseItem artifact;
    public MOBaseItem quantumFoldManipulator;
    private int registeredCount = 0;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        items.forEach(i -> event.getRegistry().register((IForgeRegistryEntry)i));
        items.stream().filter(item -> item instanceof OreDictItem).forEach(item -> ((OreDictItem)item).registerOreDict());
    }

    private static void addToDungons(Item item, int min, int max, int chance) {
    }

    public void init() {
        MOLog.info("Registering items", new Object[0]);
        this.dilithium_crystal = this.register(new MOItemOre("dilithium_crystal", "gemDilithium"));
        this.tritanium_ingot = this.register(new MOItemOre("tritanium_ingot", "ingotTritanium"));
        this.tritanium_nugget = this.register(new MOItemOre("tritanium_nugget", "nuggetTritanium"));
        this.tritanium_dust = this.register(new MOItemOre("tritanium_dust", "dustTritanium"));
        this.tritanium_plate = this.register(new MOBaseItem("tritanium_plate"));
        this.matter_dust = this.register(new MatterDust("matter_dust", "matterDust", false));
        this.matter_dust_refined = this.register(new MatterDust("matter_dust_refined", "matterDustRefined", true));
        this.androidPill = this.register(new AndroidPill("android_pill"));
        this.emergency_ration = this.register(new MOItemFood("emergency_ration", 8, 0.8f, false));
        this.earl_gray_tea = this.register(new EarlGrayTea("earl_gray_tea"));
        this.romulan_ale = this.register(new RomulanAle("romulan_ale"));
        this.battery = this.register(new Battery("battery", 524288, 400, 800));
        this.hc_battery = this.register(new Battery("hc_battery", 0x100000, 4096, 4096));
        this.creative_battery = this.register(new CreativeBattery("creative_battery"));
        this.matterContainer = this.register(new MatterContainer("matter_container"));
        this.me_conversion_matrix = this.register(new MOBaseItem("me_conversion_matrix"));
        this.h_compensator = this.register(new MOBaseItem("h_compensator"));
        this.integration_matrix = this.register(new MOBaseItem("integration_matrix"));
        this.machine_casing = this.register(new MOBaseItem("machine_casing"));
        this.s_magnet = this.register(new MOBaseItem("s_magnet"));
        this.isolinear_circuit = this.register(new IsolinearCircuit("isolinear_circuit"));
        this.matterItem = this.register(new MatterItem("matter"));
        this.forceFieldEmitter = this.register(new MOBaseItem("forcefield_emitter"));
        this.weaponHandle = this.register(new MOBaseItem("weapon_handle"));
        this.weaponReceiver = this.register(new MOBaseItem("weapon_receiver"));
        this.plasmaCore = this.register(new MOBaseItem("plasma_core"));
        this.phaser = this.register(new Phaser("phaser"));
        this.phaserRifle = this.register(new PhaserRifle("phaser_rifle"));
        this.plasmaShotgun = this.register(new PlasmaShotgun("plasma_shotgun"));
        this.ionSniper = this.register(new IonSniper("ion_sniper"));
        this.omniTool = this.register(new OmniTool("omni_tool"));
        this.weapon_module_color = this.register(new WeaponModuleColor("weapon_module_color"));
        this.weapon_module_barrel = this.register(new WeaponModuleBarrel("weapon_module_barrel"));
        this.sniperScope = this.register(new WeaponModuleSniperScope("sniper_scope"));
        this.weaponModuleRicochet = this.register(new WeaponModuleRicochet("weapon_module_ricochet"));
        this.weaponModuleHoloSights = this.register(new WeaponModuleHoloSights("weapon_module_holo_sights"));
        this.wrench = this.register(new Wrench("tritanium_wrench"));
        this.tritaniumAxe = this.register(new TritaniumAxe("tritanium_axe"));
        this.tritaniumPickaxe = this.register(new TritaniumPickaxe("tritanium_pickaxe"));
        this.tritaniumSword = this.register(new TritaniumSword("tritanium_sword"));
        this.tritaniumHoe = this.register(new TritaniumHoe("tritanium_hoe"));
        this.tritaniumShovel = this.register(new TritaniumShovel("tritanium_shovel"));
        this.tritaniumHelmet = this.register(new TritaniumArmor("tritanium_helmet", ARMOR_MATERIAL_TRITANIUM, 2, EntityEquipmentSlot.HEAD));
        this.tritaniumChestplate = this.register(new TritaniumArmor("tritanium_chestplate", ARMOR_MATERIAL_TRITANIUM, 2, EntityEquipmentSlot.CHEST));
        this.tritaniumLeggings = this.register(new TritaniumArmor("tritanium_leggings", ARMOR_MATERIAL_TRITANIUM, 2, EntityEquipmentSlot.LEGS));
        this.tritaniumBoots = this.register(new TritaniumArmor("tritanium_boots", ARMOR_MATERIAL_TRITANIUM, 2, EntityEquipmentSlot.FEET));
        this.androidParts = this.register(new RougeAndroidParts("rogue_android_part"));
        this.tritaniumSpine = this.register(new TritaniumSpine("tritanium_spine"));
        this.matter_scanner = this.register(new MatterScanner("matter_scanner"));
        this.pattern_drive = this.register(new PatternDrive("pattern_drive", 2));
        this.networkFlashDrive = this.register(new NetworkFlashDrive("network_flash_drive"));
        this.item_upgrade = this.register(new ItemUpgrade("upgrade"));
        this.transportFlashDrive = this.register(new TransportFlashDrive("transport_flash_drive"));
        this.energyPack = this.register(new EnergyPack("energy_pack"));
        this.dataPad = this.register(new DataPad("data_pad"));
        this.contract = this.register(new Contract("contract"));
        this.portableDecomposer = this.register(new PortableDecomposer("portable_decomposer", 512, 0.1f));
        this.security_protocol = this.register(new SecurityProtocol("security_protocol"));
        this.spacetime_equalizer = this.register(new SpacetimeEqualizer("spacetime_equalizer"));
        this.recordTransformation = this.register(new ItemRecordTransformation());
        this.artifact = this.register(new MOBaseItem("artifact"));
        this.trilithiumCrystal = this.register(new MOBaseItem("trilithium_crystal"));
        this.quantumFoldManipulator = this.register(new MOBaseItem("quantum_fold_manipulator"));
        ((Item.ToolMaterial)Preconditions.checkNotNull((Object)TOOL_MATERIAL_TRITANIUM)).setRepairItem(new ItemStack((Item)this.tritanium_ingot));
        ((ItemArmor.ArmorMaterial)Preconditions.checkNotNull((Object)ARMOR_MATERIAL_TRITANIUM)).setRepairItem(new ItemStack((Item)this.tritanium_ingot));
        MOLog.info("Finished registering items", new Object[0]);
        MOLog.info("Registered %d items", this.registeredCount);
    }

    protected <T extends Item> T register(T item) {
        items.add(item);
        ++this.registeredCount;
        return item;
    }

    public void addToDungons() {
        this.weapon_module_color.addToDunguns();
        this.addToMODungons();
    }

    public void addToMODungons() {
    }
}

