/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOPhysicsHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DataPad
extends MOBaseItem
implements IBlockScanner {
    @SideOnly(value=Side.CLIENT)
    private static MachineSound scanningSound;

    public DataPad(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K && this.hasGui(itemStackIn)) {
            this.openGui(handIn, itemStackIn);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.func_70093_af() && worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && this.canScan(stack, worldIn.func_180495_p(pos))) {
            playerIn.func_184598_c(hand);
            if (worldIn.field_72995_K) {
                this.playSound(playerIn.func_180425_c());
            } else {
                this.setLastBlock(stack, worldIn.func_180495_p(pos).func_177230_c());
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public int func_77626_a(ItemStack scanner) {
        return 40;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EnumHand hand, ItemStack stack) {
        try {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataPad(hand, stack));
        }
        catch (Exception e) {
            MOLog.error("There was a problem while trying to open the Data Pad Gui", e, new Object[0]);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        EntityPlayer player;
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
        if (world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_184587_cr()) {
            this.stopScanSounds();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        if (worldIn.field_72995_K) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventScan((EntityPlayer)entityLiving, stack, this.getScanningPos(stack, entityLiving)))) {
                this.stopScanSounds();
            }
        } else {
            MOEventScan event = new MOEventScan((EntityPlayer)entityLiving, stack, this.getScanningPos(stack, entityLiving));
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (this.destroysBlocks(stack) && worldIn.func_175660_a((EntityPlayer)entityLiving, event.position.func_178782_a())) {
                    worldIn.func_175698_g(event.position.func_178782_a());
                }
                SoundHandler.PlaySoundAt(worldIn, MatterOverdriveSounds.scannerSuccess, SoundCategory.PLAYERS, (Entity)entityLiving);
            }
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        RayTraceResult hit = this.getScanningPos(stack, player);
        if (hit != null) {
            Block lastBlock;
            if (hit.field_72313_a == RayTraceResult.Type.BLOCK && (lastBlock = this.getLastBlock(stack)) != null && lastBlock != player.field_70170_p.func_180495_p(hit.func_178782_a()).func_177230_c()) {
                player.func_184597_cx();
            }
        } else if (player.field_70170_p.field_72995_K) {
            this.stopScanSounds();
            player.func_184597_cx();
        }
    }

    public Block getLastBlock(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return Block.func_149729_e((int)itemStack.func_77978_p().func_74762_e("LastBlock"));
        }
        return null;
    }

    public void setLastBlock(ItemStack itemStack, Block block) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        int blockID = Block.func_149682_b((Block)block);
        if (itemStack.func_77978_p().func_74762_e("LastBlock") != blockID) {
            itemStack.func_77978_p().func_74768_a("LastBlock", blockID);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (world.field_72995_K) {
            this.stopScanSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(BlockPos pos) {
        if (scanningSound == null) {
            scanningSound = new MachineSound(MatterOverdriveSounds.scannerScanning, SoundCategory.PLAYERS, pos, 0.6f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)scanningSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopScanSounds() {
        if (scanningSound != null) {
            scanningSound.stopPlaying();
            scanningSound = null;
        }
    }

    @Override
    public RayTraceResult getScanningPos(ItemStack itemStack, EntityLivingBase player) {
        return MOPhysicsHelper.rayTrace(player, player.field_70170_p, 5.0, 0.0f, new Vec3d(0.0, (double)player.func_70047_e(), 0.0), true, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    public void addToScanWhitelist(ItemStack itemStack, Block block) {
        String id = block.getRegistryName().toString();
        NBTTagList list = itemStack.func_77978_p().func_150295_c("whitelist", 8);
        list.func_74742_a((NBTBase)new NBTTagString(id));
        itemStack.func_77978_p().func_74782_a("whitelist", (NBTBase)list);
    }

    public void setOrdering(ItemStack stack, int order) {
        stack.func_77983_a("Ordering", (NBTBase)new NBTTagInt(order));
    }

    public void setOpenGuide(ItemStack stack, int guideID) {
        stack.func_77983_a("guideID", (NBTBase)new NBTTagInt(guideID));
    }

    public void setOpenPage(ItemStack stack, int page) {
        stack.func_77983_a("page", (NBTBase)new NBTTagInt(page));
    }

    public void setCategory(ItemStack stack, String category) {
        stack.func_77983_a("Category", (NBTBase)new NBTTagString(category));
    }

    public void setSelectedActiveQuest(ItemStack itemStack, int quest) {
        itemStack.func_77983_a("SelectedActiveQuest", (NBTBase)new NBTTagShort((short)quest));
    }

    public int getGuideID(ItemStack stack) {
        this.TagCompountCheck(stack);
        if (this.hasOpenGuide(stack)) {
            return stack.func_77978_p().func_74762_e("guideID");
        }
        return -1;
    }

    public int getPage(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_74762_e("page");
    }

    public boolean hasOpenGuide(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_150297_b("guideID", 3);
    }

    public int getOrdering(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Ordering", 8)) {
            return stack.func_77978_p().func_74762_e("Ordering");
        }
        return 2;
    }

    public String getCategory(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("Category");
        }
        return "";
    }

    public int getActiveSelectedQuest(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74765_d("SelectedActiveQuest");
        }
        return 0;
    }

    @Override
    public boolean destroysBlocks(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Destroys");
    }

    @Override
    public boolean showsGravitationalWaves(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("showGravWaves")) {
            return itemStack.func_77978_p().func_74767_n("showGravWaves");
        }
        return true;
    }

    public boolean canScan(ItemStack itemStack, IBlockState state) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_150297_b("whitelist", 9)) {
            NBTTagList tagList = itemStack.func_77978_p().func_150295_c("whitelist", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                if (!tagList.func_150307_f(i).equals(state.func_177230_c().getRegistryName().toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasGui(ItemStack itemStack) {
        return itemStack.func_77978_p() == null || !itemStack.func_77978_p().func_74767_n("nogui");
    }
}

