/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterContainer
extends MOBaseItem {
    public MatterContainer(String name) {
        super(name);
        this.func_77625_d(8);
    }

    public ItemStack getFullStack() {
        ItemStack full = new ItemStack((Item)this);
        ((IFluidHandler)full.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(new FluidStack((Fluid)OverdriveFluids.matterPlasma, 1000), true);
        return full;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public String func_77667_c(ItemStack stack) {
        FluidStack result = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, false);
        return super.func_77667_c(stack) + (result == null ? "_empty" : "_full");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack result = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, false);
        int amount = result == null ? 0 : result.amount;
        tooltip.add("Amount: " + amount);
    }

    @Override
    public void initItemModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            FluidStack result = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, false);
            int amount = result == null ? 0 : result.amount;
            float percent = (float)amount / 1000.0f;
            return new ModelResourceLocation(this.getRegistryName(), percent == 1.0f ? "level=full" : (percent > 0.0f ? "level=partial" : "level=empty"));
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), "level=full"), new ModelResourceLocation(this.getRegistryName(), "level=partial"), new ModelResourceLocation(this.getRegistryName(), "level=empty")});
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            subItems.add((Object)this.getFullStack());
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new MatterContainerCapabilityProvider();
    }

    public static class MatterContainerCapabilityProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private FluidTank tank = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid.getFluid() == OverdriveFluids.matterPlasma;
            }
        };

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.tank : null);
        }

        public NBTTagCompound serializeNBT() {
            return this.tank.writeToNBT(new NBTTagCompound());
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.tank.readFromNBT(tag);
        }
    }
}

