/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter.IMatterItem;
import matteroverdrive.api.matter.IRecyclable;
import matteroverdrive.items.includes.MOItemOre;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MatterDust
extends MOItemOre
implements IRecyclable,
IMatterItem {
    final boolean isRefined;

    public MatterDust(String name, String oreDict, boolean refined) {
        super(name, oreDict);
        this.isRefined = refined;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        if (!this.isRefined) {
            infos.add(TextFormatting.BLUE + "Potential Matter: " + MatterHelper.formatMatter(itemstack.func_77952_i()));
        }
    }

    public int getDamage(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_74762_e("Matter");
    }

    public void setMatter(ItemStack itemStack, int matter) {
        this.TagCompountCheck(itemStack);
        itemStack.func_77978_p().func_74768_a("Matter", matter);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return !this.isRefined;
    }

    @Override
    public ItemStack getOutput(ItemStack from) {
        ItemStack newItemStack = new ItemStack((Item)MatterOverdrive.ITEMS.matter_dust_refined);
        MatterOverdrive.ITEMS.matter_dust_refined.setMatter(newItemStack, from.func_77952_i());
        return newItemStack;
    }

    @Override
    public int getRecycleMatter(ItemStack stack) {
        return stack.func_77952_i();
    }

    @Override
    public boolean canRecycle(ItemStack stack) {
        return stack.func_77973_b() instanceof MatterDust && !((MatterDust)stack.func_77973_b()).isRefined;
    }

    @Override
    public int getMatter(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof MatterDust && ((MatterDust)itemStack.func_77973_b()).isRefined ? itemStack.func_77952_i() : 0;
    }
}

