/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import matteroverdrive.items.IAdvancedModelProvider;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecurityProtocol
extends MOBaseItem
implements IAdvancedModelProvider {
    public static final String[] types = new String[]{"empty", "claim", "access", "remove"};

    public SecurityProtocol(String name) {
        super(name);
        this.func_77625_d(16);
    }

    @Override
    public String[] getSubNames() {
        return types;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        if (itemstack.func_77942_o()) {
            try {
                EntityPlayer entityPlayer = player.field_70170_p.func_152378_a(UUID.fromString(itemstack.func_77978_p().func_74779_i("Owner")));
                if (entityPlayer != null) {
                    String owner = entityPlayer.func_146103_bH().getName();
                    infos.add(TextFormatting.YELLOW + "Owner: " + owner);
                }
            }
            catch (Exception e) {
                infos.add(TextFormatting.RED + MOStringHelper.translateToLocal(this.func_77658_a() + ".invalid", new Object[0]));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + types[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)types.length)];
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (!itemStackIn.func_77942_o()) {
            if (playerIn.func_70093_af()) {
                this.TagCompountCheck(itemStackIn);
                itemStackIn.func_77978_p().func_74778_a("Owner", playerIn.func_146103_bH().getId().toString());
                itemStackIn.func_77964_b(1);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        } else if ((itemStackIn.func_77978_p().func_74779_i("Owner").equals(playerIn.func_146103_bH().getId().toString()) || playerIn.field_71075_bZ.field_75098_d) && playerIn.func_70093_af()) {
            int damage = itemStackIn.func_77952_i() + 1;
            if (damage >= types.length) {
                damage = 1;
            }
            itemStackIn.func_77964_b(damage);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof MOTileEntityMachine) {
            if (stack.func_77952_i() == 1) {
                if (((MOTileEntityMachine)tileEntity).claim(stack)) {
                    stack.func_190918_g(1);
                    return EnumActionResult.SUCCESS;
                }
            } else if (stack.func_77952_i() == 3 && ((MOTileEntityMachine)tileEntity).unclaim(stack)) {
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Owner");
    }
}

