/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.android;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.client.render.entity.EntityRendererRangedRougeAndroid;
import matteroverdrive.client.render.entity.EntityRendererRougeAndroid;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.items.IAdvancedModelProvider;
import matteroverdrive.items.android.BionicPart;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RougeAndroidParts
extends BionicPart
implements IBionicPart,
IAdvancedModelProvider {
    public static final String[] names = new String[]{"head", "arms", "legs", "chest"};
    final String[] healtModifiersIDs = new String[]{"1bb8df41-63d1-4f58-92c4-43adea7528b2", "73983b14-e605-40be-8567-36a9dec51d4f", "29419afc-63ad-4b74-87e2-38219e867119", "e4b38c80-7407-48fd-b837-8f36ae516c4d"};

    public RougeAndroidParts(String name) {
        super(name);
        this.func_77627_a(true);
    }

    @Override
    public String[] getSubNames() {
        return names;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        if (itemstack.func_77978_p() != null) {
            if (itemstack.func_77978_p().func_74771_c("Type") == 1) {
                infos.add(TextFormatting.AQUA + MOStringHelper.translateToLocal("item.matteroverdrive.rogue_android_part.range", new Object[0]));
            } else {
                infos.add(TextFormatting.GOLD + MOStringHelper.translateToLocal("item.matteroverdrive.rogue_android_part.melee", new Object[0]));
            }
        } else {
            infos.add(TextFormatting.GOLD + MOStringHelper.translateToLocal("item.matteroverdrive.rogue_android_part.melee", new Object[0]));
        }
        super.addDetails(itemstack, player, worldIn, infos);
    }

    public String func_77667_c(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)3);
        return super.func_77658_a() + "." + names[MathHelper.func_76125_a((int)i, (int)0, (int)(names.length - 1))];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (this.func_194125_a(creativeTabs)) {
            for (byte t = 0; t < 2; t = (byte)((byte)(t + 1))) {
                for (int i = 0; i < names.length; ++i) {
                    ItemStack stack = new ItemStack((Item)this, 1, i);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74774_a("Type", t);
                    list.add((Object)stack);
                }
            }
        }
    }

    @Override
    public int getType(ItemStack itemStack) {
        return itemStack.func_77952_i();
    }

    @Override
    public boolean affectAndroid(AndroidPlayer player, ItemStack itemStack) {
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers(AndroidPlayer player, ItemStack itemStack) {
        Multimap<String, AttributeModifier> multimap = super.getModifiers(player, itemStack);
        if (multimap.isEmpty()) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(this.healtModifiersIDs[itemStack.func_77952_i()]), MOStringHelper.translateToLocal("attribute.name." + SharedMonsterAttributes.field_111267_a.func_111108_a(), new Object[0]), 1.0, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture(AndroidPlayer androidPlayer, ItemStack itemStack) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74771_c("Type") == 1) {
            return EntityRendererRangedRougeAndroid.texture;
        }
        return EntityRendererRougeAndroid.TEXTURE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getModel(AndroidPlayer androidPlayer, ItemStack itemStack) {
        int type = this.getType(itemStack);
        ModelBiped model = ClientProxy.renderHandler.modelMeleeRogueAndroidParts;
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74771_c("Type") == 1) {
            model = ClientProxy.renderHandler.modelRangedRogueAndroidParts;
        }
        model.field_78116_c.field_78806_j = type == 0;
        model.field_178720_f.field_78806_j = type == 0;
        model.field_78115_e.field_78806_j = type == 3;
        model.field_178723_h.field_78806_j = type == 1;
        model.field_178724_i.field_78806_j = type == 1;
        model.field_178721_j.field_78806_j = type == 2;
        model.field_178722_k.field_78806_j = type == 2;
        return model;
    }
}

